/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import javax.annotation.Nullable;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFluidLoader;
import minecrafttransportsimulator.mcinterface.BuilderTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BuilderTileEntityFluidTank<FluidTankTileEntity extends ATileEntityBase<?>>
extends BuilderTileEntity<FluidTankTileEntity>
implements IFluidTank,
IFluidHandler {
    @Override
    public void func_73660_a() {
        IFluidHandler fluidHandler;
        int amountDrained;
        TileEntity teBelow;
        int currentFluidAmount;
        super.func_73660_a();
        if (this.tileEntity != null && this.tileEntity instanceof TileEntityFluidLoader && ((TileEntityFluidLoader)this.tileEntity).isUnloader() && (currentFluidAmount = this.getFluidAmount()) > 0 && (teBelow = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) != null && teBelow.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) && (amountDrained = (fluidHandler = (IFluidHandler)teBelow.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)).fill(this.getFluid(), true)) > 0 && currentFluidAmount == this.getFluidAmount()) {
            this.drain(amountDrained, true);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{this.getInfo()});
    }

    public FluidStack getFluid() {
        return this.tileEntity != null && !((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().getFluid().isEmpty() ? new FluidStack(FluidRegistry.getFluid((String)((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().getFluid()), (int)((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().getFluidLevel()) : null;
    }

    public int getFluidAmount() {
        return (int)(this.tileEntity != null ? ((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().getFluidLevel() : 0.0);
    }

    public int getCapacity() {
        return this.tileEntity != null ? ((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().getMaxLevel() : 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack stack, boolean doFill) {
        if (this.tileEntity != null) {
            int fillAmount = (int)((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().fill(stack.getFluid().getName(), stack.amount, doFill);
            if (fillAmount > 0 && doFill) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(new FluidStack(stack.getFluid(), fillAmount), this.field_145850_b, this.func_174877_v(), (IFluidTank)this, fillAmount));
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getFluidAmount() > 0) {
            return this.drain(new FluidStack(this.getFluid().getFluid(), maxDrain), doDrain);
        }
        return null;
    }

    public FluidStack drain(FluidStack stack, boolean doDrain) {
        int drainAmount = (int)(this.tileEntity != null ? ((ITileEntityFluidTankProvider)((Object)this.tileEntity)).getTank().drain(stack.getFluid().getName(), stack.amount, doDrain) : 0.0);
        if (drainAmount > 0 && doDrain) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(new FluidStack(stack.getFluid(), drainAmount), this.field_145850_b, this.func_174877_v(), (IFluidTank)this, drainAmount));
        }
        return new FluidStack(stack.getFluid(), drainAmount);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && EnumFacing.DOWN.equals((Object)facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && EnumFacing.DOWN.equals((Object)facing)) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

