/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MasterLoader;
import minecrafttransportsimulator.mcinterface.BuilderEntityExisting;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class InterfaceChunkloader
implements ForgeChunkManager.LoadingCallback {
    private static Map<BuilderEntityExisting, ForgeChunkManager.Ticket> entityTickets = new HashMap<BuilderEntityExisting, ForgeChunkManager.Ticket>();
    public static final InterfaceChunkloader INSTANCE = new InterfaceChunkloader();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket modTicket : tickets) {
            if (!modTicket.getModId().equals("mts") || !((Boolean)ConfigSystem.configObject.general.chunkloadVehicles.value).booleanValue()) continue;
            modTicket.setChunkListDepth(1);
            if (!modTicket.getType().equals((Object)ForgeChunkManager.Type.ENTITY)) continue;
            entityTickets.put((BuilderEntityExisting)modTicket.getEntity(), modTicket);
        }
    }

    public static void removeEntityTicket(BuilderEntityExisting entity) {
        if (!entity.field_70170_p.field_72995_K && entityTickets.containsKey((Object)entity)) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)entityTickets.get((Object)entity));
            entityTickets.remove((Object)entity);
        }
    }

    @SubscribeEvent
    public static void onWorldUnloadEvent(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            Iterator<BuilderEntityExisting> iterator = entityTickets.keySet().iterator();
            while (iterator.hasNext()) {
                BuilderEntityExisting builder = iterator.next();
                if (builder == null || builder.field_70170_p.field_73011_w.getDimension() != event.getWorld().field_73011_w.getDimension()) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && ((Boolean)ConfigSystem.configObject.general.chunkloadVehicles.value).booleanValue()) {
            for (int i = 0; i < event.world.field_72996_f.size(); ++i) {
                Entity entity = (Entity)event.world.field_72996_f.get(i);
                if (!(entity instanceof BuilderEntityExisting)) continue;
                BuilderEntityExisting builder = (BuilderEntityExisting)entity;
                if (builder.entity == null) continue;
                if (!builder.field_70128_L && builder.entity.needsChunkloading()) {
                    if (entityTickets.containsKey((Object)builder)) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)entityTickets.get((Object)builder), (ChunkPos)new ChunkPos(builder.field_70176_ah, builder.field_70164_aj));
                        continue;
                    }
                    ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)MasterLoader.INSTANCE, (World)builder.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
                    if (ticket == null) continue;
                    ticket.setChunkListDepth(1);
                    ticket.bindEntity((Entity)builder);
                    entityTickets.put(builder, ticket);
                    continue;
                }
                InterfaceChunkloader.removeEntityTicket(builder);
            }
        }
    }
}

