/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityParticle;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.mcinterface.BuilderEntityExisting;
import minecrafttransportsimulator.mcinterface.BuilderGUI;
import minecrafttransportsimulator.mcinterface.BuilderTileEntityFluidTank;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.openal.AL;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceClient {
    private static boolean lastPassFirstPerson;
    private static final Point3d mutablePosition;

    public static boolean isGamePaused() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    public static boolean isChatOpen() {
        return Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146241_e();
    }

    public static boolean isGUIOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    public static boolean inFirstPerson() {
        boolean inFirstPerson;
        boolean bl = inFirstPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        if (inFirstPerson || lastPassFirstPerson) {
            lastPassFirstPerson = inFirstPerson;
            return true;
        }
        return false;
    }

    public static boolean inThirdPerson() {
        return Minecraft.func_71410_x().field_71474_y.field_74320_O == 1;
    }

    public static void toggleFirstPerson() {
        Minecraft.func_71410_x().field_71474_y.field_74320_O = InterfaceClient.inFirstPerson() ? 1 : 0;
    }

    public static float getFOV() {
        return Minecraft.func_71410_x().field_71474_y.field_74334_X;
    }

    public static void setFOV(float setting) {
        Minecraft.func_71410_x().field_71474_y.field_74334_X = setting;
    }

    public static AEntityB_Existing getMousedOverEntity() {
        RayTraceResult lastHit = Minecraft.func_71410_x().field_71476_x;
        if (lastHit != null) {
            Point3d mousedOverPoint = new Point3d(lastHit.field_72307_f.field_72450_a, lastHit.field_72307_f.field_72448_b, lastHit.field_72307_f.field_72449_c);
            if (lastHit.field_72308_g != null) {
                if (lastHit.field_72308_g instanceof BuilderEntityExisting) {
                    AEntityB_Existing mousedOverEntity = ((BuilderEntityExisting)lastHit.field_72308_g).entity;
                    if (mousedOverEntity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)mousedOverEntity;
                        for (BoundingBox box : vehicle.allInteractionBoxes) {
                            APart part;
                            if (!box.isPointInside(mousedOverPoint) || (part = vehicle.getPartWithBox(box)) == null) continue;
                            return part;
                        }
                    }
                    return mousedOverEntity;
                }
            } else {
                TileEntity mcTile = InterfaceClient.getClientWorld().world.func_175625_s(lastHit.func_178782_a());
                if (mcTile instanceof BuilderTileEntityFluidTank) {
                    BuilderTileEntityFluidTank builder = (BuilderTileEntityFluidTank)mcTile;
                    return builder.tileEntity;
                }
            }
        }
        return null;
    }

    public static void closeGUI() {
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public static void setActiveGUI(AGUIBase gui) {
        FMLCommonHandler.instance().showGuiScreen((Object)new BuilderGUI(gui));
    }

    public static WrapperWorld getClientWorld() {
        return WrapperWorld.getWrapperFor((World)Minecraft.func_71410_x().field_71441_e);
    }

    public static WrapperPlayer getClientPlayer() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return WrapperPlayer.getWrapperFor((EntityPlayer)player);
    }

    public static WrapperEntity getRenderViewEntity() {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        return WrapperEntity.getWrapperFor(entity);
    }

    public static Point3d getCameraPosition() {
        Vec3d position = ActiveRenderInfo.getCameraPosition();
        mutablePosition.set(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        return mutablePosition;
    }

    public static boolean isSoundSystemReady() {
        return AL.isCreated();
    }

    public static void playBlockBreakSound(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        if (!Minecraft.func_71410_x().field_71441_e.func_175623_d(pos)) {
            SoundType soundType = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c().getSoundType(Minecraft.func_71410_x().field_71441_e.func_180495_p(pos), Minecraft.func_71410_x().field_71439_g.field_70170_p, pos, null);
            Minecraft.func_71410_x().field_71441_e.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
        }
    }

    public static List<String> getTooltipLines(WrapperItemStack stack) {
        List tooltipText = stack.stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 1; i < tooltipText.size(); ++i) {
            tooltipText.set(i, TextFormatting.GRAY + (String)tooltipText.get(i));
        }
        return tooltipText;
    }

    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent event) {
        WrapperWorld clientWorld = WrapperWorld.getWrapperFor((World)Minecraft.func_71410_x().field_71441_e);
        if (clientWorld != null) {
            clientWorld.beginProfiling("MTS_BulletUpdates", true);
            for (EntityBullet bullet : clientWorld.getEntitiesOfType(EntityBullet.class)) {
                bullet.update();
            }
            clientWorld.beginProfiling("MTS_ParticleUpdates", false);
            for (EntityParticle particle : clientWorld.getEntitiesOfType(EntityParticle.class)) {
                particle.update();
            }
            clientWorld.endProfiling();
        }
    }

    static {
        mutablePosition = new Point3d();
    }
}

