/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MasterLoader;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.BuilderItem;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;

public class InterfaceCore {
    private static final List<String> queuedLogs = new ArrayList<String>();

    public static String getGameVersion() {
        return Loader.instance().getMCVersionString().substring("Minecraft ".length());
    }

    public static boolean isModPresent(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    public static String getModName(String modID) {
        return ((ModContainer)Loader.instance().getIndexedModList().get(modID)).getName();
    }

    public static WrapperItemStack getAutoGeneratedStack(AItemBase item, WrapperNBT data) {
        WrapperItemStack newStack = new WrapperItemStack(new ItemStack((Item)BuilderItem.itemMap.get(item)));
        newStack.setData(data);
        return newStack;
    }

    public static WrapperItemStack getStackForProperties(String name, int meta, int qty) {
        return new WrapperItemStack(new ItemStack(Item.func_111206_d((String)name), qty, meta));
    }

    public static String getStackItemName(WrapperItemStack stack) {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.stack.func_77973_b())).toString();
    }

    public static boolean isOredictMatch(WrapperItemStack stackA, WrapperItemStack stackB) {
        return OreDictionary.itemMatches((ItemStack)stackA.stack, (ItemStack)stackB.stack, (boolean)false);
    }

    public static List<WrapperItemStack> getOredictMaterials(String oreName) {
        NonNullList oreDictStacks = OreDictionary.getOres((String)oreName, (boolean)true);
        ArrayList<WrapperItemStack> stacks = new ArrayList<WrapperItemStack>();
        for (ItemStack stack : oreDictStacks) {
            stacks.add(new WrapperItemStack(stack.func_77946_l()));
        }
        return stacks;
    }

    public static String getFluidName(String fluidID) {
        return FluidRegistry.getFluid((String)fluidID) != null ? new FluidStack(FluidRegistry.getFluid((String)fluidID), 1).getLocalizedName() : "INVALID";
    }

    public static Map<String, String> getAllFluids() {
        HashMap<String, String> fluidIDsToNames = new HashMap<String, String>();
        for (String fluidID : FluidRegistry.getRegisteredFluids().keySet()) {
            fluidIDsToNames.put(fluidID, new FluidStack(FluidRegistry.getFluid((String)fluidID), 1).getLocalizedName());
        }
        return fluidIDsToNames;
    }

    public static String translate(String text) {
        return I18n.func_74838_a((String)text);
    }

    public static void logError(String message) {
        if (MasterLoader.logger == null) {
            queuedLogs.add("mts".toUpperCase() + "ERROR: " + message);
        } else {
            MasterLoader.logger.error("mts".toUpperCase() + "ERROR: " + message);
        }
    }

    public static void flushLogQueue() {
        for (String log : queuedLogs) {
            InterfaceCore.logError(log);
        }
    }
}

