/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.BuilderEntityExisting;
import minecrafttransportsimulator.mcinterface.BuilderEntityRenderForwarder;
import minecrafttransportsimulator.mcinterface.InterfaceRender;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceEventsEntityRendering {
    private static final Map<EntityPlayer, ItemStack> tempHeldItemStorage = new HashMap<EntityPlayer, ItemStack>();
    private static float playerOffsetYawTemp;
    private static float playerPrevOffsetYawTemp;
    private static float playerHeadYawTemp;
    private static float playerPrevHeadYawTemp;
    protected static boolean renderCurrentRiderSitting;
    protected static boolean renderCurrentRiderControlling;
    private static int lastScreenWidth;
    private static int lastScreenHeight;

    @SubscribeEvent
    public static void on(RenderWorldLastEvent event) {
        float partialTicks = event.getPartialTicks();
        RenderHelper.func_74519_b();
        InterfaceRender.setLightingState(true);
        for (int pass = 0; pass < 2; ++pass) {
            if (pass == 1) {
                InterfaceRender.setBlend(true);
                GlStateManager.func_179132_a((boolean)false);
            }
            for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                if (!(entity instanceof BuilderEntityRenderForwarder)) continue;
                BuilderEntityRenderForwarder forwarder = (BuilderEntityRenderForwarder)entity;
                Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)forwarder).func_76986_a((Entity)forwarder, 0.0, 0.0, 0.0, 0.0f, partialTicks);
            }
            if (pass != 1) continue;
            InterfaceRender.setBlend(false);
            GlStateManager.func_179132_a((boolean)true);
        }
        RenderHelper.func_74518_a();
        InterfaceRender.setLightingState(false);
    }

    @SubscribeEvent
    public static void on(RenderGameOverlayEvent.Pre event) {
        if ((event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) || event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS)) && CameraSystem.customCameraOverlay != null) {
            event.setCanceled(true);
            return;
        }
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CHAT)) {
            boolean updateGUIs;
            ScaledResolution screenResolution = new ScaledResolution(Minecraft.func_71410_x());
            int screenWidth = screenResolution.func_78326_a();
            int screenHeight = screenResolution.func_78328_b();
            int mouseX = Mouse.getX() * screenWidth / Minecraft.func_71410_x().field_71443_c;
            int mouseY = screenHeight - Mouse.getY() * screenHeight / Minecraft.func_71410_x().field_71440_d - 1;
            float partialTicks = event.getPartialTicks();
            boolean bl = updateGUIs = screenWidth != lastScreenWidth || screenHeight != lastScreenHeight;
            if (updateGUIs) {
                lastScreenWidth = screenWidth;
                lastScreenHeight = screenHeight;
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            InterfaceRender.setBlend(false);
            GL11.glEnable((int)3008);
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            InterfaceRender.setLightingState(true);
            int displayGUIIndex = 0;
            for (AGUIBase gui : AGUIBase.activeGUIs) {
                if (updateGUIs || gui.components.isEmpty()) {
                    gui.setupComponentsInit(screenWidth, screenHeight);
                }
                GL11.glPushMatrix();
                if (gui.capturesPlayer()) {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)250.0);
                } else {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)(-500 + 250 * displayGUIIndex++));
                }
                gui.render(mouseX, mouseY, false, partialTicks);
                GL11.glPopMatrix();
            }
            displayGUIIndex = 0;
            InterfaceRender.setBlend(true);
            for (AGUIBase gui : AGUIBase.activeGUIs) {
                GL11.glPushMatrix();
                if (gui.capturesPlayer()) {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)250.0);
                } else {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)(-500 + 250 * displayGUIIndex++));
                }
                gui.render(mouseX, mouseY, true, partialTicks);
                GL11.glPopMatrix();
            }
            InterfaceRender.setLightingState(false);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            RenderHelper.func_74518_a();
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public static void on(RenderPlayerEvent.Pre event) {
        EntityPlayerGun gunEntity;
        EntityPlayer player = event.getEntityPlayer();
        ModelPlayer playerModel = event.getRenderer().func_177087_b();
        renderCurrentRiderSitting = false;
        renderCurrentRiderControlling = false;
        playerOffsetYawTemp = player.field_70761_aq;
        playerPrevOffsetYawTemp = player.field_70760_ar;
        playerHeadYawTemp = player.field_70759_as;
        playerPrevHeadYawTemp = player.field_70758_at;
        if (((Boolean)ConfigSystem.configObject.clientRendering.playerTweaks.value).booleanValue() && (gunEntity = EntityPlayerGun.playerClientGuns.get(player.func_110124_au().toString())) != null && gunEntity.activeGun != null) {
            if (gunEntity.activeGun.isHandHeldGunAimed) {
                InterfaceEventsEntityRendering.disableBothArms(playerModel, player, true);
            } else {
                InterfaceEventsEntityRendering.disableRightArm(playerModel, player, true);
            }
        }
        if (player.func_184187_bx() instanceof BuilderEntityExisting) {
            AEntityE_Interactable ridingEntity = (AEntityE_Interactable)((BuilderEntityExisting)player.func_184187_bx()).entity;
            float playerWidthScale = 1.0f;
            float playerHeightScale = 1.0f;
            GL11.glPushMatrix();
            if (ridingEntity != null) {
                Point3d entityAngles = ridingEntity.angles.copy();
                Point3d ridingAngles = new Point3d();
                if (ridingEntity instanceof EntityVehicleF_Physics) {
                    for (WrapperEntity rider : ridingEntity.locationRiderMap.values()) {
                        if (!player.equals((Object)rider.entity)) continue;
                        PartSeat seat = (PartSeat)((EntityVehicleF_Physics)ridingEntity).getPartAtLocation((Point3d)ridingEntity.locationRiderMap.inverse().get((Object)rider));
                        ridingAngles = seat.prevAngles.getInterpolatedPoint(seat.angles, event.getPartialRenderTick()).subtract(seat.entityOn.angles);
                        if (!((JSONPart)seat.definition).seat.standing) {
                            if (((Boolean)ConfigSystem.configObject.clientRendering.playerTweaks.value).booleanValue()) {
                                InterfaceEventsEntityRendering.disableLegs(playerModel);
                            }
                            renderCurrentRiderSitting = true;
                        }
                        if (((Boolean)ConfigSystem.configObject.clientRendering.playerTweaks.value).booleanValue() && seat.placementDefinition.isController) {
                            InterfaceEventsEntityRendering.disableBothArms(playerModel, player, false);
                            renderCurrentRiderControlling = true;
                        }
                        if (((JSONPart)seat.definition).seat.widthScale != 0.0f) {
                            playerWidthScale = ((JSONPart)seat.definition).seat.widthScale;
                        }
                        if (seat.placementDefinition.widthScale != 0.0f) {
                            playerWidthScale *= seat.placementDefinition.widthScale;
                        }
                        if (((JSONPart)seat.definition).seat.heightScale != 0.0f) {
                            playerHeightScale = ((JSONPart)seat.definition).seat.heightScale;
                        }
                        if (seat.placementDefinition.heightScale == 0.0f) break;
                        playerHeightScale *= seat.placementDefinition.heightScale;
                        break;
                    }
                }
                player.field_70761_aq = 0.0f;
                player.field_70760_ar = 0.0f;
                player.field_70758_at = player.field_70759_as = (float)((double)player.field_70177_z + entityAngles.y + ridingAngles.y);
                if (!player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                    EntityPlayerSP masterPlayer = Minecraft.func_71410_x().field_71439_g;
                    double playerDistanceX = player.field_70142_S + -masterPlayer.field_70142_S + (player.field_70165_t - player.field_70142_S - (masterPlayer.field_70165_t - masterPlayer.field_70142_S)) * (double)event.getPartialRenderTick();
                    double playerDistanceY = player.field_70137_T + -masterPlayer.field_70137_T + (player.field_70163_u - player.field_70137_T - (masterPlayer.field_70163_u - masterPlayer.field_70137_T)) * (double)event.getPartialRenderTick();
                    double playerDistanceZ = player.field_70136_U + -masterPlayer.field_70136_U + (player.field_70161_v - player.field_70136_U - (masterPlayer.field_70161_v - masterPlayer.field_70136_U)) * (double)event.getPartialRenderTick();
                    GL11.glTranslated((double)playerDistanceX, (double)playerDistanceY, (double)playerDistanceZ);
                    GL11.glTranslated((double)0.0, (double)player.func_70047_e(), (double)0.0);
                    GL11.glRotated((double)entityAngles.y, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)entityAngles.x, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)entityAngles.z, (double)0.0, (double)0.0, (double)1.0);
                    if (!ridingAngles.isZero()) {
                        GL11.glRotated((double)ridingAngles.y, (double)0.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)ridingAngles.x, (double)1.0, (double)0.0, (double)0.0);
                        GL11.glRotated((double)ridingAngles.z, (double)0.0, (double)0.0, (double)1.0);
                    }
                    GL11.glTranslated((double)0.0, (double)(-player.func_70047_e() * playerHeightScale), (double)0.0);
                    GL11.glTranslated((double)(-playerDistanceX * (double)playerWidthScale), (double)(-playerDistanceY * (double)playerHeightScale), (double)(-playerDistanceZ * (double)playerWidthScale));
                    GL11.glScalef((float)playerWidthScale, (float)playerHeightScale, (float)playerWidthScale);
                } else {
                    GL11.glTranslated((double)0.0, (double)player.func_70047_e(), (double)0.0);
                    GL11.glRotated((double)entityAngles.y, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)entityAngles.x, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)entityAngles.z, (double)0.0, (double)0.0, (double)1.0);
                    if (!ridingAngles.isZero()) {
                        GL11.glRotated((double)ridingAngles.y, (double)0.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)ridingAngles.x, (double)1.0, (double)0.0, (double)0.0);
                        GL11.glRotated((double)ridingAngles.z, (double)0.0, (double)0.0, (double)1.0);
                    }
                    GL11.glTranslated((double)0.0, (double)(-player.func_70047_e() * playerHeightScale), (double)0.0);
                    GL11.glScalef((float)playerWidthScale, (float)playerHeightScale, (float)playerWidthScale);
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        ModelPlayer playerModel = event.getRenderer().func_177087_b();
        AEntityB_Existing ridingEntity = null;
        Point3d rightArmAngles = null;
        Point3d leftArmAngles = null;
        player.field_70761_aq = playerOffsetYawTemp;
        player.field_70760_ar = playerPrevOffsetYawTemp;
        player.field_70759_as = playerHeadYawTemp;
        player.field_70758_at = playerPrevHeadYawTemp;
        if (player.func_184187_bx() instanceof BuilderEntityExisting) {
            ridingEntity = ((BuilderEntityExisting)player.func_184187_bx()).entity;
        }
        InterfaceEventsEntityRendering.resetAllLimbs(playerModel, player);
        if (((Boolean)ConfigSystem.configObject.clientRendering.playerTweaks.value).booleanValue()) {
            EntityPlayerGun gunEntity = EntityPlayerGun.playerClientGuns.get(player.func_110124_au().toString());
            if (gunEntity != null && gunEntity.activeGun != null) {
                Point3d heldVector = gunEntity.activeGun.isHandHeldGunAimed ? ((JSONPart)gunEntity.activeGun.definition).gun.handHeldAimedOffset : ((JSONPart)gunEntity.activeGun.definition).gun.handHeldNormalOffset;
                double heldVectorLength = heldVector.length();
                double armPitchOffset = Math.toRadians(-90.0f + player.field_70125_A) - Math.asin(heldVector.y / heldVectorLength);
                double armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                rightArmAngles = new Point3d(armPitchOffset, armYawOffset, 0.0);
                leftArmAngles = gunEntity.activeGun.isHandHeldGunAimed ? new Point3d(armPitchOffset, -armYawOffset, 0.0) : null;
            } else if (renderCurrentRiderControlling && ridingEntity instanceof EntityVehicleF_Physics) {
                double turningAngle = ((EntityVehicleF_Physics)ridingEntity).rudderAngle / 2.0;
                rightArmAngles = new Point3d(Math.toRadians(-75.0 + turningAngle), Math.toRadians(-10.0), 0.0);
                leftArmAngles = new Point3d(Math.toRadians(-75.0 - turningAngle), Math.toRadians(10.0), 0.0);
            }
            if (renderCurrentRiderSitting || rightArmAngles != null) {
                GL11.glPushMatrix();
                if (!player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                    EntityPlayerSP masterPlayer = Minecraft.func_71410_x().field_71439_g;
                    double playerDistanceX = player.field_70142_S + -masterPlayer.field_70142_S + (player.field_70165_t - player.field_70142_S - (masterPlayer.field_70165_t - masterPlayer.field_70142_S)) * (double)event.getPartialRenderTick();
                    double playerDistanceY = player.field_70137_T + -masterPlayer.field_70137_T + (player.field_70163_u - player.field_70137_T - (masterPlayer.field_70163_u - masterPlayer.field_70137_T)) * (double)event.getPartialRenderTick();
                    double playerDistanceZ = player.field_70136_U + -masterPlayer.field_70136_U + (player.field_70161_v - player.field_70136_U - (masterPlayer.field_70161_v - masterPlayer.field_70136_U)) * (double)event.getPartialRenderTick();
                    GL11.glTranslated((double)playerDistanceX, (double)playerDistanceY, (double)playerDistanceZ);
                }
                float scale = event.getRenderer().func_188322_c((EntityLivingBase)((AbstractClientPlayer)player), event.getPartialRenderTick());
                event.getRenderer().func_110776_a(((AbstractClientPlayer)player).func_110306_p());
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                if (renderCurrentRiderSitting) {
                    InterfaceEventsEntityRendering.renderLegsSitting(playerModel, scale);
                }
                if (rightArmAngles != null) {
                    if (!renderCurrentRiderControlling) {
                        if (ridingEntity != null) {
                            GL11.glRotated((double)((double)player.field_70177_z + ridingEntity.angles.y), (double)0.0, (double)1.0, (double)0.0);
                        } else {
                            GL11.glRotated((double)player.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
                        }
                    }
                    if (player.func_70093_af()) {
                        GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
                    }
                    InterfaceEventsEntityRendering.renderArmsAtAngles(playerModel, scale, rightArmAngles, leftArmAngles);
                }
                GL11.glPopMatrix();
            }
        }
        if (player.func_184187_bx() instanceof BuilderEntityExisting) {
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public static void on(RenderHandEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
        if (entity != null && entity.activeGun != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void on(RenderSpecificHandEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
        if (entity != null && entity.activeGun != null) {
            event.setCanceled(true);
        }
    }

    private static void disableRightArm(ModelPlayer playerModel, EntityPlayer player, boolean hideItem) {
        if (hideItem) {
            tempHeldItemStorage.put(player, player.func_184614_ca());
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
        }
        playerModel.field_178723_h.field_78807_k = true;
        playerModel.field_178732_b.field_78807_k = true;
    }

    private static void disableBothArms(ModelPlayer playerModel, EntityPlayer player, boolean hideItem) {
        if (hideItem) {
            tempHeldItemStorage.put(player, player.func_184614_ca());
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
        }
        playerModel.field_178723_h.field_78807_k = true;
        playerModel.field_178732_b.field_78807_k = true;
        playerModel.field_178724_i.field_78807_k = true;
        playerModel.field_178734_a.field_78807_k = true;
    }

    private static void disableLegs(ModelPlayer playerModel) {
        playerModel.field_178721_j.field_78807_k = true;
        playerModel.field_178731_d.field_78807_k = true;
        playerModel.field_178722_k.field_78807_k = true;
        playerModel.field_178733_c.field_78807_k = true;
    }

    private static void resetAllLimbs(ModelPlayer playerModel, EntityPlayer player) {
        if (tempHeldItemStorage.containsKey(player)) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)tempHeldItemStorage.get(player));
            tempHeldItemStorage.remove(player);
        }
        playerModel.field_178723_h.field_78807_k = false;
        playerModel.field_178732_b.field_78807_k = false;
        playerModel.field_178724_i.field_78807_k = false;
        playerModel.field_178734_a.field_78807_k = false;
        playerModel.field_178721_j.field_78807_k = false;
        playerModel.field_178731_d.field_78807_k = false;
        playerModel.field_178722_k.field_78807_k = false;
        playerModel.field_178733_c.field_78807_k = false;
    }

    private static void renderArmsAtAngles(ModelPlayer playerModel, float scale, Point3d rightArmAngles, Point3d leftArmAngles) {
        if (rightArmAngles != null) {
            ModelRenderer rightArm = playerModel.field_178723_h;
            ModelRenderer rightArmwear = playerModel.field_178732_b;
            rightArm.field_78796_g = (float)rightArmAngles.y;
            rightArm.field_78795_f = (float)rightArmAngles.x;
            rightArm.field_78808_h = (float)rightArmAngles.z;
            ModelPlayer.func_178685_a((ModelRenderer)rightArm, (ModelRenderer)rightArmwear);
            rightArm.func_78785_a(scale);
            rightArmwear.func_78785_a(scale);
        }
        if (leftArmAngles != null) {
            ModelRenderer leftArm = playerModel.field_178724_i;
            ModelRenderer leftArmwear = playerModel.field_178734_a;
            leftArm.field_78796_g = (float)leftArmAngles.y;
            leftArm.field_78795_f = (float)leftArmAngles.x;
            leftArm.field_78808_h = (float)leftArmAngles.z;
            ModelPlayer.func_178685_a((ModelRenderer)leftArm, (ModelRenderer)leftArmwear);
            leftArm.func_78785_a(scale);
            leftArmwear.func_78785_a(scale);
        }
    }

    private static void renderLegsSitting(ModelPlayer playerModel, float scale) {
        ModelRenderer rightLeg = playerModel.field_178721_j;
        ModelRenderer rightLegwear = playerModel.field_178731_d;
        ModelRenderer leftLeg = playerModel.field_178722_k;
        ModelRenderer leftLegwear = playerModel.field_178733_c;
        rightLeg.field_78796_g = 0.0f;
        rightLeg.field_78795_f = (float)Math.toRadians(-90.0);
        rightLeg.field_78808_h = 0.0f;
        leftLeg.field_78796_g = 0.0f;
        leftLeg.field_78795_f = (float)Math.toRadians(-90.0);
        leftLeg.field_78808_h = 0.0f;
        ModelPlayer.func_178685_a((ModelRenderer)rightLeg, (ModelRenderer)rightLegwear);
        ModelPlayer.func_178685_a((ModelRenderer)leftLeg, (ModelRenderer)leftLegwear);
        rightLeg.func_78785_a(scale);
        rightLegwear.func_78785_a(scale);
        leftLeg.func_78785_a(scale);
        leftLegwear.func_78785_a(scale);
    }
}

