/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.guis.instances.GUIConfig;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.MouseHelper;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceInput {
    private static KeyBinding configKey;
    private static boolean enableMouse;
    private static InhibitableMouseHelper customMouseHelper;
    private static boolean runningJoystickThread;
    private static boolean runningClassicMode;
    private static boolean joystickLoadingAttempted;
    private static boolean joystickEnabled;
    private static boolean joystickBlocked;
    private static boolean joystickInhibited;
    private static final Map<String, Integer> joystickNameCounters;
    private static final Map<String, Controller> joystickMap;
    private static final Map<String, Integer> joystickAxisCountMap;
    private static final Set<Controller> rumblingControllers;
    private static final Map<String, net.java.games.input.Controller> classicJoystickMap;

    public static void initConfigKey() {
        configKey = new KeyBinding("key.mts.config", 25, "key.categories.mts");
        ClientRegistry.registerKeyBinding((KeyBinding)configKey);
    }

    public static void initJoysticks() {
        if (!runningJoystickThread) {
            runningJoystickThread = true;
            joystickBlocked = true;
            Thread joystickThread = new Thread(){

                @Override
                public void run() {
                    try {
                        joystickNameCounters.clear();
                        if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                            InterfaceCore.logError("Starting controller init.");
                        }
                        if (runningClassicMode) {
                            if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                InterfaceCore.logError("Running classic mode.");
                            }
                            classicJoystickMap.clear();
                            if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                InterfaceCore.logError("Found this many controllers: " + ControllerEnvironment.getDefaultEnvironment().getControllers().length);
                            }
                            for (net.java.games.input.Controller joystick : ControllerEnvironment.getDefaultEnvironment().getControllers()) {
                                joystickEnabled = true;
                                if (joystick.getType() == null || joystick.getType().equals(Controller.Type.MOUSE) || joystick.getType().equals(Controller.Type.KEYBOARD) || joystick.getName() == null || joystick.getComponents().length == 0) continue;
                                String joystickName = joystick.getName();
                                if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                    InterfaceCore.logError("Found valid controller: " + joystickName);
                                }
                                if (!joystickNameCounters.containsKey(joystickName)) {
                                    joystickNameCounters.put(joystickName, 0);
                                }
                                classicJoystickMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick);
                                joystickNameCounters.put(joystickName, (Integer)joystickNameCounters.get(joystickName) + 1);
                            }
                        } else {
                            if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                InterfaceCore.logError("Running modern mode.");
                            }
                            if (!Controllers.isCreated()) {
                                if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                    InterfaceCore.logError("Creating controller object.");
                                }
                                Controllers.create();
                            }
                            joystickMap.clear();
                            joystickAxisCountMap.clear();
                            if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                InterfaceCore.logError("Found this many controllers: " + Controllers.getControllerCount());
                            }
                            for (int i = 0; i < Controllers.getControllerCount(); ++i) {
                                joystickEnabled = true;
                                Controller joystick = Controllers.getController((int)i);
                                if (joystick.getAxisCount() <= 0 || joystick.getButtonCount() <= 0 || joystick.getName() == null) continue;
                                String joystickName = joystick.getName();
                                if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                                    InterfaceCore.logError("Found valid controller: " + joystickName);
                                }
                                if (!joystickNameCounters.containsKey(joystickName)) {
                                    joystickNameCounters.put(joystickName, 0);
                                }
                                joystickMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick);
                                joystickAxisCountMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick.getAxisCount());
                                joystickNameCounters.put(joystickName, (Integer)joystickNameCounters.get(joystickName) + 1);
                            }
                        }
                        Iterator<Map.Entry<String, JSONConfig.ConfigJoystick>> iterator = ConfigSystem.configObject.controls.joystick.entrySet().iterator();
                        if (((Boolean)ConfigSystem.configObject.clientControls.devMode.value).booleanValue()) {
                            InterfaceCore.logError("Performing button validity checks.");
                        }
                        while (iterator.hasNext()) {
                            try {
                                Map.Entry<String, JSONConfig.ConfigJoystick> controllerEntry = iterator.next();
                                ControlSystem.ControlsJoystick control = ControlSystem.ControlsJoystick.valueOf(controllerEntry.getKey().toUpperCase());
                                JSONConfig.ConfigJoystick config = controllerEntry.getValue();
                                if (runningClassicMode) {
                                    if (!classicJoystickMap.containsKey(config.joystickName) || ((net.java.games.input.Controller)classicJoystickMap.get(config.joystickName)).getComponents().length > config.buttonIndex) continue;
                                    iterator.remove();
                                    continue;
                                }
                                if (!joystickMap.containsKey(config.joystickName)) continue;
                                if (control.isAxis) {
                                    if (((Controller)joystickMap.get(config.joystickName)).getAxisCount() > config.buttonIndex) continue;
                                    iterator.remove();
                                    continue;
                                }
                                if (((Controller)joystickMap.get(config.joystickName)).getButtonCount() > config.buttonIndex - (Integer)joystickAxisCountMap.get(config.joystickName)) continue;
                                iterator.remove();
                            }
                            catch (Exception e) {
                                iterator.remove();
                            }
                        }
                        joystickBlocked = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        InterfaceCore.logError(e.getMessage());
                        for (StackTraceElement s : e.getStackTrace()) {
                            InterfaceCore.logError(s.toString());
                        }
                    }
                    runningJoystickThread = false;
                }
            };
            joystickThread.start();
        }
    }

    public static String getNameForKeyCode(int keyCode) {
        return Keyboard.getKeyName((int)keyCode);
    }

    public static int getKeyCodeForName(String name) {
        return Keyboard.getKeyIndex((String)name);
    }

    public static boolean isKeyPressed(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode);
    }

    public static void setKeyboardRepeat(boolean enabled) {
        Keyboard.enableRepeatEvents((boolean)enabled);
    }

    public static boolean isJoystickSupportEnabled() {
        return joystickEnabled;
    }

    public static boolean isJoystickSupportBlocked() {
        return joystickBlocked;
    }

    public static boolean isJoystickPresent(String joystickName) {
        return !joystickInhibited && runningClassicMode ? classicJoystickMap.containsKey(joystickName) : joystickMap.containsKey(joystickName);
    }

    public static List<String> getAllJoystickNames() {
        return new ArrayList<String>(runningClassicMode ? classicJoystickMap.keySet() : joystickMap.keySet());
    }

    public static int getJoystickComponentCount(String joystickName) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents().length : joystickMap.get(joystickName).getAxisCount() + joystickMap.get(joystickName).getButtonCount();
    }

    public static String getJoystickComponentName(String joystickName, int index) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents()[index].getName() : (InterfaceInput.isJoystickComponentAxis(joystickName, index) ? joystickMap.get(joystickName).getAxisName(index) : joystickMap.get(joystickName).getButtonName(index - joystickAxisCountMap.get(joystickName)));
    }

    public static boolean isJoystickComponentAxis(String joystickName, int index) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents()[index].isAnalog() : joystickMap.get(joystickName).getAxisCount() > index;
    }

    public static float getJoystickAxisValue(String joystickName, int index) {
        if (runningClassicMode) {
            if (classicJoystickMap.containsKey(joystickName)) {
                classicJoystickMap.get(joystickName).poll();
                return classicJoystickMap.get(joystickName).getComponents()[index].getPollData();
            }
            return 0.0f;
        }
        if (joystickMap.containsKey(joystickName)) {
            if (InterfaceInput.isJoystickComponentAxis(joystickName, index)) {
                joystickMap.get(joystickName).poll();
                return joystickMap.get(joystickName).getAxisValue(index);
            }
            return InterfaceInput.getJoystickButtonValue(joystickName, index) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public static boolean getJoystickButtonValue(String joystickName, int index) {
        if (runningClassicMode) {
            if (classicJoystickMap.containsKey(joystickName)) {
                classicJoystickMap.get(joystickName).poll();
                return classicJoystickMap.get(joystickName).getComponents()[index].getPollData() > 0.0f;
            }
            return false;
        }
        if (joystickMap.containsKey(joystickName)) {
            joystickMap.get(joystickName).poll();
            return joystickMap.get(joystickName).isButtonPressed(index - joystickAxisCountMap.get(joystickName));
        }
        return false;
    }

    public static void setJoystickRumble(String joystickName, float strength) {
        Controller joystick;
        if (!runningClassicMode && rumblingControllers.contains(joystick = joystickMap.get(joystickName)) ^ strength > 0.0f) {
            for (int i = 0; i < joystick.getRumblerCount(); ++i) {
                joystick.setRumblerStrength(i, strength);
            }
        }
    }

    public static void inhibitJoysticks(boolean inhibited) {
        joystickInhibited = inhibited;
    }

    public static void setMouseEnabled(boolean enabled) {
        enableMouse = enabled;
        Minecraft.func_71410_x().field_71417_B = customMouseHelper;
    }

    public static long getMouseDelta() {
        return (long)customMouseHelper.deltaXForced << 32 | (long)customMouseHelper.deltaYForced & 0xFFFFFFFFL;
    }

    public static int getTrackedMouseWheel() {
        return Mouse.hasWheel() ? Mouse.getDWheel() : 0;
    }

    public static boolean isLeftMouseButtonDown() {
        return Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
    }

    public static boolean isRightMouseButtonDown() {
        return Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d();
    }

    @SubscribeEvent
    public static void on(InputEvent.KeyInputEvent event) {
        if (runningClassicMode ^ (Boolean)ConfigSystem.configObject.clientControls.classicJystk.value) {
            runningClassicMode = (Boolean)ConfigSystem.configObject.clientControls.classicJystk.value;
            joystickLoadingAttempted = false;
        }
        if (!joystickLoadingAttempted) {
            InterfaceInput.initJoysticks();
            joystickLoadingAttempted = true;
        }
        if (configKey.func_151468_f() && !InterfaceClient.isGUIOpen()) {
            new GUIConfig();
        }
    }

    static {
        enableMouse = false;
        customMouseHelper = new InhibitableMouseHelper();
        runningJoystickThread = false;
        runningClassicMode = false;
        joystickLoadingAttempted = false;
        joystickEnabled = false;
        joystickBlocked = false;
        joystickInhibited = false;
        joystickNameCounters = new HashMap<String, Integer>();
        joystickMap = new LinkedHashMap<String, Controller>();
        joystickAxisCountMap = new LinkedHashMap<String, Integer>();
        rumblingControllers = new HashSet<Controller>();
        classicJoystickMap = new LinkedHashMap<String, net.java.games.input.Controller>();
    }

    private static class InhibitableMouseHelper
    extends MouseHelper {
        private int deltaXForced;
        private int deltaYForced;

        private InhibitableMouseHelper() {
        }

        public void func_74374_c() {
            super.func_74374_c();
            if (!enableMouse) {
                this.deltaXForced = this.field_74377_a;
                if (this.deltaXForced > 100) {
                    this.deltaXForced = 0;
                }
                this.deltaYForced = this.field_74375_b;
                if (this.deltaYForced > 100) {
                    this.deltaYForced = 0;
                }
                this.field_74377_a = 0;
                this.field_74375_b = 0;
            }
        }
    }
}

