/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.PacketEntityCSHandshakeClient;
import minecrafttransportsimulator.mcinterface.PacketEntityCSHandshakeServer;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class InterfacePacket {
    private static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("mts");
    private static final BiMap<Byte, Class<? extends APacketBase>> packetMappings = HashBiMap.create();

    public static void init() {
        byte packetIndex;
        network.registerMessage(WrapperHandler.class, WrapperPacket.class, 0, Side.CLIENT);
        network.registerMessage(WrapperHandler.class, WrapperPacket.class, 1, Side.SERVER);
        byte by = packetIndex = 0;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by, PacketEntityCSHandshakeClient.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by2, PacketEntityCSHandshakeServer.class);
        APacketBase.initPackets(packetIndex);
    }

    public static void registerPacket(byte packetIndex, Class<? extends APacketBase> packetClass) {
        packetMappings.put((Object)packetIndex, packetClass);
    }

    public static byte getPacketIndex(APacketBase packet) {
        return (Byte)packetMappings.inverse().get(packet.getClass());
    }

    public static void sendToServer(APacketBase packet) {
        network.sendToServer((IMessage)new WrapperPacket(packet));
    }

    public static void sendToAllClients(APacketBase packet) {
        network.sendToAll((IMessage)new WrapperPacket(packet));
    }

    public static void sendToPlayer(APacketBase packet, WrapperPlayer player) {
        network.sendTo((IMessage)new WrapperPacket(packet), (EntityPlayerMP)player.player);
    }

    private static WrapperWorld getServerWorld(MessageContext ctx) {
        return WrapperWorld.getWrapperFor(ctx.getServerHandler().field_147369_b.field_70170_p);
    }

    public static void writeDataToBuffer(WrapperNBT data, ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_150786_a(data.tag);
    }

    public static WrapperNBT readDataFromBuffer(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        try {
            return new WrapperNBT(pb.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class WrapperHandler
    implements IMessageHandler<WrapperPacket, IMessage> {
        public IMessage onMessage(final WrapperPacket message, final MessageContext ctx) {
            if (message.packet.runOnMainThread()) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (ctx.side.isServer()) {
                            message.packet.handle(InterfacePacket.getServerWorld(ctx));
                        } else {
                            message.packet.handle(InterfaceClient.getClientWorld());
                        }
                    }
                });
            } else if (ctx.side.isServer()) {
                message.packet.handle(InterfacePacket.getServerWorld(ctx));
            } else {
                message.packet.handle(InterfaceClient.getClientWorld());
            }
            return null;
        }
    }

    public static class WrapperPacket
    implements IMessage {
        private APacketBase packet;

        public WrapperPacket() {
        }

        public WrapperPacket(APacketBase packet) {
            this.packet = packet;
        }

        public void fromBytes(ByteBuf buf) {
            byte packetIndex = buf.readByte();
            try {
                Class packetClass = (Class)packetMappings.get((Object)packetIndex);
                this.packet = (APacketBase)packetClass.getConstructor(ByteBuf.class).newInstance(buf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            this.packet.writeToBuffer(buf);
        }
    }
}

