/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.rendering.components.GIFParser;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class InterfaceRender {
    private static final Map<String, ResourceLocation> internalTextures = new HashMap<String, ResourceLocation>();
    private static final Map<String, Integer> onlineTextures = new HashMap<String, Integer>();
    private static final Map<String, GIFParser.ParsedGIF> animatedGIFs = new HashMap<String, GIFParser.ParsedGIF>();
    private static float lastLightmapX;
    private static float lastLightmapY;
    private static final ResourceLocation PARTICLE_TEXTURES;

    public static void renderItemModel(WrapperItemStack stack) {
        GL11.glPushMatrix();
        InterfaceRender.setInternalLightingState(false);
        float offset = 100.0f + Minecraft.func_71410_x().func_175599_af().field_77023_b;
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-offset));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack.stack, 0, 0);
        InterfaceRender.setInternalLightingState(true);
        GL11.glPopMatrix();
    }

    public static void renderVertices(RenderableObject object) {
        if (object.disableLighting) {
            InterfaceRender.setLightingState(false);
        }
        if (object.ignoreWorldShading) {
            InterfaceRender.setSystemLightingState(false);
        }
        if (object.enableBrightBlending) {
            InterfaceRender.setBlendBright(true);
        }
        if (object.texture != null) {
            InterfaceRender.bindTexture(object.texture);
        } else {
            GL11.glDisable((int)3553);
        }
        InterfaceRender.setColorState(object.color, object.alpha);
        GL11.glPushMatrix();
        if (object.isMirrored) {
            GL11.glScalef((float)(-object.scale), (float)object.scale, (float)object.scale);
            GL11.glCullFace((int)1028);
        } else {
            GL11.glScalef((float)object.scale, (float)object.scale, (float)object.scale);
        }
        if (object.cacheVertices) {
            if (object.cachedVertexIndex == -1) {
                object.cachedVertexIndex = InterfaceRender.cacheVertices(object.vertices);
                object.vertices = null;
            }
            InterfaceRender.renderVertices(object.cachedVertexIndex);
        } else if (object.lineWidth != 0.0f) {
            InterfaceRender.renderLines(object.vertices, object.lineWidth);
        } else {
            InterfaceRender.renderVertices(object.vertices);
        }
        if (object.isMirrored) {
            GL11.glCullFace((int)1029);
        }
        GL11.glPopMatrix();
        if (object.texture == null) {
            GL11.glEnable((int)3553);
        }
        if (object.disableLighting || object.ignoreWorldShading) {
            InterfaceRender.setLightingState(true);
        }
        if (object.enableBrightBlending) {
            InterfaceRender.setBlendBright(false);
        }
    }

    public static void deleteVertices(RenderableObject object) {
        GL11.glDeleteLists((int)object.cachedVertexIndex, (int)1);
    }

    private static void renderVertices(FloatBuffer vertices) {
        GL11.glBegin((int)4);
        while (vertices.hasRemaining()) {
            GL11.glNormal3f((float)vertices.get(), (float)vertices.get(), (float)vertices.get());
            GL11.glTexCoord2f((float)vertices.get(), (float)vertices.get());
            GL11.glVertex3f((float)vertices.get(), (float)vertices.get(), (float)vertices.get());
        }
        GL11.glEnd();
        vertices.rewind();
    }

    private static void renderVertices(int index) {
        GL11.glCallList((int)index);
    }

    private static void renderLines(FloatBuffer vertices, float width) {
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        while (vertices.hasRemaining()) {
            GL11.glVertex3f((float)vertices.get(), (float)vertices.get(), (float)vertices.get());
        }
        GL11.glEnd();
        vertices.rewind();
        GL11.glLineWidth((float)1.0f);
    }

    private static int cacheVertices(FloatBuffer vertices) {
        int displayListIndex = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayListIndex, (int)4864);
        InterfaceRender.renderVertices(vertices);
        GL11.glEndList();
        return displayListIndex;
    }

    private static void bindTexture(String textureLocation) {
        if (animatedGIFs.containsKey(textureLocation)) {
            GIFParser.ParsedGIF parsedGIF = animatedGIFs.get(textureLocation);
            GlStateManager.func_179144_i((int)parsedGIF.getCurrentTextureIndex());
        } else if (onlineTextures.containsKey(textureLocation)) {
            GlStateManager.func_179144_i((int)onlineTextures.get(textureLocation));
        } else if (textureLocation.equals("GLOBAL")) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        } else if (textureLocation.equals("PARTICLE")) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PARTICLE_TEXTURES);
        } else {
            if (!internalTextures.containsKey(textureLocation)) {
                String formattedLocation = textureLocation;
                if (textureLocation.indexOf(":") != -1) {
                    formattedLocation = "/assets/" + textureLocation.replace(":", "/");
                }
                if (InterfaceRender.class.getResource(formattedLocation) != null) {
                    String domain = formattedLocation.substring("/assets/".length(), formattedLocation.indexOf("/", "/assets/".length()));
                    String location = formattedLocation.substring("/assets/".length() + domain.length() + 1);
                    internalTextures.put(textureLocation, new ResourceLocation(domain, location));
                } else {
                    InterfaceCore.logError("Could not find texture: " + formattedLocation + " Reverting to fallback texture.");
                    internalTextures.put(textureLocation, TextureMap.field_174945_f);
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(internalTextures.get(textureLocation));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String downloadURLTexture(String textureURL) {
        if (onlineTextures.containsKey(textureURL) || animatedGIFs.containsKey(textureURL)) return null;
        try {
            URL url = new URL(textureURL);
            URLConnection connection = url.openConnection();
            try {
                ArrayList<String> validContentTypes = new ArrayList<String>();
                for (String imageSuffix : ImageIO.getReaderFileSuffixes()) {
                    validContentTypes.add("image/" + imageSuffix);
                }
                String contentType = connection.getHeaderField("Content-Type");
                if (validContentTypes.contains(contentType)) {
                    if (contentType.endsWith("gif")) {
                        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
                        ImageInputStream stream = ImageIO.createImageInputStream(url.openStream());
                        reader.setInput(stream);
                        GIFParser.ParsedGIF gif = GIFParser.parseGIF(reader);
                        if (gif == null) return "Could not parse GIF due to no frames being present.  Is this a real direct link or a fake one?";
                        animatedGIFs.put(textureURL, gif);
                        return null;
                    } else {
                        BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)url.openStream());
                        int glTexturePointer = TextureUtil.func_110996_a();
                        TextureUtil.func_110989_a((int)glTexturePointer, (BufferedImage)bufferedimage, (boolean)false, (boolean)false);
                        onlineTextures.put(textureURL, glTexturePointer);
                    }
                    return null;
                }
                String errorString = "Invalid content type found.  Found:" + contentType + ", but the only valid types are: ";
                for (String validType : validContentTypes) {
                    errorString = errorString + validType + ", ";
                }
                onlineTextures.put(textureURL, TextureUtil.field_111001_a.func_110552_b());
                return errorString;
            }
            catch (Exception e) {
                onlineTextures.put(textureURL, TextureUtil.field_111001_a.func_110552_b());
                e.printStackTrace();
                return "Could not parse images.  Error was: " + e.getMessage();
            }
        }
        catch (Exception e) {
            onlineTextures.put(textureURL, TextureUtil.field_111001_a.func_110552_b());
            e.printStackTrace();
            return "Could not open URL for processing.  Error was: " + e.getMessage();
        }
    }

    public static void setLightingState(boolean enabled) {
        InterfaceRender.setSystemLightingState(enabled);
        InterfaceRender.setInternalLightingState(enabled);
    }

    private static void setSystemLightingState(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    private static void setInternalLightingState(boolean enabled) {
        if (enabled) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastLightmapX, (float)lastLightmapY);
        } else {
            lastLightmapX = OpenGlHelper.lastBrightnessX;
            lastLightmapY = OpenGlHelper.lastBrightnessY;
            int lightVar = 0xF000F0;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightVar % 65536), (float)(lightVar / 65536));
        }
    }

    public static void setLightingToPosition(Point3d position) {
        int lightVar = Minecraft.func_71410_x().field_71441_e.func_175626_b(new BlockPos(position.x, position.y + 1.0, position.z), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightVar % 65536), (float)(lightVar / 65536));
    }

    public static void setBlend(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
    }

    private static void setBlendBright(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179112_b((int)774, (int)770);
        } else {
            GlStateManager.func_179112_b((int)770, (int)771);
        }
    }

    private static void setColorState(ColorRGB color, float alpha) {
        GlStateManager.func_179131_c((float)color.red, (float)color.green, (float)color.blue, (float)alpha);
    }

    public static boolean shouldRenderBoundingBoxes() {
        return Minecraft.func_71410_x().func_175598_ae().func_178634_b();
    }

    public static void renderEntityRiders(AEntityE_Interactable<?> entity, float partialTicks) {
        for (WrapperEntity rider : entity.locationRiderMap.values()) {
            Entity riderEntity = rider.entity;
            if (InterfaceClient.getClientPlayer().equals(rider) && InterfaceClient.inFirstPerson() || !(riderEntity.field_70163_u > (double)riderEntity.field_70170_p.func_72800_K())) continue;
            GL11.glPushMatrix();
            Point3d riderPosition = rider.getRenderedPosition(partialTicks);
            GL11.glTranslated((double)riderPosition.x, (double)riderPosition.y, (double)riderPosition.z);
            Minecraft.func_71410_x().func_175598_ae().func_188388_a(riderEntity, partialTicks, false);
            GL11.glPopMatrix();
        }
    }

    static {
        PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    }
}

