/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.sound.DecodedFile;
import minecrafttransportsimulator.sound.IStreamDecoder;
import minecrafttransportsimulator.sound.OGGDecoder;
import minecrafttransportsimulator.sound.RadioStation;
import minecrafttransportsimulator.sound.SoundInstance;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceSound {
    private static boolean isSystemPaused;
    private static final Map<String, Integer> dataSourceBuffers;
    private static final Set<SoundInstance> playingSounds;
    private static final List<RadioStation> playingStations;
    private static volatile List<SoundInstance> queuedSounds;
    private static byte sourceGetFailures;

    public static void update() {
        boolean bl;
        if (!InterfaceClient.isSoundSystemReady()) {
            return;
        }
        if (InterfaceClient.isGamePaused()) {
            if (!isSystemPaused) {
                for (SoundInstance soundInstance : playingSounds) {
                    AL10.alSourcePause((int)soundInstance.sourceIndex);
                }
                isSystemPaused = true;
            } else {
                for (SoundInstance soundInstance : playingSounds) {
                    if (soundInstance.radio != null) {
                        soundInstance.radio.stop();
                        continue;
                    }
                    soundInstance.stopSound = true;
                }
            }
            return;
        }
        if (isSystemPaused) {
            for (SoundInstance soundInstance : playingSounds) {
                AL10.alSourcePlay((int)soundInstance.sourceIndex);
            }
            isSystemPaused = false;
        }
        WrapperPlayer player = InterfaceClient.getClientPlayer();
        if (InterfaceClient.getClientWorld() == null || player == null) {
            queuedSounds.clear();
            for (SoundInstance sound : playingSounds) {
                sound.stopSound = true;
            }
        }
        if (!queuedSounds.isEmpty()) {
            for (SoundInstance sound : queuedSounds) {
                AL10.alSourcePlay((int)sound.sourceIndex);
                playingSounds.add(sound);
            }
            queuedSounds.clear();
        }
        boolean bl2 = false;
        Iterator<SoundInstance> iterator = playingSounds.iterator();
        while (iterator.hasNext()) {
            int boundBuffers;
            SoundInstance sound = iterator.next();
            AL10.alGetError();
            int state = AL10.alGetSourcei((int)sound.sourceIndex, (int)4112);
            if (AL10.alGetError() == 40961) {
                bl = true;
                break;
            }
            if (state == 4114) {
                if (sound.stopSound) {
                    AL10.alSourceStop((int)sound.sourceIndex);
                    continue;
                }
                sound.updatePosition();
                AL10.alSource3f((int)sound.sourceIndex, (int)4100, (float)((float)sound.position.x), (float)((float)sound.position.y), (float)((float)sound.position.z));
                AL10.alSourcef((int)sound.sourceIndex, (int)4106, (float)sound.volume);
                if (sound.soundDef != null && sound.soundDef.looping && !sound.entity.equals(player.getEntityRiding())) {
                    double finalDelta;
                    Point3d playerVelocity = player.getVelocity();
                    playerVelocity.y = 0.0;
                    double initalDelta = player.getPosition().subtract(sound.entity.position).length();
                    float dopplerFactor = (float)(initalDelta > (finalDelta = player.getPosition().add(playerVelocity).subtract(sound.entity.position).add(-sound.entity.motion.x, 0.0, -sound.entity.motion.z).length()) ? 1.0 + 0.25 * (initalDelta - finalDelta) / initalDelta : 1.0 - 0.25 * (finalDelta - initalDelta) / finalDelta);
                    AL10.alSourcef((int)sound.sourceIndex, (int)4099, (float)(sound.pitch * dopplerFactor));
                } else {
                    AL10.alSourcef((int)sound.sourceIndex, (int)4099, (float)sound.pitch);
                }
                AL10.alSourcef((int)sound.sourceIndex, (int)4129, (float)(1.0f / (0.25f + 3.0f * sound.pitch)));
                continue;
            }
            if (sound.radio == null) {
                AL10.alSourcei((int)sound.sourceIndex, (int)4105, (int)0);
                sound.stopSound = true;
            } else if (sound.stopSound && (boundBuffers = AL10.alGetSourcei((int)sound.sourceIndex, (int)4118)) > 0) {
                IntBuffer buffers = BufferUtils.createIntBuffer((int)boundBuffers);
                AL10.alSourceUnqueueBuffers((int)sound.sourceIndex, (IntBuffer)buffers);
            }
            if (!sound.stopSound) continue;
            IntBuffer sourceBuffer = (IntBuffer)BufferUtils.createIntBuffer((int)1).put(sound.sourceIndex).flip();
            AL10.alDeleteSources((IntBuffer)sourceBuffer);
            iterator.remove();
            sound.entity.sounds.remove(sound);
        }
        for (RadioStation station : playingStations) {
            station.update();
        }
        if (bl) {
            InterfaceCore.logError("Had an invalid sound name.  Was the sound system reset?  Clearing all sounds, playing or not!");
            dataSourceBuffers.clear();
            for (SoundInstance sound : playingSounds) {
                sound.entity.sounds.remove(sound);
            }
            playingSounds.clear();
            sourceGetFailures = 0;
        }
    }

    public static void playQuickSound(SoundInstance sound) {
        Integer dataBufferPointer;
        if (InterfaceClient.isSoundSystemReady() && sourceGetFailures < 10 && (dataBufferPointer = InterfaceSound.loadOGGJarSound(sound.soundName)) != null) {
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGetError();
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() != 0) {
                sourceGetFailures = (byte)(sourceGetFailures + 1);
                AL10.alDeleteBuffers((int)dataBufferPointer);
                InterfaceClient.getClientPlayer().displayChatMessage("IMMERSIVE VEHICLES ERROR: Tried to play a sound, but was told no sound slots were available.  Some mod is taking up all the slots.  Probabaly Immersive Railroading or Dynamic Surroundings.  If you have those installed, complain to the mod author or check the mod configs.  Sound will not play.");
                return;
            }
            sound.sourceIndex = sourceBuffer.get(0);
            AL10.alGetError();
            AL10.alSourcei((int)sound.sourceIndex, (int)4103, (int)(sound.soundDef != null && sound.soundDef.looping ? 1 : 0));
            AL10.alSource3f((int)sound.sourceIndex, (int)4100, (float)((float)sound.entity.position.x), (float)((float)sound.entity.position.y), (float)((float)sound.entity.position.z));
            AL10.alSourcei((int)sound.sourceIndex, (int)4105, (int)dataBufferPointer);
            queuedSounds.add(sound);
            sound.entity.sounds.add(sound);
        }
    }

    public static void addRadioStation(RadioStation station) {
        playingStations.add(station);
    }

    public static void addRadioSound(SoundInstance sound, List<Integer> buffers) {
        if (InterfaceClient.isSoundSystemReady() && sourceGetFailures < 10) {
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGetError();
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() != 0) {
                sourceGetFailures = (byte)(sourceGetFailures + 1);
                InterfaceClient.getClientPlayer().displayChatMessage("IMMERSIVE VEHICLES ERROR: Tried to play a sound, but was told no sound slots were available.  Some mod is taking up all the slots.  Probabaly Immersive Railroading or Dynamic Surroundings.  If you have those installed, complain to the mod author or check the mod configs.  Sound will not play.");
                return;
            }
            sound.sourceIndex = sourceBuffer.get(0);
            for (int bufferIndex : buffers) {
                InterfaceSound.bindBuffer(sound, bufferIndex);
            }
            queuedSounds.add(sound);
        }
    }

    public static int createBuffer(ByteBuffer buffer, IStreamDecoder decoder) {
        if (decoder.isStereo()) {
            buffer = InterfaceSound.stereoToMono(buffer);
        }
        IntBuffer newDataBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)newDataBuffer);
        AL10.alBufferData((int)newDataBuffer.get(0), (int)4353, (ByteBuffer)buffer, (int)decoder.getSampleRate());
        return newDataBuffer.get(0);
    }

    public static void deleteBuffer(int bufferIndex) {
        AL10.alDeleteBuffers((int)bufferIndex);
    }

    public static void bindBuffer(SoundInstance sound, int bufferIndex) {
        AL10.alSourceQueueBuffers((int)sound.sourceIndex, (int)bufferIndex);
    }

    public static int getFreeStationBuffer(Set<EntityRadio> playingRadios) {
        boolean freeBuffer = true;
        EntityRadio badRadio = null;
        AL10.alGetError();
        for (EntityRadio radio : playingRadios) {
            SoundInstance sound = radio.getPlayingSound();
            if (AL10.alGetSourcei((int)sound.sourceIndex, (int)4118) == 0) {
                freeBuffer = false;
                break;
            }
            if (AL10.alGetError() != 40961) continue;
            badRadio = radio;
        }
        if (badRadio != null) {
            badRadio.stop();
            return 0;
        }
        if (freeBuffer) {
            int freeBufferIndex = 0;
            IntBuffer oldDataBuffer = BufferUtils.createIntBuffer((int)1);
            for (EntityRadio radio : playingRadios) {
                SoundInstance sound = radio.getPlayingSound();
                AL10.alSourceUnqueueBuffers((int)sound.sourceIndex, (IntBuffer)oldDataBuffer);
                if (freeBufferIndex == 0) {
                    freeBufferIndex = oldDataBuffer.get(0);
                    continue;
                }
                if (freeBufferIndex == oldDataBuffer.get(0)) continue;
                badRadio = radio;
                break;
            }
            if (badRadio != null) {
                badRadio.stop();
                return 0;
            }
            return freeBufferIndex;
        }
        return 0;
    }

    private static ByteBuffer stereoToMono(ByteBuffer stereoBuffer) {
        ByteBuffer monoBuffer = ByteBuffer.allocateDirect(stereoBuffer.limit() / 2);
        while (stereoBuffer.hasRemaining()) {
            byte[] sampleSet = new byte[4];
            stereoBuffer.get(sampleSet);
            int leftSample = sampleSet[1] << 8 | sampleSet[0] & 0xFF;
            int rightSample = sampleSet[3] << 8 | sampleSet[2] & 0xFF;
            int combinedSample = (leftSample + rightSample) / 2;
            monoBuffer.put((byte)(combinedSample & 0xFF));
            monoBuffer.put((byte)(combinedSample >> 8));
        }
        return (ByteBuffer)monoBuffer.flip();
    }

    private static Integer loadOGGJarSound(String soundName) {
        if (dataSourceBuffers.containsKey(soundName)) {
            return dataSourceBuffers.get(soundName);
        }
        DecodedFile decoderOutput = OGGDecoder.parseInternalFile(soundName);
        if (decoderOutput != null) {
            IntBuffer dataBufferPointers = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)dataBufferPointers);
            ByteBuffer decoderData = decoderOutput.isStereo ? InterfaceSound.stereoToMono(decoderOutput.decodedData) : decoderOutput.decodedData;
            AL10.alBufferData((int)dataBufferPointers.get(0), (int)4353, (ByteBuffer)decoderData, (int)decoderOutput.sampleRate);
            dataSourceBuffers.put(soundName, dataBufferPointers.get(0));
            return dataSourceBuffers.get(soundName);
        }
        return null;
    }

    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            try {
                InterfaceSound.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void on(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            Iterator<SoundInstance> iterator = queuedSounds.iterator();
            while (iterator.hasNext()) {
                if (!event.getWorld().equals(iterator.next().entity.world.world)) continue;
                iterator.remove();
            }
            for (SoundInstance sound : playingSounds) {
                if (!event.getWorld().equals(sound.entity.world.world)) continue;
                if (sound.radio != null) {
                    sound.radio.stop();
                    continue;
                }
                sound.stopSound = true;
            }
            isSystemPaused = false;
            InterfaceSound.update();
        }
    }

    static {
        dataSourceBuffers = new HashMap<String, Integer>();
        playingSounds = new HashSet<SoundInstance>();
        playingStations = new ArrayList<RadioStation>();
        queuedSounds = new ArrayList<SoundInstance>();
        sourceGetFailures = 0;
    }
}

