/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.BuilderEntityExisting;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WrapperEntity {
    private static final Map<Entity, WrapperEntity> entityWrappers = new HashMap<Entity, WrapperEntity>();
    protected final Entity entity;
    private final Point3d mutablePosition = new Point3d();
    private final Point3d mutableVelocity = new Point3d();
    private final Point3d mutableSight = new Point3d();
    private final Point3d mutableSightRotation = new Point3d();
    private final BoundingBox mutableBounds = new BoundingBox(new Point3d(), 0.0, 0.0, 0.0);
    private final Point3d mutableRenderPosition = new Point3d();

    public static WrapperEntity getWrapperFor(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return WrapperPlayer.getWrapperFor((EntityPlayer)entity);
        }
        if (entity != null) {
            WrapperEntity wrapper = entityWrappers.get(entity);
            if (wrapper == null || !wrapper.isValid() || entity != wrapper.entity) {
                wrapper = new WrapperEntity(entity);
                entityWrappers.put(entity, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    protected WrapperEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean equals(Object obj) {
        return this.entity.equals(obj instanceof WrapperEntity ? ((WrapperEntity)obj).entity : obj);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean isValid() {
        return this.entity != null && !this.entity.field_70128_L && (!(this.entity instanceof EntityLivingBase) || ((EntityLivingBase)this.entity).field_70725_aQ == 0);
    }

    public UUID getID() {
        return this.entity.func_110124_au();
    }

    public WrapperWorld getWorld() {
        return WrapperWorld.getWrapperFor(this.entity.field_70170_p);
    }

    public AEntityE_Interactable<?> getEntityRiding() {
        return this.entity.func_184187_bx() instanceof BuilderEntityExisting ? (AEntityE_Interactable)((BuilderEntityExisting)this.entity.func_184187_bx()).entity : null;
    }

    public void setRiding(AEntityE_Interactable<?> entityToRide) {
        if (entityToRide != null) {
            AxisAlignedBB searchBounds = new AxisAlignedBB(new BlockPos(entityToRide.position.x, entityToRide.position.y, entityToRide.position.z)).func_186662_g(World.MAX_ENTITY_RADIUS);
            for (BuilderEntityExisting builder : this.getWorld().world.func_72872_a(BuilderEntityExisting.class, searchBounds)) {
                if (!entityToRide.equals(builder.entity)) continue;
                this.entity.func_184205_a((Entity)builder, true);
                return;
            }
        } else {
            this.entity.func_184210_p();
        }
    }

    public double getSeatOffset() {
        return 0.0;
    }

    public double getEyeHeight() {
        return this.entity.func_70047_e();
    }

    public Point3d getPosition() {
        this.mutablePosition.set(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        return this.mutablePosition;
    }

    public void setPosition(Point3d position, boolean onGround) {
        this.entity.func_70107_b(position.x, position.y, position.z);
        this.entity.field_70143_R = 0.0f;
        this.entity.field_70122_E = onGround;
    }

    public Point3d getVelocity() {
        this.mutableVelocity.set(this.entity.field_70159_w, this.entity.field_70181_x, this.entity.field_70179_y);
        return this.mutableVelocity;
    }

    public void setVelocity(Point3d motion) {
        this.entity.field_70159_w = motion.x;
        this.entity.field_70181_x = motion.y;
        this.entity.field_70179_y = motion.z;
    }

    public float getPitch() {
        return this.entity.field_70125_A;
    }

    public float getYaw() {
        return -this.entity.field_70177_z;
    }

    public float getBodyYaw() {
        return this.entity instanceof EntityLivingBase ? -((EntityLivingBase)this.entity).field_70761_aq : 0.0f;
    }

    public Point3d getLineOfSight(double distance) {
        this.mutableSightRotation.set(this.entity.field_70125_A, -this.entity.field_70177_z, 0.0);
        return this.mutableSight.set(0.0, 0.0, distance).rotateFine(this.mutableSightRotation);
    }

    public void setYaw(double yaw) {
        this.entity.field_70177_z = (float)(-yaw);
    }

    public void setBodyYaw(double yaw) {
        if (this.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)this.entity).func_181013_g((float)(-yaw));
        }
    }

    public void setPitch(double pitch) {
        this.entity.field_70125_A = (float)pitch;
    }

    public BoundingBox getBounds() {
        this.mutableBounds.widthRadius = this.entity.field_70130_N / 2.0f;
        this.mutableBounds.heightRadius = this.entity.field_70131_O / 2.0f;
        this.mutableBounds.depthRadius = this.entity.field_70130_N / 2.0f;
        this.mutableBounds.globalCenter.set(this.entity.field_70165_t, this.entity.field_70163_u + this.mutableBounds.heightRadius, this.entity.field_70161_v);
        return this.mutableBounds;
    }

    public WrapperNBT getData() {
        NBTTagCompound tag = new NBTTagCompound();
        this.entity.func_189511_e(tag);
        return new WrapperNBT(tag);
    }

    public void setData(WrapperNBT data) {
        this.entity.func_70020_e(data.tag);
    }

    public boolean leashTo(WrapperPlayer player) {
        EntityPlayer mcPlayer = player.player;
        if (this.entity instanceof EntityLiving) {
            ItemStack heldStack = mcPlayer.func_184614_ca();
            if (((EntityLiving)this.entity).func_184652_a(mcPlayer) && heldStack.func_77973_b() instanceof ItemLead) {
                ((EntityLiving)this.entity).func_110162_b((Entity)mcPlayer, true);
                if (!mcPlayer.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public void attack(final Damage damage) {
        DamageSource newSource = new DamageSource(damage.name){

            public ITextComponent func_151519_b(EntityLivingBase player) {
                EntityLivingBase recentEntity = player.func_94060_bK();
                if (recentEntity != null) {
                    if (damage.entityResponsible != null) {
                        return new TextComponentTranslation("death.attack." + this.field_76373_n + ".player.player", new Object[]{player.func_145748_c_(), damage.entityResponsible.entity.func_145748_c_(), recentEntity.func_145748_c_()});
                    }
                    return new TextComponentTranslation("death.attack." + this.field_76373_n + ".null.player", new Object[]{player.func_145748_c_(), recentEntity.func_145748_c_()});
                }
                if (damage.entityResponsible != null) {
                    return new TextComponentTranslation("death.attack." + this.field_76373_n + ".player.null", new Object[]{player.func_145748_c_(), damage.entityResponsible.entity.func_145748_c_()});
                }
                return new TextComponentTranslation("death.attack." + this.field_76373_n + ".null.null", new Object[]{player.func_145748_c_()});
            }
        };
        if (damage.isFire) {
            newSource.func_76361_j();
            this.entity.func_70015_d(5);
        }
        if (damage.isWater) {
            this.entity.func_70066_B();
            return;
        }
        if (damage.isExplosion) {
            newSource.func_94540_d();
        }
        if (damage.ignoreArmor) {
            newSource.func_76348_h();
        }
        if (damage.ignoreCooldown && this.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)this.entity).field_70172_ad = 0;
        }
        if (((Boolean)ConfigSystem.configObject.general.creativeDamage.value).booleanValue()) {
            newSource.func_76359_i();
        }
        this.entity.func_70097_a(newSource, (float)damage.amount);
        if (damage.effects != null && this.entity instanceof EntityLivingBase) {
            for (JSONPotionEffect effect : damage.effects) {
                Potion potion = Potion.func_180142_b((String)effect.name);
                if (potion != null) {
                    ((EntityLivingBase)this.entity).func_70690_d(new PotionEffect(potion, effect.duration, effect.amplifier, false, true));
                    continue;
                }
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    public Point3d getRenderedPosition(float partialTicks) {
        this.mutableRenderPosition.x = this.entity.field_70142_S + (this.entity.field_70165_t - this.entity.field_70142_S) * (double)partialTicks;
        this.mutableRenderPosition.y = this.entity.field_70137_T + (this.entity.field_70163_u - this.entity.field_70137_T) * (double)partialTicks;
        this.mutableRenderPosition.z = this.entity.field_70136_U + (this.entity.field_70161_v - this.entity.field_70136_U) * (double)partialTicks;
        return this.mutableRenderPosition;
    }

    public void addPotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof EntityLivingBase) {
            Potion potion = Potion.func_180142_b((String)effect.name);
            if (potion != null) {
                ((EntityLivingBase)this.entity).func_70690_d(new PotionEffect(potion, effect.duration, effect.amplifier, false, false));
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    public void removePotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof EntityLivingBase) {
            Potion potion = Potion.func_180142_b((String)effect.name);
            if (potion != null) {
                ((EntityLivingBase)this.entity).func_184589_d(potion);
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @SubscribeEvent
    public static void on(WorldEvent.Unload event) {
        Iterator<Entity> iterator = entityWrappers.keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().field_70170_p.equals(event.getWorld())) continue;
            iterator.remove();
        }
    }
}

