/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.IBuilderItemInterface;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class WrapperItemStack {
    private static final TileEntityFurnace VANILLA_FAKE_FURNACE = new TileEntityFurnace();
    protected final ItemStack stack;

    protected WrapperItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean isCompleteMatch(WrapperItemStack other) {
        return other.stack.func_77969_a(this.stack) && (other.stack.func_77942_o() ? other.stack.func_77978_p().equals((Object)this.stack.func_77978_p()) : !this.stack.func_77942_o());
    }

    public boolean isItemMatch(WrapperItemStack other) {
        return this.stack.func_77973_b().equals(other.getItem());
    }

    public int getFuelValue() {
        return TileEntityFurnace.func_145952_a((ItemStack)this.stack);
    }

    public WrapperItemStack getSmeltedItem() {
        return new WrapperItemStack(FurnaceRecipes.func_77602_a().func_151395_a(this.stack).func_77946_l());
    }

    public int getSmeltingTime() {
        return VANILLA_FAKE_FURNACE.func_174904_a(this.stack);
    }

    public AItemBase getItem() {
        Item item = this.stack.func_77973_b();
        return item instanceof IBuilderItemInterface ? ((IBuilderItemInterface)item).getItem() : null;
    }

    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    public int getSize() {
        return this.stack.func_190916_E();
    }

    public int getMaxSize() {
        return this.stack.func_77976_d();
    }

    public int add(int qty) {
        if (qty < 0) {
            int amountToRemove = -qty;
            if (amountToRemove > this.getSize()) {
                amountToRemove = this.getSize();
            }
            this.stack.func_190920_e(this.stack.func_190916_E() - amountToRemove);
            return qty + amountToRemove;
        }
        int amountToAdd = qty;
        if (amountToAdd + this.getSize() > this.getMaxSize()) {
            amountToAdd = this.getMaxSize() - this.getSize();
        }
        this.stack.func_190920_e(this.stack.func_190916_E() + amountToAdd);
        return qty - amountToAdd;
    }

    public WrapperItemStack split(int qty) {
        return new WrapperItemStack(this.stack.func_77979_a(qty));
    }

    public boolean interactWith(EntityFluidTank tank, WrapperPlayer player) {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null) {
            if (!player.isSneaking()) {
                int amountToDrain;
                FluidStack drainedStack = handler.drain(Integer.MAX_VALUE, false);
                if (drainedStack != null && (drainedStack = handler.drain(amountToDrain = (int)tank.fill(drainedStack.getFluid().getName(), drainedStack.amount, false), !player.isCreative())) != null) {
                    tank.fill(drainedStack.getFluid().getName(), drainedStack.amount, true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            } else {
                FluidStack containedStack = FluidRegistry.getFluidStack((String)tank.getFluid(), (int)((int)tank.getFluidLevel()));
                int amountFilled = handler.fill(containedStack, !player.isCreative());
                if (amountFilled > 0) {
                    tank.drain(tank.getFluid(), amountFilled, true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            }
            return true;
        }
        return false;
    }

    public WrapperNBT getData() {
        return this.stack.func_77942_o() ? new WrapperNBT(this.stack.func_77978_p().func_74737_b()) : new WrapperNBT();
    }

    public void setData(WrapperNBT data) {
        this.stack.func_77982_d(data != null ? data.tag : null);
    }
}

