/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Orientation3d;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class WrapperNBT {
    protected final NBTTagCompound tag;

    public WrapperNBT() {
        this.tag = new NBTTagCompound();
    }

    protected WrapperNBT(NBTTagCompound tag) {
        this.tag = tag;
    }

    public boolean getBoolean(String name) {
        return this.tag.func_74767_n(name);
    }

    public void setBoolean(String name, boolean value) {
        this.tag.func_74757_a(name, value);
    }

    public int getInteger(String name) {
        return this.tag.func_74762_e(name);
    }

    public void setInteger(String name, int value) {
        this.tag.func_74768_a(name, value);
    }

    public double getDouble(String name) {
        return this.tag.func_74769_h(name);
    }

    public void setDouble(String name, double value) {
        this.tag.func_74780_a(name, value);
    }

    public String getString(String name) {
        return this.tag.func_74779_i(name);
    }

    public void setString(String name, String value) {
        this.tag.func_74778_a(name, value);
    }

    public List<String> getStrings(String name) {
        return this.getStrings(name, this.getInteger(name + "count"));
    }

    public List<String> getStrings(String name, int count) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            values.add(this.getString(name + i));
        }
        return values;
    }

    public void setStrings(String name, Collection<String> values) {
        this.setInteger(name + "count", values.size());
        int index = 0;
        for (String value : values) {
            this.setString(name + index++, value);
        }
    }

    public UUID getUUID(String name) {
        return this.tag.func_74764_b(name) ? UUID.fromString(this.tag.func_74779_i(name)) : null;
    }

    public void setUUID(String name, UUID value) {
        this.tag.func_74778_a(name, value.toString());
    }

    public List<WrapperItemStack> getStacks(int count) {
        ArrayList<WrapperItemStack> stacks = new ArrayList<WrapperItemStack>();
        NonNullList mcList = NonNullList.func_191197_a((int)count, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)this.tag, (NonNullList)mcList);
        for (ItemStack stack : mcList) {
            stacks.add(new WrapperItemStack(stack));
        }
        return stacks;
    }

    public void setStacks(List<WrapperItemStack> stacks) {
        NonNullList mcList = NonNullList.func_191196_a();
        for (WrapperItemStack stack : stacks) {
            mcList.add((Object)stack.stack);
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)this.tag, (NonNullList)mcList);
    }

    public Point3d getPoint3d(String name) {
        return new Point3d(this.getDouble(name + "x"), this.getDouble(name + "y"), this.getDouble(name + "z"));
    }

    public void setPoint3d(String name, Point3d value) {
        this.setDouble(name + "x", value.x);
        this.setDouble(name + "y", value.y);
        this.setDouble(name + "z", value.z);
    }

    public List<Point3d> getPoint3ds(String name) {
        ArrayList<Point3d> values = new ArrayList<Point3d>();
        int count = this.getInteger(name + "count");
        for (int i = 0; i < count; ++i) {
            Point3d point = this.getPoint3d(name + i);
            if (point.isZero()) continue;
            values.add(point);
        }
        return values;
    }

    public void setPoint3ds(String name, Collection<Point3d> values) {
        this.setInteger(name + "count", values.size());
        int index = 0;
        for (Point3d value : values) {
            this.setPoint3d(name + index++, value);
        }
    }

    public Point3d getPoint3dCompact(String name) {
        return new Point3d(this.getInteger(name + "x"), this.getInteger(name + "y"), this.getInteger(name + "z"));
    }

    public void setPoint3dCompact(String name, Point3d value) {
        this.setInteger(name + "x", (int)value.x);
        this.setInteger(name + "y", (int)value.y);
        this.setInteger(name + "z", (int)value.z);
    }

    public List<Point3d> getPoint3dsCompact(String name) {
        ArrayList<Point3d> values = new ArrayList<Point3d>();
        int count = this.getInteger(name + "count");
        for (int i = 0; i < count; ++i) {
            Point3d point = this.getPoint3dCompact(name + i);
            if (point.isZero()) continue;
            values.add(point);
        }
        return values;
    }

    public void setPoint3dsCompact(String name, Collection<Point3d> values) {
        this.setInteger(name + "count", values.size());
        int index = 0;
        for (Point3d value : values) {
            this.setPoint3dCompact(name + index++, value);
        }
    }

    public Orientation3d getOrientation3d(String name) {
        return new Orientation3d(this.getPoint3d(name), this.getDouble(name + "r"), false);
    }

    public void setOrientation3d(String name, Orientation3d value) {
        this.setPoint3d(name, value.axis);
        this.setDouble(name + "r", value.rotation);
    }

    public WrapperNBT getData(String name) {
        return this.tag.func_74764_b(name) ? new WrapperNBT(this.tag.func_74775_l(name)) : null;
    }

    public WrapperNBT getDataOrNew(String name) {
        return this.tag.func_74764_b(name) ? new WrapperNBT(this.tag.func_74775_l(name)) : new WrapperNBT();
    }

    public void setData(String name, WrapperNBT value) {
        this.tag.func_74782_a(name, (NBTBase)value.tag);
    }

    public void deleteData(String name) {
        this.tag.func_82580_o(name);
    }

    public Set<String> getAllNames() {
        return this.tag.func_150296_c();
    }
}

