/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.mcinterface.IBuilderItemInterface;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperInventory;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.packets.components.APacketBase;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WrapperPlayer
extends WrapperEntity {
    private static final Map<EntityPlayer, WrapperPlayer> playerWrappers = new HashMap<EntityPlayer, WrapperPlayer>();
    protected final EntityPlayer player;

    public static WrapperPlayer getWrapperFor(EntityPlayer player) {
        if (player != null) {
            WrapperPlayer wrapper = playerWrappers.get(player);
            if (wrapper == null || !wrapper.isValid() || player != wrapper.player) {
                wrapper = new WrapperPlayer(player);
                playerWrappers.put(player, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    protected WrapperPlayer(EntityPlayer player) {
        super((Entity)player);
        this.player = player;
    }

    @Override
    public double getSeatOffset() {
        return -0.75;
    }

    public boolean isOP() {
        return this.player.func_184102_h() == null || this.player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)this.player.func_146103_bH()) != null || this.player.func_184102_h().func_71264_H();
    }

    public void displayChatMessage(String message) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(InterfaceCore.translate(message)));
    }

    public boolean isCreative() {
        return this.player.func_184812_l_();
    }

    public boolean isSpectator() {
        return this.player.func_175149_v();
    }

    public boolean isSneaking() {
        return this.player.func_70093_af();
    }

    public WrapperEntity getLeashedEntity() {
        for (EntityLiving entityLiving : this.player.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(this.player.field_70165_t - 7.0, this.player.field_70163_u - 7.0, this.player.field_70161_v - 7.0, this.player.field_70165_t + 7.0, this.player.field_70163_u + 7.0, this.player.field_70161_v + 7.0))) {
            if (!entityLiving.func_110167_bD() || !this.player.equals((Object)entityLiving.func_110166_bE())) continue;
            entityLiving.func_110160_i(true, !this.player.field_71075_bZ.field_75098_d);
            return WrapperPlayer.getWrapperFor((Entity)entityLiving);
        }
        return null;
    }

    public boolean isHoldingItemType(JSONItem.ItemComponentType type) {
        AItemBase heldItem = this.getHeldItem();
        return heldItem instanceof ItemItem && ((JSONItem)((ItemItem)heldItem).definition).item.type.equals((Object)type);
    }

    public AItemBase getHeldItem() {
        Item heldItem = this.player.func_184614_ca().func_77973_b();
        return heldItem instanceof IBuilderItemInterface ? ((IBuilderItemInterface)heldItem).getItem() : null;
    }

    public WrapperItemStack getHeldStack() {
        return new WrapperItemStack(this.player.field_71071_by.func_70301_a(this.getHotbarIndex()));
    }

    public void setHeldStack(WrapperItemStack stack) {
        this.player.field_71071_by.func_70299_a(this.getHotbarIndex(), stack.stack);
    }

    public int getHotbarIndex() {
        return this.player.field_71071_by.field_70461_c;
    }

    public WrapperInventory getInventory() {
        return new WrapperInventory((IInventory)this.player.field_71071_by);
    }

    public void sendPacket(APacketBase packet) {
        InterfacePacket.sendToPlayer(packet, this);
    }

    public void openCraftingGUI() {
        this.player.func_180468_a((IInteractionObject)new BlockWorkbench.InterfaceCraftingTable(this.player.field_70170_p, null){

            public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerAccessing) {
                return new ContainerWorkbench(playerInventory, playerAccessing.field_70170_p, playerAccessing.func_180425_c()){

                    public boolean func_75145_c(EntityPlayer playerIn) {
                        return true;
                    }
                };
            }
        });
    }

    @SubscribeEvent
    public static void on(WorldEvent.Unload event) {
        Iterator<EntityPlayer> iterator = playerWrappers.keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().field_70170_p.equals(event.getWorld())) continue;
            iterator.remove();
        }
    }
}

