/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.mcinterface;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.ABuilderEntityBase;
import minecrafttransportsimulator.mcinterface.BuilderBlock;
import minecrafttransportsimulator.mcinterface.BuilderEntityExisting;
import minecrafttransportsimulator.mcinterface.BuilderEntityRenderForwarder;
import minecrafttransportsimulator.mcinterface.BuilderTileEntity;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataCSHandshake;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class WrapperWorld {
    private static final Map<World, WrapperWorld> worldWrappers = new HashMap<World, WrapperWorld>();
    private final Map<WrapperPlayer, Integer> ticksSincePlayerJoin = new HashMap<WrapperPlayer, Integer>();
    private final Map<WrapperPlayer, BuilderEntityRenderForwarder> activePlayerFollowers = new HashMap<WrapperPlayer, BuilderEntityRenderForwarder>();
    private final List<AxisAlignedBB> mutableCollidingAABBs = new ArrayList<AxisAlignedBB>();
    private final Set<BlockPos> knownAirBlocks = new HashSet<BlockPos>();
    protected final World world;
    public final ConcurrentLinkedQueue<AEntityA_Base> allEntities = new ConcurrentLinkedQueue();
    public final ConcurrentLinkedQueue<AEntityC_Renderable> renderableEntities = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<Class<? extends AEntityA_Base>, ConcurrentLinkedQueue<? extends AEntityA_Base>> entitiesByClass = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, AEntityA_Base> trackedEntityMap = new ConcurrentHashMap();
    private final WrapperNBT savedData;

    public static WrapperWorld getWrapperFor(World world) {
        if (world != null) {
            WrapperWorld wrapper = worldWrappers.get(world);
            if (wrapper == null || world != wrapper.world) {
                wrapper = new WrapperWorld(world);
                worldWrappers.put(world, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    private WrapperWorld(World world) {
        this.world = world;
        if (world.field_72995_K) {
            this.savedData = new WrapperNBT();
            InterfacePacket.sendToServer(new PacketWorldSavedDataCSHandshake(InterfaceClient.getClientPlayer(), "", null));
        } else {
            try {
                this.savedData = this.getDataFile().exists() ? new WrapperNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(this.getDataFile()))) : new WrapperNBT();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not load saved data from disk!  This will result in data loss if we continue!");
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isClient() {
        return this.world.field_72995_K;
    }

    public long getTime() {
        return this.world.func_72820_D();
    }

    public String getName() {
        return this.world.func_72912_H().func_76065_j();
    }

    public long getMaxHeight() {
        return this.world.func_72800_K();
    }

    public void beginProfiling(String name, boolean subProfile) {
        if (subProfile) {
            this.world.field_72984_F.func_76320_a(name);
        } else {
            this.world.field_72984_F.func_76318_c(name);
        }
    }

    public void endProfiling() {
        this.world.field_72984_F.func_76319_b();
    }

    public WrapperNBT getData(String name) {
        if (name.isEmpty()) {
            return this.savedData;
        }
        return this.savedData.getData(name);
    }

    public void setData(String name, WrapperNBT value) {
        this.savedData.setData(name, value);
        if (!this.isClient()) {
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.savedData.tag, (OutputStream)new FileOutputStream(this.getDataFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not save data to disk!  This will result in data loss if we continue!");
            }
        }
    }

    public File getDataFile() {
        return new File(this.world.func_72860_G().func_75765_b(), "mtsdata.dat");
    }

    public WrapperEntity getExternalEntity(UUID entityID) {
        for (Entity entity : this.world.field_72996_f) {
            if (!entity.func_110124_au().equals(entityID)) continue;
            return WrapperEntity.getWrapperFor(entity);
        }
        return null;
    }

    public List<WrapperEntity> getEntitiesWithin(BoundingBox box) {
        ArrayList<WrapperEntity> entities = new ArrayList<WrapperEntity>();
        for (Entity entity : this.world.func_72872_a(Entity.class, box.convert())) {
            if (entity instanceof ABuilderEntityBase) continue;
            entities.add(WrapperEntity.getWrapperFor(entity));
        }
        return entities;
    }

    public List<WrapperEntity> getEntitiesHostile(WrapperEntity lookingEntity, double radius) {
        ArrayList<WrapperEntity> entities = new ArrayList<WrapperEntity>();
        for (Entity entity : this.world.func_72839_b(lookingEntity.entity, lookingEntity.entity.func_174813_aQ().func_186662_g(radius))) {
            if (!(entity instanceof IMob) || entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_70725_aQ != 0) continue;
            entities.add(WrapperEntity.getWrapperFor(entity));
        }
        return entities;
    }

    public WrapperEntity getEntityLookingAt(WrapperEntity entityLooking, float searchRadius) {
        double smallestDistance = searchRadius * 2.0f;
        Entity foundEntity = null;
        Entity mcLooker = entityLooking.entity;
        Vec3d mcLookerPos = mcLooker.func_174791_d();
        Point3d lookerLos = entityLooking.getLineOfSight(searchRadius).add(entityLooking.getPosition());
        Vec3d losVector = new Vec3d(lookerLos.x, lookerLos.y, lookerLos.z);
        for (Entity entity : this.world.func_72839_b(mcLooker, mcLooker.func_174813_aQ().func_186662_g((double)searchRadius))) {
            float distance;
            if (entity.equals((Object)mcLooker.func_184187_bx()) || entity instanceof BuilderEntityRenderForwarder || !((double)(distance = mcLooker.func_70032_d(entity)) < smallestDistance)) continue;
            smallestDistance = distance;
            RayTraceResult rayTrace = entity.func_174813_aQ().func_72327_a(mcLookerPos, losVector);
            if (rayTrace == null) continue;
            foundEntity = entity;
        }
        return WrapperEntity.getWrapperFor(foundEntity);
    }

    public void spawnEntity(AEntityB_Existing entity) {
        BuilderEntityExisting builder = new BuilderEntityExisting(entity.world.world);
        builder.loadedFromSavedNBT = true;
        builder.func_70080_a(entity.position.x, entity.position.y, entity.position.z, (float)(-entity.angles.y), (float)entity.angles.x);
        builder.entity = entity;
        this.world.func_72838_d((Entity)builder);
        this.addEntity(entity);
    }

    public List<WrapperEntity> attackEntities(Damage damage, Point3d motion) {
        List collidedEntities;
        AxisAlignedBB mcBox = damage.box.convert();
        if (motion != null) {
            mcBox = mcBox.func_72321_a(motion.x, motion.y, motion.z);
            collidedEntities = this.world.func_72872_a(Entity.class, mcBox);
        } else {
            collidedEntities = this.world.func_72872_a(Entity.class, mcBox);
        }
        Point3d startPoint = null;
        Point3d endPoint = null;
        Vec3d start = null;
        Vec3d end = null;
        ArrayList<WrapperEntity> hitEntities = new ArrayList<WrapperEntity>();
        if (motion != null) {
            startPoint = damage.box.globalCenter;
            endPoint = damage.box.globalCenter.copy().add(motion);
            start = new Vec3d(startPoint.x, startPoint.y, startPoint.z);
            end = new Vec3d(endPoint.x, endPoint.y, endPoint.z);
        }
        for (Entity mcEntityCollided : collidedEntities) {
            Entity ridingEntity;
            if (mcEntityCollided instanceof ABuilderEntityBase) continue;
            if (damage.damgeSource != null && (ridingEntity = mcEntityCollided.func_184187_bx()) instanceof BuilderEntityExisting) {
                AEntityB_Existing internalEntity = ((BuilderEntityExisting)ridingEntity).entity;
                if (damage.damgeSource.equals(internalEntity)) continue;
                if (damage.damgeSource instanceof APart) {
                    APart damagingPart = (APart)damage.damgeSource;
                    if (damagingPart.entityOn.equals(internalEntity)) continue;
                }
            }
            if (motion != null && mcEntityCollided.func_174813_aQ().func_72327_a(start, end) == null) continue;
            hitEntities.add(WrapperEntity.getWrapperFor(mcEntityCollided));
        }
        if (this.isClient()) {
            return hitEntities;
        }
        for (WrapperEntity entity : hitEntities) {
            entity.attack(damage);
        }
        return null;
    }

    public void loadEntities(BoundingBox box, AEntityE_Interactable<?> entityToLoad) {
        block0: for (Entity entity : this.world.func_72872_a(Entity.class, box.convert())) {
            if (entity.func_184218_aH() || !(entity instanceof INpc) && !(entity instanceof EntityCreature) || entity instanceof IMob) continue;
            for (Point3d ridableLocation : entityToLoad.ridableLocations) {
                if (entityToLoad.locationRiderMap.containsKey((Object)ridableLocation)) continue;
                if (!(entityToLoad instanceof EntityVehicleF_Physics) || ((EntityVehicleF_Physics)entityToLoad).getPartAtLocation((Point3d)ridableLocation).placementDefinition.isController) {
                    // empty if block
                }
                entityToLoad.addRider(new WrapperEntity(entity), ridableLocation);
                continue block0;
            }
        }
    }

    public ABlockBase getBlock(Point3d position) {
        Block block = this.world.func_180495_p(new BlockPos(position.x, position.y, position.z)).func_177230_c();
        return block instanceof BuilderBlock ? ((BuilderBlock)block).block : null;
    }

    public float getBlockHardness(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_180495_p(pos).func_185887_b(this.world, pos);
    }

    public float getBlockSlipperiness(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_177230_c().getSlipperiness(state, (IBlockAccess)this.world, pos, null);
    }

    public ABlockBase.BlockMaterial getBlockMaterial(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        Material material = this.world.func_180495_p(pos).func_185904_a();
        if (material.equals(Material.field_151578_c) || material.equals(Material.field_151577_b)) {
            return this.world.func_175727_C(pos.func_177984_a()) ? ABlockBase.BlockMaterial.DIRT_WET : ABlockBase.BlockMaterial.DIRT;
        }
        if (material.equals(Material.field_151595_p)) {
            return this.world.func_175727_C(pos.func_177984_a()) ? ABlockBase.BlockMaterial.SAND_WET : ABlockBase.BlockMaterial.SAND;
        }
        if (material.equals(Material.field_151597_y) || material.equals(Material.field_151596_z)) {
            return ABlockBase.BlockMaterial.SNOW;
        }
        if (material.equals(Material.field_151588_w) || material.equals(Material.field_151598_x)) {
            return ABlockBase.BlockMaterial.ICE;
        }
        return this.world.func_175727_C(pos.func_177984_a()) ? ABlockBase.BlockMaterial.NORMAL_WET : ABlockBase.BlockMaterial.NORMAL;
    }

    public List<WrapperItemStack> getBlockDrops(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.world, pos, state, 0);
        ArrayList<WrapperItemStack> convertedList = new ArrayList<WrapperItemStack>();
        for (ItemStack stack : drops) {
            convertedList.add(new WrapperItemStack(stack.func_77946_l()));
        }
        return convertedList;
    }

    public Point3d getBlockHit(Point3d position, Point3d delta) {
        BlockPos pos;
        Vec3d start = new Vec3d(position.x, position.y, position.z);
        RayTraceResult trace = this.world.func_147447_a(start, start.func_72441_c(delta.x, delta.y, delta.z), false, true, false);
        if (trace != null && (pos = trace.func_178782_a()) != null) {
            return new Point3d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return null;
    }

    public boolean isBlockSolid(Point3d position, ABlockBase.Axis axis) {
        if (axis.blockBased) {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            IBlockState state = this.world.func_180495_p(pos);
            Block offsetMCBlock = state.func_177230_c();
            EnumFacing facing = EnumFacing.valueOf((String)axis.name());
            return offsetMCBlock != null ? !offsetMCBlock.equals(Blocks.field_180401_cv) && state.isSideSolid((IBlockAccess)this.world, pos, facing) : false;
        }
        return false;
    }

    public boolean isBlockLiquid(Point3d position) {
        return this.world.func_180495_p(new BlockPos(position.x, position.y, position.z)).func_185904_a().func_76224_d();
    }

    public boolean isBlockBottomSlab(Point3d position) {
        IBlockState state = this.world.func_180495_p(new BlockPos(position.x, position.y, position.z));
        Block block = state.func_177230_c();
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
    }

    public boolean isBlockTopSlab(Point3d position) {
        IBlockState state = this.world.func_180495_p(new BlockPos(position.x, position.y, position.z));
        Block block = state.func_177230_c();
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
    }

    public double getHeight(Point3d position) {
        return position.y - (double)this.world.func_189649_b((int)position.x, (int)position.z);
    }

    public void updateBoundingBoxCollisions(BoundingBox box, Point3d collisionMotion, boolean ignoreIfGreater) {
        AxisAlignedBB mcBox = box.convert();
        box.collidingBlockPositions.clear();
        this.mutableCollidingAABBs.clear();
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (this.world.func_175667_e(pos)) {
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_177230_c().func_176209_a(state, false) && state.func_185890_d((IBlockAccess)this.world, pos) != null) {
                            int oldCollidingBlockCount = this.mutableCollidingAABBs.size();
                            state.func_185908_a(this.world, pos, mcBox, this.mutableCollidingAABBs, null, false);
                            if (this.mutableCollidingAABBs.size() > oldCollidingBlockCount) {
                                box.collidingBlockPositions.add(new Point3d(i, j, k));
                            }
                        }
                        if (box.collidesWithLiquids && state.func_185904_a().func_76224_d()) {
                            this.mutableCollidingAABBs.add(state.func_185900_c((IBlockAccess)this.world, pos).func_186670_a(pos));
                            box.collidingBlockPositions.add(new Point3d(i, j, k));
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        box.currentCollisionDepth.set(0.0, 0.0, 0.0);
        double minDelta = 0.0;
        for (AxisAlignedBB colBox : this.mutableCollidingAABBs) {
            if (collisionMotion.x > 0.0) {
                double boxCollisionDepth = mcBox.field_72336_d - colBox.field_72340_a;
                if (!ignoreIfGreater || collisionMotion.x - boxCollisionDepth > -minDelta) {
                    box.currentCollisionDepth.x = Math.max(box.currentCollisionDepth.x, boxCollisionDepth);
                }
            } else if (collisionMotion.x < 0.0) {
                double boxCollisionDepth = colBox.field_72336_d - mcBox.field_72340_a;
                if (!ignoreIfGreater || collisionMotion.x + boxCollisionDepth < minDelta) {
                    box.currentCollisionDepth.x = Math.max(box.currentCollisionDepth.x, boxCollisionDepth);
                }
            }
            if (collisionMotion.y > 0.0) {
                double boxCollisionDepth = mcBox.field_72337_e - colBox.field_72338_b;
                if (!ignoreIfGreater || collisionMotion.y - boxCollisionDepth > -minDelta) {
                    box.currentCollisionDepth.y = Math.max(box.currentCollisionDepth.y, boxCollisionDepth);
                }
            } else if (collisionMotion.y < 0.0) {
                double boxCollisionDepth = colBox.field_72337_e - mcBox.field_72338_b;
                if (!ignoreIfGreater || collisionMotion.y + boxCollisionDepth < minDelta) {
                    box.currentCollisionDepth.y = Math.max(box.currentCollisionDepth.y, boxCollisionDepth);
                }
            }
            if (collisionMotion.z > 0.0) {
                double boxCollisionDepth = mcBox.field_72334_f - colBox.field_72339_c;
                if (ignoreIfGreater && !(collisionMotion.z - boxCollisionDepth > -minDelta)) continue;
                box.currentCollisionDepth.z = Math.max(box.currentCollisionDepth.z, boxCollisionDepth);
                continue;
            }
            if (!(collisionMotion.z < 0.0)) continue;
            double boxCollisionDepth = colBox.field_72334_f - mcBox.field_72339_c;
            if (ignoreIfGreater && !(collisionMotion.z + boxCollisionDepth < minDelta)) continue;
            box.currentCollisionDepth.z = Math.max(box.currentCollisionDepth.z, boxCollisionDepth);
        }
        if (box.currentCollisionDepth.isZero()) {
            box.collidingBlockPositions.clear();
        }
    }

    public boolean checkForCollisions(BoundingBox box, Point3d offset, boolean clearCache) {
        if (clearCache) {
            this.knownAirBlocks.clear();
        }
        this.mutableCollidingAABBs.clear();
        AxisAlignedBB mcBox = box.convertWithOffset(offset.x, offset.y, offset.z);
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (!this.knownAirBlocks.contains(pos) && this.world.func_175667_e(pos)) {
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_177230_c().func_176209_a(state, false) && state.func_185890_d((IBlockAccess)this.world, pos) != null) {
                            int oldCollidingBlockCount = this.mutableCollidingAABBs.size();
                            state.func_185908_a(this.world, pos, mcBox, this.mutableCollidingAABBs, null, false);
                            if (this.mutableCollidingAABBs.size() > oldCollidingBlockCount) {
                                return true;
                            }
                        } else {
                            this.knownAirBlocks.add(pos);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public int getRedstonePower(Point3d position) {
        return this.world.func_175687_A(new BlockPos(position.x, position.y, position.z));
    }

    public float getRainStrength(Point3d position) {
        return this.world.func_175727_C(new BlockPos(position.x, position.y + 1.0, position.z)) ? this.world.func_72867_j(1.0f) + this.world.func_72819_i(1.0f) : 0.0f;
    }

    public float getTemperature(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_180494_b(pos).func_180626_a(pos);
    }

    public <TileEntityType extends ATileEntityBase<JSONDefinition>, JSONDefinition extends AJSONMultiModelProvider> boolean setBlock(ABlockBase block, Point3d position, WrapperPlayer playerWrapper, ABlockBase.Axis axis) {
        if (!this.world.field_72995_K) {
            BuilderBlock wrapper = BuilderBlock.blockMap.get(block);
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            if (playerWrapper != null) {
                IBlockState newState;
                WrapperPlayer player = playerWrapper;
                WrapperItemStack stack = playerWrapper.getHeldStack();
                AItemBase item = stack.getItem();
                EnumFacing facing = EnumFacing.valueOf((String)axis.name());
                if (!this.world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.world, pos)) {
                    pos = pos.func_177972_a(facing);
                    position.add(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
                }
                if (item != null && player.player.func_175151_a(pos, facing, stack.stack) && this.world.func_190527_a((Block)wrapper, pos, false, facing, null) && this.world.func_180501_a(pos, newState = wrapper.getStateForPlacement(this.world, pos, facing, 0.0f, 0.0f, 0.0f, 0, (EntityLivingBase)player.player, EnumHand.MAIN_HAND), 11)) {
                    if (block instanceof ABlockBaseTileEntity) {
                        BuilderTileEntity builderTile = (BuilderTileEntity)this.world.func_175625_s(pos);
                        WrapperNBT data = stack.getData();
                        if (item instanceof AItemPack) {
                            ((AItemPack)item).populateDefaultData(data);
                        }
                        builderTile.tileEntity = ((ABlockBaseTileEntity)block).createTileEntity(this, position, player, data);
                        this.addEntity((AEntityA_Base)builderTile.tileEntity);
                    }
                    stack.add(-1);
                    return true;
                }
            } else {
                IBlockState newState = wrapper.func_176223_P();
                if (this.world.func_180501_a(pos, newState, 11)) {
                    return true;
                }
            }
        }
        return false;
    }

    public <TileEntityType extends ATileEntityBase<?>> TileEntityType getTileEntity(Point3d position) {
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z));
        return tile instanceof BuilderTileEntity ? (TileEntityType)((BuilderTileEntity)tile).tileEntity : null;
    }

    public void markTileEntityChanged(Point3d position) {
        this.world.func_175625_s(new BlockPos(position.x, position.y, position.z)).func_70296_d();
    }

    public float getLightBrightness(Point3d position, boolean calculateBlock) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        float sunLight = this.world.func_72971_b(0.0f) * (float)(this.world.func_175642_b(EnumSkyBlock.SKY, pos) - this.world.func_175657_ab()) / 15.0f;
        float blockLight = calculateBlock ? (float)this.world.func_175705_a(EnumSkyBlock.BLOCK, pos) / 15.0f : 0.0f;
        return Math.max(sunLight, blockLight);
    }

    public void updateLightBrightness(Point3d position) {
        Object tile = this.getTileEntity(position);
        if (tile != null) {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            this.world.func_175664_x(pos);
        }
    }

    public void destroyBlock(Point3d position, boolean spawnDrops) {
        this.world.func_175655_b(new BlockPos(position.x, position.y, position.z), spawnDrops);
    }

    public boolean isAir(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.isAir(state, (IBlockAccess)this.world, pos);
    }

    public boolean isFire(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_185904_a().equals(Material.field_151581_o);
    }

    public void setToFire(Point3d position) {
        this.world.func_175656_a(new BlockPos(position.x, position.y, position.z), Blocks.field_150480_ab.func_176223_P());
    }

    public void extinguish(Point3d position) {
        this.world.func_175719_a(null, new BlockPos(position.x, position.y, position.z), EnumFacing.UP);
    }

    public boolean fertilizeBlock(Point3d position, WrapperItemStack stack) {
        IGrowable growable;
        BlockPos cropPos;
        IBlockState cropState;
        Block cropBlock;
        if (stack.getItem().equals(Items.field_151100_aR) && !this.world.field_72995_K && (cropBlock = (cropState = this.world.func_180495_p(cropPos = new BlockPos(position.x, position.y, position.z))).func_177230_c()) instanceof IGrowable && (growable = (IGrowable)cropState.func_177230_c()).func_176473_a(this.world, cropPos, cropState, this.world.field_72995_K)) {
            ItemDye.func_179234_a((ItemStack)stack.stack.func_77946_l(), (World)this.world, (BlockPos)cropPos);
            return true;
        }
        return false;
    }

    public List<WrapperItemStack> harvestBlock(Point3d position) {
        ArrayList<WrapperItemStack> cropDrops;
        block5: {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            IBlockState state = this.world.func_180495_p(pos);
            cropDrops = new ArrayList<WrapperItemStack>();
            if ((!(state.func_177230_c() instanceof BlockCrops) || !((BlockCrops)state.func_177230_c()).func_185525_y(state)) && !(state.func_177230_c() instanceof BlockBush)) break block5;
            Block harvestedBlock = state.func_177230_c();
            NonNullList drops = NonNullList.func_191196_a();
            this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), harvestedBlock.getSoundType(state, this.world, pos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            if (!this.world.field_72995_K) {
                harvestedBlock.getDrops(drops, (IBlockAccess)this.world, pos, state, 0);
                this.world.func_175698_g(pos);
                if (harvestedBlock instanceof BlockCrops) {
                    for (ItemStack drop : drops) {
                        cropDrops.add(new WrapperItemStack(drop.func_77946_l()));
                    }
                } else {
                    for (ItemStack stack : drops) {
                        if (stack.func_190916_E() <= 0) continue;
                        this.world.func_72838_d((Entity)new EntityItem(this.world, position.x, position.y, position.z, stack));
                    }
                }
            }
        }
        return cropDrops;
    }

    public boolean plantBlock(Point3d position, WrapperItemStack stack) {
        Item item = stack.stack.func_77973_b();
        if (item instanceof IPlantable) {
            IBlockState plantState;
            BlockPos cropPos;
            IPlantable plantable = (IPlantable)item;
            BlockPos farmlandPos = new BlockPos(position.x, position.y, position.z);
            IBlockState farmlandState = this.world.func_180495_p(farmlandPos);
            Block farmlandBlock = farmlandState.func_177230_c();
            if (farmlandBlock.equals(Blocks.field_150458_ak) && this.world.func_175623_d(cropPos = farmlandPos.func_177984_a()) && farmlandBlock.canSustainPlant(plantState = plantable.getPlant((IBlockAccess)this.world, cropPos), (IBlockAccess)this.world, farmlandPos, EnumFacing.UP, plantable)) {
                this.world.func_180501_a(cropPos, plantState, 11);
                this.world.func_184134_a((double)farmlandPos.func_177958_n(), (double)farmlandPos.func_177956_o(), (double)farmlandPos.func_177952_p(), plantState.func_177230_c().getSoundType(plantState, this.world, farmlandPos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                return true;
            }
        }
        return false;
    }

    public boolean plowBlock(Point3d position) {
        IBlockState newState;
        BlockPos pos;
        block5: {
            block6: {
                Block block;
                IBlockState oldState;
                block4: {
                    pos = new BlockPos(position.x, position.y, position.z);
                    oldState = this.world.func_180495_p(pos);
                    newState = null;
                    block = oldState.func_177230_c();
                    if (!block.equals(Blocks.field_150349_c) && !block.equals(Blocks.field_185774_da)) break block4;
                    newState = Blocks.field_150458_ak.func_176223_P();
                    break block5;
                }
                if (!block.equals(Blocks.field_150346_d)) break block6;
                switch ((BlockDirt.DirtType)oldState.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        newState = Blocks.field_150458_ak.func_176223_P();
                        break block5;
                    }
                    case COARSE_DIRT: {
                        newState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
                        break block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        this.world.func_180501_a(pos, newState, 11);
        this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        return true;
    }

    public void removeSnow(Point3d position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_185904_a().equals(Material.field_151597_y) || state.func_185904_a().equals(Material.field_151596_z)) {
            this.world.func_175698_g(pos);
            this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187807_fF, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public boolean insertStack(Point3d position, ABlockBase.Axis axis, WrapperItemStack stack) {
        IItemHandler itemHandler;
        EnumFacing facing = EnumFacing.valueOf((String)axis.name());
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z).func_177972_a(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack remainingStack = itemHandler.insertItem(i, stack.stack, true);
                if (remainingStack.func_190916_E() >= stack.stack.func_190916_E()) continue;
                WrapperItemStack stackToInsert = stack.split(1);
                itemHandler.insertItem(i, stackToInsert.stack, false);
                return true;
            }
        }
        return false;
    }

    public WrapperItemStack extractStack(Point3d position, ABlockBase.Axis axis) {
        IItemHandler itemHandler;
        EnumFacing facing = EnumFacing.valueOf((String)axis.name());
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z).func_177972_a(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack extractedStack = itemHandler.extractItem(i, 1, false);
                if (extractedStack.func_190926_b()) continue;
                return new WrapperItemStack(extractedStack);
            }
        }
        return null;
    }

    public void spawnItem(AItemBase item, WrapperNBT data, Point3d point) {
        this.world.func_72838_d((Entity)new EntityItem(this.world, point.x, point.y + 1.0, point.z, item.getNewStack((WrapperNBT)data).stack));
    }

    public void spawnItemStack(WrapperItemStack stack, Point3d point) {
        this.world.func_72838_d((Entity)new EntityItem(this.world, point.x, point.y, point.z, stack.stack));
    }

    public void spawnExplosion(Point3d location, double strength, boolean flames) {
        this.world.func_72885_a(null, location.x, location.y, location.z, (float)strength, flames, ((Boolean)ConfigSystem.configObject.general.blockBreakage.value).booleanValue());
    }

    @SubscribeEvent
    public void on(TickEvent.WorldTickEvent event) {
        if (event.world.equals(this.world) && event.phase.equals((Object)TickEvent.Phase.END) && !event.world.field_72995_K) {
            for (EntityPlayer player : event.world.field_73010_i) {
                WrapperPlayer playerWrapper = WrapperPlayer.getWrapperFor(player);
                if (this.activePlayerFollowers.containsKey(playerWrapper)) {
                    BuilderEntityRenderForwarder follower = this.activePlayerFollowers.get(playerWrapper);
                    if (follower.field_70170_p != player.field_70170_p || follower.playerFollowing != player || player.field_70128_L || follower.field_70128_L || follower.idleTickCounter == 20) {
                        follower.func_70106_y();
                        this.activePlayerFollowers.remove(playerWrapper);
                        this.ticksSincePlayerJoin.remove(playerWrapper);
                    } else {
                        ++follower.idleTickCounter;
                        continue;
                    }
                }
                if (this.activePlayerFollowers.containsKey(playerWrapper)) continue;
                int totalTicksWaited = 0;
                if (this.ticksSincePlayerJoin.containsKey(playerWrapper)) {
                    totalTicksWaited = this.ticksSincePlayerJoin.get(playerWrapper);
                }
                if (++totalTicksWaited == 60) {
                    BuilderEntityRenderForwarder follower = new BuilderEntityRenderForwarder(player);
                    follower.loadedFromSavedNBT = true;
                    event.world.func_72838_d((Entity)follower);
                    this.activePlayerFollowers.put(playerWrapper, follower);
                    EntityPlayerGun entity = new EntityPlayerGun(this, playerWrapper, new WrapperNBT());
                    this.spawnEntity(entity);
                    if (((List)ConfigSystem.configObject.general.joinedPlayers.value).contains(playerWrapper.getID())) continue;
                    player.func_191521_c(((AItemBase)PackParserSystem.getItem((String)"mts", (String)"handbook_car")).getNewStack(null).stack);
                    player.func_191521_c(((AItemBase)PackParserSystem.getItem((String)"mts", (String)"handbook_plane")).getNewStack(null).stack);
                    ((List)ConfigSystem.configObject.general.joinedPlayers.value).add(playerWrapper.getID());
                    ConfigSystem.saveToDisk();
                    continue;
                }
                this.ticksSincePlayerJoin.put(playerWrapper, totalTicksWaited);
            }
        }
    }

    @SubscribeEvent
    public void on(WorldEvent.Unload event) {
        if (event.getWorld().equals(this.world)) {
            for (AEntityA_Base entity : this.allEntities) {
                entity.remove();
            }
            worldWrappers.remove(this);
        }
    }

    public <EntityType extends AEntityA_Base> void addEntity(EntityType entity) {
        ConcurrentLinkedQueue<AEntityA_Base> classList;
        this.allEntities.add(entity);
        if (entity instanceof AEntityC_Renderable) {
            this.renderableEntities.add((AEntityC_Renderable)entity);
        }
        if ((classList = this.entitiesByClass.get(entity.getClass())) == null) {
            classList = new ConcurrentLinkedQueue();
            this.entitiesByClass.put(entity.getClass(), classList);
        }
        classList.add(entity);
        if (entity.shouldSync()) {
            this.trackedEntityMap.put(entity.uniqueUUID, entity);
        }
    }

    public <EntityType extends AEntityA_Base> EntityType getEntity(UUID uniqueUUID) {
        return (EntityType)this.trackedEntityMap.get(uniqueUUID);
    }

    public <EntityType extends AEntityA_Base> ConcurrentLinkedQueue<EntityType> getEntitiesOfType(Class<EntityType> entityClass) {
        ConcurrentLinkedQueue<AEntityA_Base> classListing = this.entitiesByClass.get(entityClass);
        if (classListing == null) {
            classListing = new ConcurrentLinkedQueue();
            this.entitiesByClass.put(entityClass, classListing);
        }
        return classListing;
    }

    public void removeEntity(AEntityA_Base entity) {
        this.allEntities.remove(entity);
        if (entity instanceof AEntityC_Renderable) {
            this.renderableEntities.remove(entity);
        }
        this.entitiesByClass.get(entity.getClass()).remove(entity);
        if (entity.shouldSync()) {
            this.trackedEntityMap.remove(entity.uniqueUUID);
        }
    }
}

