/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHit;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitBlock;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitEntity;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHitWrapper;
import minecrafttransportsimulator.packets.instances.PacketEntityColorChange;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityInstrumentChange;
import minecrafttransportsimulator.packets.instances.PacketEntityRiderChange;
import minecrafttransportsimulator.packets.instances.PacketEntityTextChange;
import minecrafttransportsimulator.packets.instances.PacketEntityTrailerChange;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketFluidTankChange;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketFurnaceTimeSet;
import minecrafttransportsimulator.packets.instances.PacketGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketInventoryContainerChange;
import minecrafttransportsimulator.packets.instances.PacketItemInteractable;
import minecrafttransportsimulator.packets.instances.PacketPartChange;
import minecrafttransportsimulator.packets.instances.PacketPartEffector;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.packets.instances.PacketPartGroundDevice;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPartSeat;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketPlayerCraftItem;
import minecrafttransportsimulator.packets.instances.PacketPlayerItemTransfer;
import minecrafttransportsimulator.packets.instances.PacketRadioStateChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpDispense;
import minecrafttransportsimulator.packets.instances.PacketTileEntityLoaderConnection;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadChange;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadCollisionUpdate;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadConnectionUpdate;
import minecrafttransportsimulator.packets.instances.PacketTileEntitySignalControllerChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleBeaconChange;
import minecrafttransportsimulator.packets.instances.PacketVehicleInteract;
import minecrafttransportsimulator.packets.instances.PacketVehicleServerMovement;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataCSHandshake;

public abstract class APacketBase {
    public APacketBase(ByteBuf buf) {
    }

    public boolean runOnMainThread() {
        return true;
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeByte((int)InterfacePacket.getPacketIndex(this));
    }

    public abstract void handle(WrapperWorld var1);

    protected static void writeStringToBuffer(String string, ByteBuf buf) {
        byte[] stringAsBytes = string.getBytes(StandardCharsets.UTF_8);
        if (stringAsBytes.length > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Tried to write a string of: " + stringAsBytes.length + " bytes to a packet.  Max string byte size is: " + Short.MAX_VALUE);
        }
        buf.writeShort(stringAsBytes.length);
        buf.writeBytes(stringAsBytes);
    }

    protected static String readStringFromBuffer(ByteBuf buf) {
        short stringLength = buf.readShort();
        String returnString = buf.toString(buf.readerIndex(), (int)stringLength, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + stringLength);
        return returnString;
    }

    protected static void writeUUIDToBuffer(UUID uniqueUUID, ByteBuf buf) {
        buf.writeLong(uniqueUUID.getMostSignificantBits());
        buf.writeLong(uniqueUUID.getLeastSignificantBits());
    }

    protected static UUID readUUIDFromBuffer(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    protected static void writePoint3dToBuffer(Point3d point, ByteBuf buf) {
        buf.writeDouble(point.x);
        buf.writeDouble(point.y);
        buf.writeDouble(point.z);
    }

    protected static Point3d readPoint3dFromBuffer(ByteBuf buf) {
        return new Point3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    protected static void writePoint3dCompactToBuffer(Point3d point, ByteBuf buf) {
        buf.writeInt((int)point.x);
        buf.writeInt((int)point.y);
        buf.writeInt((int)point.z);
    }

    protected static Point3d readPoint3dCompactFromBuffer(ByteBuf buf) {
        return new Point3d(buf.readInt(), buf.readInt(), buf.readInt());
    }

    protected static void writeDataToBuffer(WrapperNBT data, ByteBuf buf) {
        InterfacePacket.writeDataToBuffer(data, buf);
    }

    protected static WrapperNBT readDataFromBuffer(ByteBuf buf) {
        return InterfacePacket.readDataFromBuffer(buf);
    }

    public static void initPackets(byte packetIndex) {
        byte by = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by, PacketEntityColorChange.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by2, PacketEntityInstrumentChange.class);
        byte by3 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by3, PacketEntityRiderChange.class);
        byte by4 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by4, PacketEntityTextChange.class);
        byte by5 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by5, PacketEntityTrailerChange.class);
        byte by6 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by6, PacketEntityVariableIncrement.class);
        byte by7 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by7, PacketEntityVariableSet.class);
        byte by8 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by8, PacketEntityVariableToggle.class);
        byte by9 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by9, PacketEntityBulletHit.class);
        byte by10 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by10, PacketEntityBulletHitBlock.class);
        byte by11 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by11, PacketEntityBulletHitEntity.class);
        byte by12 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by12, PacketEntityBulletHitWrapper.class);
        byte by13 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by13, PacketFluidTankChange.class);
        byte by14 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by14, PacketInventoryContainerChange.class);
        byte by15 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by15, PacketItemInteractable.class);
        byte by16 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by16, PacketFurnaceFuelAdd.class);
        byte by17 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by17, PacketFurnaceTimeSet.class);
        byte by18 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by18, PacketGUIRequest.class);
        byte by19 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by19, PacketEntityGUIRequest.class);
        byte by20 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by20, PacketPartChange.class);
        byte by21 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by21, PacketPartGun.class);
        byte by22 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by22, PacketPartEffector.class);
        byte by23 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by23, PacketPartEngine.class);
        byte by24 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by24, PacketPartGroundDevice.class);
        byte by25 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by25, PacketPartInteractable.class);
        byte by26 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by26, PacketPartSeat.class);
        byte by27 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by27, PacketPlayerChatMessage.class);
        byte by28 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by28, PacketPlayerCraftItem.class);
        byte by29 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by29, PacketPlayerItemTransfer.class);
        byte by30 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by30, PacketRadioStateChange.class);
        byte by31 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by31, PacketTileEntityLoaderConnection.class);
        byte by32 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by32, PacketTileEntityFuelPumpConnection.class);
        byte by33 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by33, PacketTileEntityFuelPumpDispense.class);
        byte by34 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by34, PacketTileEntityRoadCollisionUpdate.class);
        byte by35 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by35, PacketTileEntityPoleChange.class);
        byte by36 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by36, PacketTileEntityRoadChange.class);
        byte by37 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by37, PacketTileEntityRoadConnectionUpdate.class);
        byte by38 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by38, PacketTileEntitySignalControllerChange.class);
        byte by39 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by39, PacketVehicleBeaconChange.class);
        byte by40 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by40, PacketVehicleInteract.class);
        byte by41 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by41, PacketVehicleServerMovement.class);
        byte by42 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfacePacket.registerPacket(by42, PacketWorldSavedDataCSHandshake.class);
    }
}

