/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;

public abstract class APacketEntity<EntityType extends AEntityA_Base>
extends APacketBase {
    private final UUID uniqueUUID;

    public APacketEntity(AEntityA_Base entity) {
        super(null);
        this.uniqueUUID = entity.uniqueUUID;
    }

    public APacketEntity(ByteBuf buf) {
        super(buf);
        this.uniqueUUID = APacketEntity.readUUIDFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        APacketEntity.writeUUIDToBuffer(this.uniqueUUID, buf);
    }

    @Override
    public void handle(WrapperWorld world) {
        Object entity = world.getEntity(this.uniqueUUID);
        if (entity != null && this.handle(world, entity) && !world.isClient()) {
            InterfacePacket.sendToAllClients(this);
            if (entity instanceof ATileEntityBase) {
                world.markTileEntityChanged(((ATileEntityBase)entity).position);
            }
        }
    }

    protected static int clampAngle(int min, int max, int value) {
        return value < min ? min : (value > max ? max : value);
    }

    protected abstract boolean handle(WrapperWorld var1, EntityType var2);
}

