/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketEntityBulletHit
extends APacketEntity<PartGun> {
    protected final ItemBullet bulletItem;
    protected final Point3d hitPosition;
    private final int bulletNumber;

    public PacketEntityBulletHit(EntityBullet bullet, Point3d hitPosition) {
        super(bullet.gun);
        this.bulletItem = (ItemBullet)bullet.getItem();
        this.hitPosition = hitPosition;
        this.bulletNumber = bullet.bulletNumber;
    }

    public PacketEntityBulletHit(ByteBuf buf) {
        super(buf);
        this.bulletItem = (ItemBullet)PackParserSystem.getItem(PacketEntityBulletHit.readStringFromBuffer(buf), PacketEntityBulletHit.readStringFromBuffer(buf), PacketEntityBulletHit.readStringFromBuffer(buf));
        this.hitPosition = PacketEntityBulletHit.readPoint3dFromBuffer(buf);
        this.bulletNumber = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityBulletHit.writeStringToBuffer(((JSONBullet)this.bulletItem.definition).packID, buf);
        PacketEntityBulletHit.writeStringToBuffer(((JSONBullet)this.bulletItem.definition).systemName, buf);
        PacketEntityBulletHit.writeStringToBuffer(this.bulletItem.subName, buf);
        PacketEntityBulletHit.writePoint3dToBuffer(this.hitPosition, buf);
        buf.writeInt(this.bulletNumber);
    }

    @Override
    public boolean handle(WrapperWorld world, PartGun gun) {
        if (!world.isClient()) {
            if (!gun.bulletsHitOnServer.contains(this.bulletNumber)) {
                gun.bulletsHitOnServer.add(this.bulletNumber);
                if (((JSONBullet)this.bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.EXPLOSIVE)) {
                    float blastSize = ((JSONBullet)this.bulletItem.definition).bullet.blastStrength == 0.0f ? ((JSONBullet)this.bulletItem.definition).bullet.diameter / 10.0f : ((JSONBullet)this.bulletItem.definition).bullet.blastStrength;
                    world.spawnExplosion(this.hitPosition, blastSize, ((JSONBullet)this.bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.INCENDIARY));
                    return false;
                }
                return this.handleBulletHit(world);
            }
        } else {
            this.handleBulletHit(world);
        }
        return false;
    }

    public boolean handleBulletHit(WrapperWorld world) {
        return false;
    }
}

