/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHit;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PacketEntityBulletHitBlock
extends PacketEntityBulletHit {
    public PacketEntityBulletHitBlock(EntityBullet bullet, Point3d blockPosition) {
        super(bullet, blockPosition);
    }

    public PacketEntityBulletHitBlock(ByteBuf buf) {
        super(buf);
    }

    @Override
    public boolean handleBulletHit(WrapperWorld world) {
        if (!world.isClient()) {
            if (((JSONBullet)this.bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.WATER)) {
                world.extinguish(this.hitPosition);
            } else {
                float hardnessHit = world.getBlockHardness(this.hitPosition);
                if (((Boolean)ConfigSystem.configObject.general.blockBreakage.value).booleanValue() && !world.isAir(this.hitPosition) && hardnessHit > 0.0f && (double)hardnessHit <= Math.random() * (double)0.3f + (double)(0.3f * ((JSONBullet)this.bulletItem.definition).bullet.diameter / 20.0f)) {
                    world.destroyBlock(this.hitPosition, true);
                } else if (((JSONBullet)this.bulletItem.definition).bullet.types.contains((Object)JSONBullet.BulletType.INCENDIARY)) {
                    this.hitPosition.add(0.0, 1.0, 0.0);
                    if (world.isAir(this.hitPosition)) {
                        world.setToFire(this.hitPosition);
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        InterfaceClient.playBlockBreakSound(this.hitPosition);
        return false;
    }
}

