/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHit;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PacketEntityBulletHitEntity
extends PacketEntityBulletHit {
    private final Point3d localCenter;
    private final double bulletVelocity;
    private final UUID hitEntityID;
    private final UUID controllerEntityID;

    public PacketEntityBulletHitEntity(EntityBullet bullet, BoundingBox box, AEntityE_Interactable<?> hitEntity) {
        super(bullet, box.globalCenter);
        this.localCenter = box.localCenter;
        this.bulletVelocity = bullet.velocity;
        this.hitEntityID = hitEntity.uniqueUUID;
        this.controllerEntityID = bullet.gun.lastController != null ? bullet.gun.lastController.getID() : null;
    }

    public PacketEntityBulletHitEntity(ByteBuf buf) {
        super(buf);
        this.localCenter = PacketEntityBulletHitEntity.readPoint3dFromBuffer(buf);
        this.bulletVelocity = buf.readDouble();
        this.hitEntityID = PacketEntityBulletHitEntity.readUUIDFromBuffer(buf);
        this.controllerEntityID = buf.readBoolean() ? PacketEntityBulletHitEntity.readUUIDFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityBulletHitEntity.writePoint3dToBuffer(this.localCenter, buf);
        buf.writeDouble(this.bulletVelocity);
        PacketEntityBulletHitEntity.writeUUIDToBuffer(this.hitEntityID, buf);
        buf.writeBoolean(this.controllerEntityID != null);
        if (this.controllerEntityID != null) {
            PacketEntityBulletHitEntity.writeUUIDToBuffer(this.controllerEntityID, buf);
        }
    }

    @Override
    public boolean handleBulletHit(WrapperWorld world) {
        AEntityE_Interactable entityHit;
        if (!world.isClient() && (entityHit = (AEntityE_Interactable)world.getEntity(this.hitEntityID)) != null) {
            BoundingBox hitBox = new BoundingBox(this.localCenter, this.hitPosition, ((JSONBullet)this.bulletItem.definition).bullet.diameter * 1000.0f, ((JSONBullet)this.bulletItem.definition).bullet.diameter * 1000.0f, ((JSONBullet)this.bulletItem.definition).bullet.diameter * 1000.0f, false);
            WrapperEntity attacker = this.controllerEntityID != null ? world.getExternalEntity(this.controllerEntityID) : null;
            double damageAmount = this.bulletVelocity * (double)((JSONBullet)this.bulletItem.definition).bullet.diameter / 5.0 * (Double)ConfigSystem.configObject.damage.bulletDamageFactor.value;
            Damage damage = new Damage("bullet", damageAmount, hitBox, null, attacker);
            damage.setBullet(this.bulletItem);
            entityHit.attack(damage);
        }
        return false;
    }
}

