/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.instances.PacketEntityBulletHit;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PacketEntityBulletHitWrapper
extends PacketEntityBulletHit {
    private final double bulletVelocity;
    private final UUID hitEntityID;
    private final UUID controllerEntityID;

    public PacketEntityBulletHitWrapper(EntityBullet bullet, WrapperEntity hitEntity) {
        super(bullet, hitEntity.getPosition());
        this.bulletVelocity = bullet.velocity;
        this.hitEntityID = hitEntity.getID();
        this.controllerEntityID = bullet.gun.lastController != null ? bullet.gun.lastController.getID() : null;
    }

    public PacketEntityBulletHitWrapper(ByteBuf buf) {
        super(buf);
        this.bulletVelocity = buf.readDouble();
        this.hitEntityID = PacketEntityBulletHitWrapper.readUUIDFromBuffer(buf);
        this.controllerEntityID = buf.readBoolean() ? PacketEntityBulletHitWrapper.readUUIDFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeDouble(this.bulletVelocity);
        PacketEntityBulletHitWrapper.writeUUIDToBuffer(this.hitEntityID, buf);
        buf.writeBoolean(this.controllerEntityID != null);
        if (this.controllerEntityID != null) {
            PacketEntityBulletHitWrapper.writeUUIDToBuffer(this.controllerEntityID, buf);
        }
    }

    @Override
    public boolean handleBulletHit(WrapperWorld world) {
        WrapperEntity entityHit;
        if (!world.isClient() && (entityHit = world.getExternalEntity(this.hitEntityID)) != null) {
            BoundingBox hitBox = new BoundingBox(this.hitPosition, ((JSONBullet)this.bulletItem.definition).bullet.diameter * 1000.0f, ((JSONBullet)this.bulletItem.definition).bullet.diameter * 1000.0f, ((JSONBullet)this.bulletItem.definition).bullet.diameter * 1000.0f);
            WrapperEntity attacker = this.controllerEntityID != null ? world.getExternalEntity(this.controllerEntityID) : null;
            double damageAmount = this.bulletVelocity * (double)((JSONBullet)this.bulletItem.definition).bullet.diameter / 5.0 * (Double)ConfigSystem.configObject.damage.bulletDamageFactor.value;
            Damage damage = new Damage("bullet", damageAmount, hitBox, null, attacker);
            damage.setBullet(this.bulletItem);
            entityHit.attack(damage);
        }
        return false;
    }
}

