/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketEntityInstrumentChange
extends APacketEntityInteract<AEntityE_Interactable<?>, WrapperPlayer> {
    private final int slot;
    private final String instrumentPackID;
    private final String instrumentSystemName;

    public PacketEntityInstrumentChange(AEntityE_Interactable<?> entity, WrapperPlayer player, int slot, ItemInstrument instrument) {
        super(entity, player);
        this.slot = slot;
        if (instrument != null) {
            this.instrumentPackID = ((JSONInstrument)instrument.definition).packID;
            this.instrumentSystemName = ((JSONInstrument)instrument.definition).systemName;
        } else {
            this.instrumentPackID = "";
            this.instrumentSystemName = "";
        }
    }

    public PacketEntityInstrumentChange(ByteBuf buf) {
        super(buf);
        this.slot = buf.readInt();
        this.instrumentPackID = PacketEntityInstrumentChange.readStringFromBuffer(buf);
        this.instrumentSystemName = PacketEntityInstrumentChange.readStringFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.slot);
        PacketEntityInstrumentChange.writeStringToBuffer(this.instrumentPackID, buf);
        PacketEntityInstrumentChange.writeStringToBuffer(this.instrumentSystemName, buf);
    }

    @Override
    public boolean handle(WrapperWorld world, AEntityE_Interactable<?> entity, WrapperPlayer player) {
        if (!(world.isClient() || player.isCreative() || !entity.instruments.containsKey(this.slot) || player.isCreative() || player.getInventory().addStack(entity.instruments.get(this.slot).getNewStack(null)))) {
            return false;
        }
        if (this.instrumentPackID.isEmpty()) {
            entity.instruments.remove(this.slot);
        } else {
            ItemInstrument instrument = (ItemInstrument)PackParserSystem.getItem(this.instrumentPackID, this.instrumentSystemName);
            if (!world.isClient() && !player.isCreative()) {
                int stackIndex = player.getInventory().getSlotForStack(instrument.getNewStack(null));
                if (stackIndex != -1) {
                    player.getInventory().removeFromSlot(stackIndex, 1);
                } else {
                    return false;
                }
            }
            entity.instruments.put(this.slot, instrument);
        }
        return true;
    }
}

