/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.mcinterface.WrapperEntity;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketEntityRiderChange
extends APacketEntityInteract<AEntityE_Interactable<?>, WrapperEntity> {
    private final Point3d position;

    public PacketEntityRiderChange(AEntityE_Interactable<?> entity, WrapperEntity rider, Point3d position) {
        super(entity, rider);
        this.position = position;
    }

    public PacketEntityRiderChange(ByteBuf buf) {
        super(buf);
        this.position = buf.readBoolean() ? PacketEntityRiderChange.readPoint3dFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeBoolean(this.position != null);
        if (this.position != null) {
            PacketEntityRiderChange.writePoint3dToBuffer(this.position, buf);
        }
    }

    @Override
    protected boolean handle(WrapperWorld world, AEntityE_Interactable<?> entity, WrapperEntity rider) {
        if (this.position != null) {
            entity.addRider(rider, this.position);
        } else {
            entity.removeRider(rider, null);
        }
        return true;
    }
}

