/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityTextChange
extends APacketEntity<AEntityD_Definable<?>> {
    private final List<String> textLines;

    public PacketEntityTextChange(AEntityD_Definable<?> entity, List<String> textLines) {
        super(entity);
        this.textLines = textLines;
    }

    public PacketEntityTextChange(ByteBuf buf) {
        super(buf);
        byte textLineCount = buf.readByte();
        this.textLines = new ArrayList<String>();
        for (byte i = 0; i < textLineCount; i = (byte)(i + 1)) {
            this.textLines.add(PacketEntityTextChange.readStringFromBuffer(buf));
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.textLines.size());
        for (String textLine : this.textLines) {
            PacketEntityTextChange.writeStringToBuffer(textLine, buf);
        }
    }

    @Override
    public boolean handle(WrapperWorld world, AEntityD_Definable<?> entity) {
        entity.updateText(this.textLines);
        return true;
    }
}

