/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.TrailerConnection;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPanelGround;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityTrailerChange
extends APacketEntity<AEntityE_Interactable<?>> {
    private final UUID hookupEntityID;
    private final int hitchGroupIndex;
    private final int hitchConnectionIndex;
    private final int hookupGroupIndex;
    private final int hookupConnectionIndex;
    private final boolean connect;

    public PacketEntityTrailerChange(TrailerConnection connection, boolean connect) {
        super(connection.hitchEntity);
        this.hookupEntityID = connection.hookupEntity.uniqueUUID;
        this.hitchGroupIndex = connection.hitchGroupIndex;
        this.hitchConnectionIndex = connection.hitchConnectionIndex;
        this.hookupGroupIndex = connection.hookupGroupIndex;
        this.hookupConnectionIndex = connection.hookupConnectionIndex;
        this.connect = connect;
    }

    public PacketEntityTrailerChange(ByteBuf buf) {
        super(buf);
        this.hookupEntityID = PacketEntityTrailerChange.readUUIDFromBuffer(buf);
        this.hitchGroupIndex = buf.readInt();
        this.hitchConnectionIndex = buf.readInt();
        this.hookupGroupIndex = buf.readInt();
        this.hookupConnectionIndex = buf.readInt();
        this.connect = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityTrailerChange.writeUUIDToBuffer(this.hookupEntityID, buf);
        buf.writeInt(this.hitchGroupIndex);
        buf.writeInt(this.hitchConnectionIndex);
        buf.writeInt(this.hookupGroupIndex);
        buf.writeInt(this.hookupConnectionIndex);
        buf.writeBoolean(this.connect);
    }

    @Override
    public boolean handle(WrapperWorld world, AEntityE_Interactable<?> hitchEntity) {
        AEntityE_Interactable hookupEntity = (AEntityE_Interactable)world.getEntity(this.hookupEntityID);
        TrailerConnection connection = new TrailerConnection(hitchEntity, this.hitchGroupIndex, this.hitchConnectionIndex, hookupEntity, this.hookupGroupIndex, this.hookupConnectionIndex);
        if (this.connect) {
            hitchEntity.connectTrailer(connection);
        } else {
            hitchEntity.disconnectTrailer(connection);
        }
        if (AGUIBase.activeInputGUI instanceof GUIPanelGround) {
            ((GUIPanelGround)AGUIBase.activeInputGUI).handleConnectionChange(hitchEntity, hookupEntity);
        }
        return true;
    }
}

