/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityVariableIncrement
extends APacketEntity<AEntityD_Definable<?>> {
    private final String variableName;
    private final double incrementValue;
    private final double minValue;
    private final double maxValue;

    public PacketEntityVariableIncrement(AEntityD_Definable<?> entity, String variableName, double incrementValue, double minValue, double maxValue) {
        super(entity);
        this.variableName = variableName;
        this.incrementValue = incrementValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public PacketEntityVariableIncrement(AEntityD_Definable<?> entity, String variableName, double incrementValue) {
        this(entity, variableName, incrementValue, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public PacketEntityVariableIncrement(ByteBuf buf) {
        super(buf);
        this.variableName = PacketEntityVariableIncrement.readStringFromBuffer(buf);
        this.incrementValue = buf.readDouble();
        this.minValue = buf.readDouble();
        this.maxValue = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityVariableIncrement.writeStringToBuffer(this.variableName, buf);
        buf.writeDouble(this.incrementValue);
        buf.writeDouble(this.minValue);
        buf.writeDouble(this.maxValue);
    }

    @Override
    public boolean handle(WrapperWorld world, AEntityD_Definable<?> entity) {
        double currentValue = entity.getVariable(this.variableName);
        double newValue = currentValue + this.incrementValue;
        if (newValue < this.minValue) {
            newValue = this.minValue;
        } else if (newValue > this.maxValue) {
            newValue = this.maxValue;
        }
        if (newValue != currentValue) {
            entity.setVariable(this.variableName, newValue);
            return true;
        }
        return false;
    }
}

