/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketFurnaceFuelAdd
extends APacketEntity<EntityFurnace> {
    private final int fuelAmount;

    public PacketFurnaceFuelAdd(EntityFurnace furnace) {
        super(furnace);
        this.fuelAmount = furnace.ticksLeftOfFuel;
    }

    public PacketFurnaceFuelAdd(ByteBuf buf) {
        super(buf);
        this.fuelAmount = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.fuelAmount);
    }

    @Override
    public boolean handle(WrapperWorld world, EntityFurnace furnace) {
        furnace.ticksAddedOfFuel = this.fuelAmount;
        furnace.ticksLeftOfFuel += furnace.ticksAddedOfFuel;
        if (furnace.definition.furnaceType.equals((Object)JSONPart.FurnaceComponentType.ELECTRIC)) {
            furnace.powerToDrawPerTick = 1.0 / (double)this.fuelAmount;
        }
        return true;
    }
}

