/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketInventoryContainerChange
extends APacketEntity<EntityInventoryContainer> {
    private final int index;
    private final WrapperItemStack stackToChangeTo;

    public PacketInventoryContainerChange(EntityInventoryContainer inventory, int index, WrapperItemStack stackToChangeTo) {
        super(inventory);
        this.index = index;
        this.stackToChangeTo = stackToChangeTo;
    }

    public PacketInventoryContainerChange(ByteBuf buf) {
        super(buf);
        this.index = buf.readInt();
        this.stackToChangeTo = PacketInventoryContainerChange.readDataFromBuffer(buf).getStacks(1).get(0);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.index);
        WrapperNBT stackData = new WrapperNBT();
        ArrayList<WrapperItemStack> stackList = new ArrayList<WrapperItemStack>();
        stackList.add(this.stackToChangeTo);
        stackData.setStacks(stackList);
        PacketInventoryContainerChange.writeDataToBuffer(stackData, buf);
    }

    @Override
    public boolean handle(WrapperWorld world, EntityInventoryContainer inventory) {
        inventory.setStack(this.stackToChangeTo, this.index);
        return true;
    }
}

