/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.guis.instances.GUIInventoryContainer;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketPlayer;

public class PacketItemInteractable
extends APacketPlayer {
    private final UUID uniqueUUID;
    private final WrapperNBT data;
    private final int units;
    private final String texture;

    public PacketItemInteractable(WrapperPlayer player, EntityInventoryContainer inventory, String texture) {
        super(player);
        this.uniqueUUID = inventory.uniqueUUID;
        this.data = inventory.save(new WrapperNBT());
        this.units = inventory.getSize();
        this.texture = texture;
    }

    private PacketItemInteractable(WrapperPlayer player, UUID uniqueUUID) {
        super(player);
        this.uniqueUUID = uniqueUUID;
        this.data = null;
        this.units = 0;
        this.texture = null;
    }

    public PacketItemInteractable(ByteBuf buf) {
        super(buf);
        this.uniqueUUID = PacketItemInteractable.readUUIDFromBuffer(buf);
        if (buf.readBoolean()) {
            this.data = PacketItemInteractable.readDataFromBuffer(buf);
            this.units = buf.readInt();
            this.texture = buf.readBoolean() ? PacketItemInteractable.readStringFromBuffer(buf) : null;
        } else {
            this.data = null;
            this.units = 0;
            this.texture = null;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketItemInteractable.writeUUIDToBuffer(this.uniqueUUID, buf);
        if (this.data == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            PacketItemInteractable.writeDataToBuffer(this.data, buf);
            buf.writeInt(this.units);
            if (this.texture != null) {
                buf.writeBoolean(true);
                PacketItemInteractable.writeStringToBuffer(this.texture, buf);
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public void handle(WrapperWorld world, WrapperPlayer player) {
        if (world.isClient()) {
            final EntityInventoryContainer inventory = new EntityInventoryContainer(world, this.data, this.units);
            new GUIInventoryContainer(inventory, this.texture, true){

                @Override
                public void close() {
                    super.close();
                    InterfacePacket.sendToServer(new PacketItemInteractable(this.player, PacketItemInteractable.this.uniqueUUID));
                    inventory.remove();
                }
            };
            world.addEntity(inventory);
        } else {
            ((AEntityA_Base)world.getEntity(this.uniqueUUID)).remove();
        }
    }
}

