/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketPartChange
extends APacketEntity<AEntityF_Multipart<?>> {
    private final Point3d partOffset;
    private final AItemPart partItem;
    private final WrapperNBT partData;
    private Point3d parentPartOffset;

    public PacketPartChange(AEntityF_Multipart<?> entity, Point3d partOffset) {
        super(entity);
        this.partOffset = partOffset;
        this.partItem = null;
        this.partData = null;
        this.parentPartOffset = null;
    }

    public PacketPartChange(AEntityF_Multipart<?> entity, APart partAdded) {
        super(entity);
        this.partOffset = partAdded.placementOffset;
        this.partItem = (AItemPart)partAdded.getItem();
        this.partData = new WrapperNBT();
        partAdded.save(this.partData);
        this.parentPartOffset = partAdded.parentPart != null ? partAdded.parentPart.placementOffset : null;
    }

    public PacketPartChange(ByteBuf buf) {
        super(buf);
        this.partOffset = PacketPartChange.readPoint3dFromBuffer(buf);
        if (buf.readBoolean()) {
            this.partItem = (AItemPart)PackParserSystem.getItem(PacketPartChange.readStringFromBuffer(buf), PacketPartChange.readStringFromBuffer(buf), PacketPartChange.readStringFromBuffer(buf));
            this.partData = PacketPartChange.readDataFromBuffer(buf);
            this.parentPartOffset = buf.readBoolean() ? PacketPartChange.readPoint3dFromBuffer(buf) : null;
        } else {
            this.partItem = null;
            this.partData = null;
            this.parentPartOffset = null;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPartChange.writePoint3dToBuffer(this.partOffset, buf);
        if (this.partItem != null) {
            buf.writeBoolean(true);
            PacketPartChange.writeStringToBuffer(((JSONPart)this.partItem.definition).packID, buf);
            PacketPartChange.writeStringToBuffer(((JSONPart)this.partItem.definition).systemName, buf);
            PacketPartChange.writeStringToBuffer(this.partItem.subName, buf);
            PacketPartChange.writeDataToBuffer(this.partData, buf);
            if (this.parentPartOffset != null) {
                buf.writeBoolean(true);
                PacketPartChange.writePoint3dToBuffer(this.parentPartOffset, buf);
            } else {
                buf.writeBoolean(false);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public boolean handle(WrapperWorld world, AEntityF_Multipart<?> entity) {
        if (this.partItem == null) {
            APart part = entity.getPartAtLocation(this.partOffset);
            if (part != null) {
                entity.removePart(part, null);
            }
        } else {
            JSONPartDefinition packVehicleDef = entity.getPackDefForLocation(this.partOffset);
            entity.addPart(this.partItem.createPart(entity, null, packVehicleDef, this.partData, entity.getPartAtLocation(this.parentPartOffset)), false);
        }
        return true;
    }
}

