/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartEngine
extends APacketEntity<PartEngine> {
    private final Signal packetType;
    private final double hours;
    private final boolean oilLeak;
    private final boolean fuelLeak;
    private final boolean brokenStarter;
    private final UUID linkedID;
    private final Point3d linkedPos;

    public PacketPartEngine(PartEngine engine, Signal packetType) {
        super(engine);
        this.packetType = packetType;
        this.hours = 0.0;
        this.oilLeak = false;
        this.fuelLeak = false;
        this.brokenStarter = false;
        this.linkedID = null;
        this.linkedPos = null;
    }

    public PacketPartEngine(PartEngine engine, double hours, boolean oilLeak, boolean fuelLeak, boolean brokenStarter) {
        super(engine);
        this.packetType = Signal.DAMAGE;
        this.hours = hours;
        this.oilLeak = oilLeak;
        this.fuelLeak = fuelLeak;
        this.brokenStarter = brokenStarter;
        this.linkedID = null;
        this.linkedPos = null;
    }

    public PacketPartEngine(PartEngine engine, PartEngine linkedEngine) {
        super(engine);
        this.packetType = Signal.LINK;
        this.hours = 0.0;
        this.oilLeak = false;
        this.fuelLeak = false;
        this.brokenStarter = false;
        this.linkedID = linkedEngine.entityOn.uniqueUUID;
        this.linkedPos = linkedEngine.placementOffset;
    }

    public PacketPartEngine(ByteBuf buf) {
        super(buf);
        this.packetType = Signal.values()[buf.readByte()];
        if (this.packetType.equals((Object)Signal.DAMAGE)) {
            this.hours = buf.readDouble();
            this.oilLeak = buf.readBoolean();
            this.fuelLeak = buf.readBoolean();
            this.brokenStarter = buf.readBoolean();
        } else {
            this.hours = 0.0;
            this.oilLeak = false;
            this.fuelLeak = false;
            this.brokenStarter = false;
        }
        if (this.packetType.equals((Object)Signal.LINK)) {
            this.linkedID = PacketPartEngine.readUUIDFromBuffer(buf);
            this.linkedPos = PacketPartEngine.readPoint3dFromBuffer(buf);
        } else {
            this.linkedID = null;
            this.linkedPos = null;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.packetType.ordinal());
        if (this.packetType.equals((Object)Signal.DAMAGE)) {
            buf.writeDouble(this.hours);
            buf.writeBoolean(this.oilLeak);
            buf.writeBoolean(this.fuelLeak);
            buf.writeBoolean(this.brokenStarter);
        } else if (this.packetType.equals((Object)Signal.LINK)) {
            PacketPartEngine.writeUUIDToBuffer(this.linkedID, buf);
            PacketPartEngine.writePoint3dToBuffer(this.linkedPos, buf);
        }
    }

    @Override
    public boolean handle(WrapperWorld world, PartEngine engine) {
        switch (this.packetType) {
            case HS_ON: {
                engine.handStartEngine();
                break;
            }
            case AS_ON: {
                engine.autoStartEngine();
                break;
            }
            case BACKFIRE: {
                engine.backfireEngine();
                break;
            }
            case BAD_SHIFT: {
                engine.badShiftEngine();
                break;
            }
            case START: {
                engine.startEngine();
                break;
            }
            case FUEL_OUT: {
                engine.stallEngine(this.packetType);
                break;
            }
            case TOO_SLOW: {
                engine.stallEngine(this.packetType);
                break;
            }
            case DEAD_VEHICLE: {
                engine.stallEngine(this.packetType);
                break;
            }
            case DROWN: {
                engine.stallEngine(this.packetType);
                break;
            }
            case DAMAGE: {
                engine.hours += this.hours;
                if (this.fuelLeak) {
                    engine.fuelLeak = true;
                }
                if (this.oilLeak) {
                    engine.oilLeak = true;
                }
                if (!this.brokenStarter) break;
                engine.brokenStarter = true;
                break;
            }
            case LINK: {
                AEntityF_Multipart otherEntity = (AEntityF_Multipart)world.getEntity(this.linkedID);
                if (otherEntity == null) break;
                for (APart part : otherEntity.parts) {
                    if (!part.placementOffset.equals(this.linkedPos)) continue;
                    ((PartEngine)part).linkedEngine = engine;
                    engine.linkedEngine = (PartEngine)part;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public static enum Signal {
        HS_ON,
        AS_ON,
        BACKFIRE,
        BAD_SHIFT,
        START,
        FUEL_OUT,
        DEAD_VEHICLE,
        TOO_SLOW,
        DROWN,
        DAMAGE,
        LINK;

    }
}

