/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketPartGun
extends APacketEntity<PartGun> {
    private final boolean controlPulse;
    private final boolean triggerState;
    private final boolean aimState;
    private final String bulletPackID;
    private final String bulletSystemName;
    private final String bulletSubName;

    public PacketPartGun(PartGun gun, boolean triggerState, boolean aimState) {
        super(gun);
        this.controlPulse = true;
        this.triggerState = triggerState;
        this.aimState = aimState;
        this.bulletPackID = null;
        this.bulletSystemName = null;
        this.bulletSubName = null;
    }

    public PacketPartGun(PartGun gun, ItemBullet bullet) {
        super(gun);
        this.controlPulse = false;
        this.triggerState = false;
        this.aimState = false;
        this.bulletPackID = ((JSONBullet)bullet.definition).packID;
        this.bulletSystemName = ((JSONBullet)bullet.definition).systemName;
        this.bulletSubName = bullet.subName;
    }

    public PacketPartGun(ByteBuf buf) {
        super(buf);
        this.controlPulse = buf.readBoolean();
        this.aimState = buf.readBoolean();
        if (this.controlPulse) {
            this.triggerState = buf.readBoolean();
            this.bulletPackID = null;
            this.bulletSystemName = null;
            this.bulletSubName = null;
        } else {
            this.triggerState = false;
            this.bulletPackID = PacketPartGun.readStringFromBuffer(buf);
            this.bulletSystemName = PacketPartGun.readStringFromBuffer(buf);
            this.bulletSubName = PacketPartGun.readStringFromBuffer(buf);
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeBoolean(this.controlPulse);
        buf.writeBoolean(this.aimState);
        if (this.controlPulse) {
            buf.writeBoolean(this.triggerState);
        } else {
            PacketPartGun.writeStringToBuffer(this.bulletPackID, buf);
            PacketPartGun.writeStringToBuffer(this.bulletSystemName, buf);
            PacketPartGun.writeStringToBuffer(this.bulletSubName, buf);
        }
    }

    @Override
    public boolean handle(WrapperWorld world, PartGun gun) {
        if (this.controlPulse) {
            gun.playerHoldingTrigger = this.triggerState;
            gun.isHandHeldGunAimed = this.aimState;
            return true;
        }
        return gun.tryToReload((ItemBullet)PackParserSystem.getItem(this.bulletPackID, this.bulletSystemName, this.bulletSubName));
    }
}

