/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.guis.instances.GUIFurnace;
import minecrafttransportsimulator.guis.instances.GUIInventoryContainer;
import minecrafttransportsimulator.guis.instances.GUIPartBench;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketPartInteractable
extends APacketEntityInteract<PartInteractable, WrapperPlayer> {
    private final UUID linkedID;
    private final Point3d linkedOffset;

    public PacketPartInteractable(PartInteractable interactable, WrapperPlayer player) {
        super(interactable, player);
        if (interactable.linkedVehicle != null) {
            this.linkedID = interactable.linkedVehicle.uniqueUUID;
            this.linkedOffset = null;
        } else if (interactable.linkedPart != null) {
            this.linkedID = interactable.linkedPart.entityOn.uniqueUUID;
            this.linkedOffset = interactable.linkedPart.placementOffset;
        } else {
            this.linkedID = null;
            this.linkedOffset = null;
        }
    }

    public PacketPartInteractable(ByteBuf buf) {
        super(buf);
        this.linkedID = buf.readBoolean() ? PacketPartInteractable.readUUIDFromBuffer(buf) : null;
        this.linkedOffset = buf.readBoolean() ? PacketPartInteractable.readPoint3dFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.linkedID != null) {
            buf.writeBoolean(true);
            PacketPartInteractable.writeUUIDToBuffer(this.linkedID, buf);
        } else {
            buf.writeBoolean(false);
        }
        if (this.linkedOffset != null) {
            buf.writeBoolean(true);
            PacketPartInteractable.writePoint3dToBuffer(this.linkedOffset, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public boolean handle(WrapperWorld world, PartInteractable interactable, WrapperPlayer player) {
        if (this.linkedID != null) {
            Object linkedEntity = world.getEntity(this.linkedID);
            if (linkedEntity != null) {
                if (this.linkedOffset == null) {
                    interactable.linkedVehicle = (EntityVehicleF_Physics)linkedEntity;
                } else {
                    interactable.linkedPart = (PartInteractable)((AEntityF_Multipart)linkedEntity).getPartAtLocation(this.linkedOffset);
                }
            }
        } else if (((JSONPart)interactable.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRAFTING_BENCH)) {
            new GUIPartBench(((JSONPart)interactable.definition).interactable.crafting);
        } else if (((JSONPart)interactable.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE)) {
            new GUIInventoryContainer(interactable.inventory, ((JSONPart)interactable.definition).interactable.inventoryTexture, false);
        } else if (((JSONPart)interactable.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.FURNACE)) {
            new GUIFurnace(interactable.furnace, ((JSONPart)interactable.definition).interactable.inventoryTexture);
        }
        return true;
    }
}

