/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.WrapperInventory;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketPlayer;
import minecrafttransportsimulator.systems.PackParserSystem;

public class PacketPlayerCraftItem
extends APacketPlayer {
    private final AItemPack<?> itemToCraft;
    private final boolean forRepair;

    public PacketPlayerCraftItem(WrapperPlayer player, AItemPack<?> itemToCraft, boolean forRepair) {
        super(player);
        this.itemToCraft = itemToCraft;
        this.forRepair = forRepair;
    }

    public PacketPlayerCraftItem(ByteBuf buf) {
        super(buf);
        this.itemToCraft = PackParserSystem.getItem(PacketPlayerCraftItem.readStringFromBuffer(buf), PacketPlayerCraftItem.readStringFromBuffer(buf));
        this.forRepair = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPlayerCraftItem.writeStringToBuffer(((AJSONItem)this.itemToCraft.definition).packID, buf);
        if (this.itemToCraft instanceof AItemSubTyped) {
            PacketPlayerCraftItem.writeStringToBuffer(((AJSONItem)this.itemToCraft.definition).systemName + ((AItemSubTyped)this.itemToCraft).subName, buf);
        } else {
            PacketPlayerCraftItem.writeStringToBuffer(((AJSONItem)this.itemToCraft.definition).systemName, buf);
        }
        buf.writeBoolean(this.forRepair);
    }

    @Override
    public void handle(WrapperWorld world, WrapperPlayer player) {
        WrapperInventory inventory = player.getInventory();
        if ((player.isCreative() || inventory.hasMaterials(this.itemToCraft, true, true, this.forRepair)) && inventory.addStack(this.itemToCraft.getNewStack(null)) && !player.isCreative()) {
            inventory.removeMaterials(this.itemToCraft, true, true, this.forRepair);
        }
    }
}

