/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;
import minecrafttransportsimulator.sound.RadioManager;

public class PacketRadioStateChange
extends APacketEntity<EntityRadio> {
    private final RadioManager.RadioSources source;
    private final int volume;
    private final int preset;
    private final boolean randomOrder;
    private final String currentURL;

    public PacketRadioStateChange(EntityRadio radio, RadioManager.RadioSources source) {
        super(radio);
        this.source = source;
        this.volume = radio.volume;
        this.preset = radio.preset;
        this.randomOrder = radio.randomOrder;
        this.currentURL = radio.currentURL;
    }

    public PacketRadioStateChange(EntityRadio radio, int volume) {
        super(radio);
        this.source = radio.getSource();
        this.volume = volume;
        this.preset = radio.preset;
        this.randomOrder = radio.randomOrder;
        this.currentURL = radio.currentURL;
    }

    public PacketRadioStateChange(EntityRadio radio, int preset, boolean randomOrder) {
        super(radio);
        this.source = radio.getSource();
        this.volume = radio.volume;
        this.preset = preset;
        this.randomOrder = randomOrder;
        this.currentURL = radio.currentURL;
    }

    public PacketRadioStateChange(EntityRadio radio, int preset, String currentURL) {
        super(radio);
        this.source = radio.getSource();
        this.volume = radio.volume;
        this.preset = preset;
        this.randomOrder = radio.randomOrder;
        this.currentURL = currentURL;
    }

    public PacketRadioStateChange(EntityRadio radio) {
        super(radio);
        this.source = radio.getSource();
        this.volume = radio.volume;
        this.preset = 0;
        this.randomOrder = radio.randomOrder;
        this.currentURL = radio.currentURL;
    }

    public PacketRadioStateChange(ByteBuf buf) {
        super(buf);
        this.source = RadioManager.RadioSources.values()[buf.readByte()];
        this.volume = buf.readByte();
        this.preset = buf.readByte();
        this.randomOrder = buf.readBoolean();
        this.currentURL = PacketRadioStateChange.readStringFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.source.ordinal());
        buf.writeByte(this.volume);
        buf.writeByte(this.preset);
        buf.writeBoolean(this.randomOrder);
        PacketRadioStateChange.writeStringToBuffer(this.currentURL, buf);
    }

    @Override
    public boolean handle(WrapperWorld world, EntityRadio radio) {
        if (radio != null) {
            if (world.isClient()) {
                if (!radio.getSource().equals((Object)this.source)) {
                    radio.changeSource(this.source);
                } else if (radio.volume != this.volume) {
                    radio.changeVolume(this.volume);
                } else if (this.preset == 0) {
                    radio.stop();
                } else if (radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET)) {
                    radio.startInternetPlayback(this.currentURL, this.preset);
                } else if (radio.getSource().equals((Object)RadioManager.RadioSources.LOCAL)) {
                    radio.startLocalPlayback(this.preset, this.randomOrder);
                }
            } else {
                radio.setProperties(this.source, this.volume, this.preset, this.randomOrder, this.currentURL);
            }
            return true;
        }
        return false;
    }
}

