/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFuelPump;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityFuelPumpConnection
extends APacketEntity<TileEntityFuelPump> {
    private final UUID linkedID;
    private final boolean connect;

    public PacketTileEntityFuelPumpConnection(TileEntityFuelPump pump, boolean connect) {
        super(pump);
        this.linkedID = pump.connectedVehicle.uniqueUUID;
        this.connect = connect;
    }

    public PacketTileEntityFuelPumpConnection(ByteBuf buf) {
        super(buf);
        this.linkedID = PacketTileEntityFuelPumpConnection.readUUIDFromBuffer(buf);
        this.connect = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketTileEntityFuelPumpConnection.writeUUIDToBuffer(this.linkedID, buf);
        buf.writeBoolean(this.connect);
    }

    @Override
    protected boolean handle(WrapperWorld world, TileEntityFuelPump pump) {
        EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)world.getEntity(this.linkedID);
        if (vehicle != null) {
            if (this.connect) {
                pump.connectedVehicle = vehicle;
                vehicle.beingFueled = true;
                pump.getTank().resetAmountDispensed();
            } else {
                vehicle.beingFueled = false;
                pump.connectedVehicle = null;
            }
        }
        return true;
    }
}

