/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFuelPump;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIFuelPump;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketTileEntityFuelPumpDispense
extends APacketEntityInteract<TileEntityFuelPump, WrapperPlayer> {
    private final int slotClicked;
    private final int amountChangedTo;

    public PacketTileEntityFuelPumpDispense(TileEntityFuelPump pump, WrapperPlayer player, int slotClicked, int amountChangedTo) {
        super(pump, player);
        this.slotClicked = slotClicked;
        this.amountChangedTo = amountChangedTo;
    }

    public PacketTileEntityFuelPumpDispense(TileEntityFuelPump pump, WrapperPlayer player, int slotClicked) {
        super(pump, player);
        this.slotClicked = slotClicked;
        this.amountChangedTo = -1;
    }

    public PacketTileEntityFuelPumpDispense(ByteBuf buf) {
        super(buf);
        this.slotClicked = buf.readInt();
        this.amountChangedTo = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.slotClicked);
        buf.writeInt(this.amountChangedTo);
    }

    @Override
    protected boolean handle(WrapperWorld world, TileEntityFuelPump pump, WrapperPlayer player) {
        if (this.amountChangedTo != -1) {
            pump.fuelAmounts.set(this.slotClicked, this.amountChangedTo);
            return true;
        }
        WrapperItemStack stack = pump.fuelItems.getStack(this.slotClicked);
        if (player.getInventory().removeStack(stack, stack.getSize())) {
            pump.fuelPurchasedRemaining += pump.fuelAmounts.get(this.slotClicked).intValue();
            if (world.isClient() && player.equals(InterfaceClient.getClientPlayer()) && AGUIBase.activeInputGUI instanceof GUIFuelPump) {
                AGUIBase.activeInputGUI.close();
            }
            return true;
        }
        return false;
    }
}

