/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityLoader;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityLoaderConnection
extends APacketEntity<ATileEntityLoader> {
    private final UUID linkedID;
    private final Point3d partOffset;
    private final boolean connect;

    public PacketTileEntityLoaderConnection(ATileEntityLoader loader, boolean connect) {
        super(loader);
        if (loader.connectedPart != null) {
            this.linkedID = loader.connectedPart.entityOn.uniqueUUID;
            this.partOffset = loader.connectedPart.placementOffset;
        } else {
            this.linkedID = null;
            this.partOffset = null;
        }
        this.connect = connect;
    }

    public PacketTileEntityLoaderConnection(ByteBuf buf) {
        super(buf);
        if (buf.readBoolean()) {
            this.linkedID = PacketTileEntityLoaderConnection.readUUIDFromBuffer(buf);
            this.partOffset = PacketTileEntityLoaderConnection.readPoint3dFromBuffer(buf);
        } else {
            this.linkedID = null;
            this.partOffset = null;
        }
        this.connect = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.linkedID != null) {
            buf.writeBoolean(true);
            PacketTileEntityLoaderConnection.writeUUIDToBuffer(this.linkedID, buf);
            PacketTileEntityLoaderConnection.writePoint3dToBuffer(this.partOffset, buf);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.connect);
    }

    @Override
    protected boolean handle(WrapperWorld world, ATileEntityLoader loader) {
        AEntityF_Multipart entity = (AEntityF_Multipart)world.getEntity(this.linkedID);
        if (this.connect) {
            if (entity != null) {
                loader.connectToPart((PartInteractable)entity.getPartAtLocation(this.partOffset));
            }
        } else {
            loader.connectToPart(null);
        }
        return true;
    }
}

