/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityRoadCollisionUpdate
extends APacketEntity<TileEntityRoad> {
    private final List<Point3d> collisionBlockOffsets;
    private final List<Point3d> collidingBlockOffsets;

    public PacketTileEntityRoadCollisionUpdate(TileEntityRoad road) {
        super(road);
        this.collisionBlockOffsets = road.collisionBlockOffsets;
        this.collidingBlockOffsets = road.collidingBlockOffsets;
    }

    public PacketTileEntityRoadCollisionUpdate(ByteBuf buf) {
        super(buf);
        this.collisionBlockOffsets = new ArrayList<Point3d>();
        int collisionBlockOffsetCount = buf.readInt();
        for (int i = 0; i < collisionBlockOffsetCount; ++i) {
            this.collisionBlockOffsets.add(PacketTileEntityRoadCollisionUpdate.readPoint3dCompactFromBuffer(buf));
        }
        this.collidingBlockOffsets = new ArrayList<Point3d>();
        int collidingBlockOffsetCount = buf.readInt();
        for (int i = 0; i < collidingBlockOffsetCount; ++i) {
            this.collidingBlockOffsets.add(PacketTileEntityRoadCollisionUpdate.readPoint3dCompactFromBuffer(buf));
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.collisionBlockOffsets.size());
        for (Point3d point : this.collisionBlockOffsets) {
            PacketTileEntityRoadCollisionUpdate.writePoint3dCompactToBuffer(point, buf);
        }
        buf.writeInt(this.collidingBlockOffsets.size());
        for (Point3d point : this.collidingBlockOffsets) {
            PacketTileEntityRoadCollisionUpdate.writePoint3dCompactToBuffer(point, buf);
        }
    }

    @Override
    protected boolean handle(WrapperWorld world, TileEntityRoad road) {
        road.collisionBlockOffsets.clear();
        road.collisionBlockOffsets.addAll(this.collisionBlockOffsets);
        road.collidingBlockOffsets.clear();
        road.collidingBlockOffsets.addAll(this.collidingBlockOffsets);
        road.blockingRenderables.clear();
        if (!road.isActive() && road.collidingBlockOffsets.isEmpty()) {
            road.setActive(true);
        }
        return false;
    }
}

