/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketTileEntityRoadConnectionUpdate
extends APacketEntity<TileEntityRoad> {
    private final int laneNumber;
    private final int curveNumber;
    private final boolean connectedToStart;
    private final Point3d otherPosition;
    private final int otherLaneNumber;
    private final int otherCurveNumber;
    private final float otherCurveNetAngle;
    private final boolean otherConnectedToStart;

    public PacketTileEntityRoadConnectionUpdate(RoadLane lane, int curveNumber, boolean connectedToStart, RoadLaneConnection otherConnection) {
        super(lane.road);
        this.laneNumber = lane.laneNumber;
        this.curveNumber = curveNumber;
        this.connectedToStart = connectedToStart;
        if (otherConnection != null) {
            this.otherPosition = otherConnection.tileLocation;
            this.otherLaneNumber = otherConnection.laneNumber;
            this.otherCurveNumber = otherConnection.curveNumber;
            this.otherCurveNetAngle = otherConnection.curveNetAngle;
            this.otherConnectedToStart = otherConnection.connectedToStart;
        } else {
            this.otherPosition = null;
            this.otherLaneNumber = 0;
            this.otherCurveNumber = 0;
            this.otherCurveNetAngle = 0.0f;
            this.otherConnectedToStart = false;
        }
    }

    public PacketTileEntityRoadConnectionUpdate(RoadLane lane, int curveNumber, boolean priorConnection) {
        this(lane, curveNumber, priorConnection, null);
    }

    public PacketTileEntityRoadConnectionUpdate(ByteBuf buf) {
        super(buf);
        this.laneNumber = buf.readInt();
        this.curveNumber = buf.readInt();
        this.connectedToStart = buf.readBoolean();
        if (buf.readBoolean()) {
            this.otherPosition = PacketTileEntityRoadConnectionUpdate.readPoint3dFromBuffer(buf);
            this.otherLaneNumber = buf.readInt();
            this.otherCurveNumber = buf.readInt();
            this.otherCurveNetAngle = buf.readFloat();
            this.otherConnectedToStart = buf.readBoolean();
        } else {
            this.otherPosition = null;
            this.otherLaneNumber = 0;
            this.otherCurveNumber = 0;
            this.otherCurveNetAngle = 0.0f;
            this.otherConnectedToStart = false;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.laneNumber);
        buf.writeInt(this.curveNumber);
        buf.writeBoolean(this.connectedToStart);
        if (this.otherPosition != null) {
            buf.writeBoolean(true);
            PacketTileEntityRoadConnectionUpdate.writePoint3dToBuffer(this.otherPosition, buf);
            buf.writeInt(this.otherLaneNumber);
            buf.writeInt(this.otherCurveNumber);
            buf.writeFloat(this.otherCurveNetAngle);
            buf.writeBoolean(this.otherConnectedToStart);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    protected boolean handle(WrapperWorld world, TileEntityRoad road) {
        RoadLane lane = road.lanes.get(this.laneNumber);
        if (this.otherPosition != null) {
            if (this.connectedToStart) {
                lane.priorConnections.get(this.curveNumber).add(new RoadLaneConnection(this.otherPosition, this.otherLaneNumber, this.otherCurveNumber, this.otherCurveNetAngle, this.otherConnectedToStart));
            } else {
                lane.nextConnections.get(this.curveNumber).add(new RoadLaneConnection(this.otherPosition, this.otherLaneNumber, this.otherCurveNumber, this.otherCurveNetAngle, this.otherConnectedToStart));
            }
        } else if (this.connectedToStart) {
            lane.priorConnections.get(this.curveNumber).clear();
        } else {
            lane.nextConnections.get(this.curveNumber).clear();
        }
        return true;
    }
}

