/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemVehicleInteractable;
import minecrafttransportsimulator.mcinterface.InterfacePacket;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;

public class PacketVehicleInteract
extends APacketEntityInteract<EntityVehicleF_Physics, WrapperPlayer> {
    private final UUID hitPartUniqueUUID;
    private final Point3d hitBoxLocalCenter;
    private final boolean rightClick;

    public PacketVehicleInteract(EntityVehicleF_Physics vehicle, WrapperPlayer player, BoundingBox hitBox, boolean rightClick) {
        super(vehicle, player);
        APart hitPart = vehicle.getPartWithBox(hitBox);
        this.hitPartUniqueUUID = hitPart != null ? hitPart.uniqueUUID : null;
        this.hitBoxLocalCenter = hitBox.localCenter;
        this.rightClick = rightClick;
    }

    public PacketVehicleInteract(ByteBuf buf) {
        super(buf);
        this.hitPartUniqueUUID = buf.readBoolean() ? PacketVehicleInteract.readUUIDFromBuffer(buf) : null;
        this.hitBoxLocalCenter = PacketVehicleInteract.readPoint3dFromBuffer(buf);
        this.rightClick = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        if (this.hitPartUniqueUUID != null) {
            buf.writeBoolean(true);
            PacketVehicleInteract.writeUUIDToBuffer(this.hitPartUniqueUUID, buf);
        } else {
            buf.writeBoolean(false);
        }
        PacketVehicleInteract.writePoint3dToBuffer(this.hitBoxLocalCenter, buf);
        buf.writeBoolean(this.rightClick);
    }

    @Override
    public boolean handle(WrapperWorld world, EntityVehicleF_Physics vehicle, WrapperPlayer player) {
        AEntityE_Interactable.PlayerOwnerState ownerState = vehicle.getOwnerState(player);
        WrapperItemStack heldStack = player.getHeldStack();
        AItemBase heldItem = heldStack.getItem();
        APart part = this.hitPartUniqueUUID != null ? (APart)world.getEntity(this.hitPartUniqueUUID) : null;
        BoundingBox hitBox = null;
        if (part == null) {
            for (BoundingBox box : vehicle.allPartSlotBoxes.keySet()) {
                if (!box.localCenter.equals(this.hitBoxLocalCenter)) continue;
                hitBox = box;
                break;
            }
        }
        if (hitBox == null) {
            for (BoundingBox box : part != null ? part.interactionBoxes : vehicle.interactionBoxes) {
                if (!box.localCenter.equals(this.hitBoxLocalCenter)) continue;
                hitBox = box;
                break;
            }
            if (hitBox == null) {
                return false;
            }
        }
        if (vehicle.allPartSlotBoxes.containsKey(hitBox)) {
            if (ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehicleowned"));
            } else if (heldItem instanceof AItemPart && vehicle.addPartFromItem((AItemPart)heldItem, player, heldStack.getData(), this.hitBoxLocalCenter, false) != null && !player.isCreative()) {
                player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
            }
            return false;
        }
        boolean hadAllCondition = false;
        if (heldItem instanceof IItemVehicleInteractable) {
            switch (((IItemVehicleInteractable)((Object)heldItem)).doVehicleInteraction(vehicle, part, hitBox, player, ownerState, this.rightClick)) {
                case ALL: {
                    return true;
                }
                case ALL_AND_MORE: {
                    hadAllCondition = true;
                    break;
                }
                case PLAYER: {
                    player.sendPacket(this);
                    return false;
                }
                case NONE: {
                    return false;
                }
            }
        }
        if (hitBox.definition != null && hitBox.definition.variableName != null) {
            if (vehicle.locked && !hadAllCondition) {
                player.sendPacket(new PacketPlayerChatMessage(player, "interact.failure.vehiclelocked"));
            } else {
                AEntityE_Interactable entity = part != null ? part : vehicle;
                switch (hitBox.definition.variableType) {
                    case INCREMENT: {
                        entity.setVariable(hitBox.definition.variableName, entity.getVariable(hitBox.definition.variableName) + (double)hitBox.definition.variableValue);
                        InterfacePacket.sendToAllClients(new PacketEntityVariableIncrement(entity, hitBox.definition.variableName, hitBox.definition.variableValue));
                        break;
                    }
                    case SET: {
                        entity.setVariable(hitBox.definition.variableName, hitBox.definition.variableValue);
                        InterfacePacket.sendToAllClients(new PacketEntityVariableSet(entity, hitBox.definition.variableName, hitBox.definition.variableValue));
                        break;
                    }
                    case TOGGLE: {
                        entity.toggleVariable(hitBox.definition.variableName);
                        InterfacePacket.sendToAllClients(new PacketEntityVariableToggle(entity, hitBox.definition.variableName));
                    }
                }
            }
            return false;
        }
        if (part != null) {
            if (this.rightClick) {
                part.interact(player);
            } else {
                part.attack(new Damage("player", 1.0, part.boundingBox, null, player));
            }
        }
        return hadAllCondition;
    }
}

