/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketVehicleServerMovement
extends APacketEntity<EntityVehicleF_Physics> {
    private final Point3d motion;
    private final Point3d rotation;
    private final double pathing;

    public PacketVehicleServerMovement(EntityVehicleF_Physics vehicle, Point3d motion, Point3d rotation, double pathing) {
        super(vehicle);
        this.motion = motion;
        this.rotation = rotation;
        this.pathing = pathing;
    }

    public PacketVehicleServerMovement(ByteBuf buf) {
        super(buf);
        this.motion = PacketVehicleServerMovement.readPoint3dFromBuffer(buf);
        this.rotation = PacketVehicleServerMovement.readPoint3dFromBuffer(buf);
        this.pathing = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketVehicleServerMovement.writePoint3dToBuffer(this.motion, buf);
        PacketVehicleServerMovement.writePoint3dToBuffer(this.rotation, buf);
        buf.writeDouble(this.pathing);
    }

    @Override
    public boolean handle(WrapperWorld world, EntityVehicleF_Physics vehicle) {
        vehicle.addToServerDeltas(this.motion, this.rotation, this.pathing);
        return false;
    }
}

