/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.mcinterface.WrapperNBT;
import minecrafttransportsimulator.mcinterface.WrapperPlayer;
import minecrafttransportsimulator.mcinterface.WrapperWorld;
import minecrafttransportsimulator.packets.components.APacketPlayer;

public class PacketWorldSavedDataCSHandshake
extends APacketPlayer {
    private final String name;
    private final WrapperNBT data;

    public PacketWorldSavedDataCSHandshake(WrapperPlayer player, String name, WrapperNBT data) {
        super(player);
        this.name = name;
        this.data = data;
    }

    public PacketWorldSavedDataCSHandshake(ByteBuf buf) {
        super(buf);
        this.name = PacketWorldSavedDataCSHandshake.readStringFromBuffer(buf);
        this.data = buf.readBoolean() ? PacketWorldSavedDataCSHandshake.readDataFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketWorldSavedDataCSHandshake.writeStringToBuffer(this.name, buf);
        if (this.data != null) {
            buf.writeBoolean(true);
            PacketWorldSavedDataCSHandshake.writeDataToBuffer(this.data, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(WrapperWorld world, WrapperPlayer player) {
        if (world.isClient()) {
            world.setData(this.name, this.data);
        } else {
            WrapperNBT savedData = world.getData(this.name);
            if (this.name.isEmpty()) {
                for (String dataName : savedData.getAllNames()) {
                    player.sendPacket(new PacketWorldSavedDataCSHandshake(player, dataName, savedData.getData(dataName)));
                }
            } else {
                player.sendPacket(new PacketWorldSavedDataCSHandshake(player, this.name, savedData));
            }
        }
    }

    @Override
    public boolean runOnMainThread() {
        return false;
    }
}

