/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONConfig;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.rendering.components.ARenderEntityDefinable;
import minecrafttransportsimulator.rendering.instances.ModelParserLT;
import minecrafttransportsimulator.systems.ConfigSystem;

public class JSONParser {
    private static final TypeAdapter<Boolean> booleanAdapter = new TypeAdapter<Boolean>(){

        public Boolean read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return reader.nextBoolean();
        }

        public void write(JsonWriter writer, Boolean value) throws IOException {
            if (!value.booleanValue()) {
                writer.nullValue();
            } else {
                writer.value(value);
            }
        }
    };
    private static final TypeAdapter<Integer> integerAdapter = new TypeAdapter<Integer>(){

        public Integer read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return reader.nextInt();
        }

        public void write(JsonWriter writer, Integer value) throws IOException {
            if (value == 0) {
                writer.nullValue();
            } else {
                writer.value((Number)value);
            }
        }
    };
    private static final TypeAdapter<Float> floatAdapter = new TypeAdapter<Float>(){

        public Float read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return Float.valueOf((float)reader.nextDouble());
        }

        public void write(JsonWriter writer, Float value) throws IOException {
            if (value.floatValue() == 0.0f) {
                writer.nullValue();
            } else {
                writer.value((Number)value);
            }
        }
    };
    private static final TypeAdapter<Point3d> point3dAdapter = new TypeAdapter<Point3d>(){

        public Point3d read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            reader.beginArray();
            Point3d value = new Point3d(reader.nextDouble(), reader.nextDouble(), reader.nextDouble());
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, Point3d value) throws IOException {
            if (value == null) {
                writer.nullValue();
                return;
            }
            writer.beginArray();
            writer.setIndent("");
            writer.value(value.x);
            writer.value(value.y);
            writer.value(value.z);
            writer.endArray();
            writer.setIndent("  ");
        }
    };
    private static final TypeAdapter<ColorRGB> colorAdapter = new TypeAdapter<ColorRGB>(){

        public ColorRGB read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                ArrayList<Integer> hsv = new ArrayList<Integer>();
                reader.beginArray();
                while (reader.hasNext()) {
                    hsv.add(reader.nextInt());
                }
                reader.endArray();
                float hue = ((Integer)hsv.get(0)).intValue();
                float sat = ((Integer)hsv.get(1)).intValue();
                float val = ((Integer)hsv.get(2)).intValue();
                return new ColorRGB(hue, sat, val, true);
            }
            return new ColorRGB(reader.nextString());
        }

        public void write(JsonWriter writer, ColorRGB value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else if (ConfigSystem.configObject != null && ((Boolean)ConfigSystem.configObject.general.useHSV.value).booleanValue()) {
                writer.beginArray();
                writer.setIndent("");
                int[] nArray = value.hsv;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer item = nArray[i];
                    writer.value((Number)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            } else {
                String hexString = Integer.toHexString(value.rgbInt).toUpperCase();
                while (hexString.length() < 6) {
                    hexString = "0" + hexString;
                }
                writer.value(hexString);
            }
        }
    };
    private static final TypeAdapter<ModelParserLT.LTBox> ltBoxAdapter = new TypeAdapter<ModelParserLT.LTBox>(){

        public ModelParserLT.LTBox read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            reader.beginArray();
            ModelParserLT.LTBox value = new ModelParserLT.LTBox();
            reader.nextString();
            value.pos1 = new int[]{reader.nextInt(), reader.nextInt(), reader.nextInt()};
            value.pos2 = new int[]{reader.nextInt(), reader.nextInt(), reader.nextInt()};
            while (reader.hasNext()) {
                reader.nextInt();
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, ModelParserLT.LTBox value) throws IOException {
            writer.nullValue();
        }
    };
    private static final TypeAdapter<List<Integer>> intListAdapter = new TypeAdapter<List<Integer>>(){

        public List<Integer> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            ArrayList<Integer> value = new ArrayList<Integer>();
            reader.beginArray();
            while (reader.hasNext()) {
                value.add(reader.nextInt());
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, List<Integer> value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                for (Integer item : value) {
                    writer.value((Number)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapter<List<Float>> floatListAdapter = new TypeAdapter<List<Float>>(){

        public List<Float> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            ArrayList<Float> value = new ArrayList<Float>();
            reader.beginArray();
            while (reader.hasNext()) {
                value.add(Float.valueOf((float)reader.nextDouble()));
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, List<Float> value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                for (Float item : value) {
                    writer.value((Number)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapter<List<String>> stringListAdapter = new TypeAdapter<List<String>>(){

        public List<String> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            ArrayList<String> value = new ArrayList<String>();
            reader.beginArray();
            while (reader.hasNext()) {
                value.add(reader.nextString());
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, List<String> value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                for (String item : value) {
                    writer.value(item);
                }
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapter<List<ColorRGB>> colorListAdapter = new TypeAdapter<List<ColorRGB>>(){

        public List<ColorRGB> read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            ArrayList<ColorRGB> value = new ArrayList<ColorRGB>();
            reader.beginArray();
            while (reader.hasNext()) {
                value.add((ColorRGB)colorAdapter.read(reader));
            }
            reader.endArray();
            return value;
        }

        public void write(JsonWriter writer, List<ColorRGB> value) throws IOException {
            if (value == null) {
                writer.nullValue();
            } else {
                writer.beginArray();
                writer.setIndent("");
                for (ColorRGB item : value) {
                    colorAdapter.write(writer, (Object)item);
                }
                writer.endArray();
                writer.setIndent("  ");
            }
        }
    };
    private static final TypeAdapterFactory lowercaseEnumFactory = new TypeAdapterFactory(){

        public <EnumType> TypeAdapter<EnumType> create(Gson gson, TypeToken<EnumType> type) {
            Class rawType = type.getRawType();
            if (!rawType.isEnum()) {
                return null;
            }
            final HashMap lowercaseToEnum = new HashMap();
            for (Object enumConstant : rawType.getEnumConstants()) {
                lowercaseToEnum.put(enumConstant.toString().toLowerCase(), enumConstant);
            }
            return new TypeAdapter<EnumType>(){

                public void write(JsonWriter writer, EnumType value) throws IOException {
                    if (value == null) {
                        writer.nullValue();
                    } else {
                        writer.value(value.toString().toLowerCase());
                    }
                }

                public EnumType read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    return lowercaseToEnum.get(reader.nextString());
                }
            };
        }
    };
    private static final Gson packParser = JSONParser.getPackParserWithAdapters();
    private static final Gson configParser = JSONParser.getConfigParserWithAdapters();

    private static Gson getPackParserWithAdapters() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().registerTypeAdapter(Boolean.class, booleanAdapter).registerTypeAdapter(Integer.class, integerAdapter).registerTypeAdapter(Float.class, floatAdapter).registerTypeAdapter(Point3d.class, point3dAdapter).registerTypeAdapter(ColorRGB.class, colorAdapter).registerTypeAdapter(ModelParserLT.LTBox.class, ltBoxAdapter).registerTypeAdapter(new TypeToken<List<Integer>>(){}.getType(), intListAdapter).registerTypeAdapter(new TypeToken<List<Float>>(){}.getType(), floatListAdapter).registerTypeAdapter(new TypeToken<List<String>>(){}.getType(), stringListAdapter).registerTypeAdapter(new TypeToken<List<ColorRGB>>(){}.getType(), colorListAdapter).registerTypeAdapterFactory(lowercaseEnumFactory).create();
    }

    private static Gson getConfigParserWithAdapters() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(new TypeToken<List<Integer>>(){}.getType(), intListAdapter).registerTypeAdapter(new TypeToken<List<Float>>(){}.getType(), floatListAdapter).registerTypeAdapter(new TypeToken<List<String>>(){}.getType(), stringListAdapter).create();
    }

    public static <JSONClass> JSONClass parseStream(InputStreamReader jsonReader, Class<JSONClass> retClass, String packID, String systemName) {
        if (retClass.equals(JSONConfig.class)) {
            return (JSONClass)configParser.fromJson((Reader)jsonReader, retClass);
        }
        return (JSONClass)packParser.fromJson((Reader)jsonReader, retClass);
    }

    public static void exportStream(Object jsonObject, OutputStreamWriter jsonWriter) {
        if (jsonObject.getClass().equals(JSONConfig.class)) {
            configParser.toJson(jsonObject, jsonObject.getClass(), (Appendable)jsonWriter);
        } else {
            packParser.toJson(jsonObject, jsonObject.getClass(), (Appendable)jsonWriter);
        }
    }

    public static <JSONClass> JSONClass duplicateJSON(JSONClass objToDuplicate) {
        return (JSONClass)packParser.fromJson(packParser.toJson(objToDuplicate), objToDuplicate.getClass());
    }

    public static String hotloadJSON(File jsonFile, AJSONItem definitionToOverride) {
        try {
            AJSONItem loadedDefinition;
            switch (definitionToOverride.classification) {
                case VEHICLE: {
                    JSONVehicle vehicleDefinition = (JSONVehicle)definitionToOverride;
                    JSONVehicle jSONVehicle = JSONParser.parseStream(new FileReader(jsonFile), JSONVehicle.class, vehicleDefinition.packID, vehicleDefinition.systemName);
                    JSONParser.validateFields(jSONVehicle, "/", 1);
                    vehicleDefinition.motorized = jSONVehicle.motorized;
                    loadedDefinition = jSONVehicle;
                    break;
                }
                case PART: {
                    JSONPart partDefinition = (JSONPart)definitionToOverride;
                    JSONPart jSONPart = JSONParser.parseStream(new FileReader(jsonFile), JSONPart.class, partDefinition.packID, partDefinition.systemName);
                    JSONParser.validateFields(jSONPart, "/", 1);
                    partDefinition.generic = jSONPart.generic;
                    partDefinition.engine = jSONPart.engine;
                    partDefinition.ground = jSONPart.ground;
                    partDefinition.propeller = jSONPart.propeller;
                    partDefinition.seat = jSONPart.seat;
                    partDefinition.gun = jSONPart.gun;
                    partDefinition.interactable = jSONPart.interactable;
                    partDefinition.effector = jSONPart.effector;
                    loadedDefinition = jSONPart;
                    break;
                }
                case INSTRUMENT: {
                    JSONInstrument instrumentDefinition = (JSONInstrument)definitionToOverride;
                    JSONInstrument jSONInstrument = JSONParser.parseStream(new FileReader(jsonFile), JSONInstrument.class, instrumentDefinition.packID, instrumentDefinition.systemName);
                    JSONParser.validateFields(jSONInstrument, "/", 1);
                    instrumentDefinition.components = jSONInstrument.components;
                    loadedDefinition = jSONInstrument;
                    break;
                }
                case DECOR: {
                    JSONDecor decorDefinition = (JSONDecor)definitionToOverride;
                    JSONDecor jSONDecor = JSONParser.parseStream(new FileReader(jsonFile), JSONDecor.class, decorDefinition.packID, decorDefinition.systemName);
                    JSONParser.validateFields(jSONDecor, "/", 1);
                    decorDefinition.decor = jSONDecor.decor;
                    loadedDefinition = jSONDecor;
                    break;
                }
                case ROAD: {
                    JSONRoadComponent roadDefinition = (JSONRoadComponent)definitionToOverride;
                    JSONRoadComponent jSONRoadComponent = JSONParser.parseStream(new FileReader(jsonFile), JSONRoadComponent.class, roadDefinition.packID, roadDefinition.systemName);
                    JSONParser.validateFields(jSONRoadComponent, "/", 1);
                    roadDefinition.road = jSONRoadComponent.road;
                    loadedDefinition = jSONRoadComponent;
                    break;
                }
                case POLE: {
                    JSONPoleComponent poleDefinition = (JSONPoleComponent)definitionToOverride;
                    JSONPoleComponent jSONPoleComponent = JSONParser.parseStream(new FileReader(jsonFile), JSONPoleComponent.class, poleDefinition.packID, poleDefinition.systemName);
                    JSONParser.validateFields(jSONPoleComponent, "/", 1);
                    loadedDefinition = jSONPoleComponent;
                    break;
                }
                case BULLET: {
                    JSONBullet bulletDefinition = (JSONBullet)definitionToOverride;
                    JSONBullet jSONBullet = JSONParser.parseStream(new FileReader(jsonFile), JSONBullet.class, bulletDefinition.packID, bulletDefinition.systemName);
                    JSONParser.validateFields(jSONBullet, "/", 1);
                    bulletDefinition.bullet = jSONBullet.bullet;
                    loadedDefinition = jSONBullet;
                    break;
                }
                case ITEM: {
                    JSONItem itemDefinition = (JSONItem)definitionToOverride;
                    JSONItem jSONItem = JSONParser.parseStream(new FileReader(jsonFile), JSONItem.class, itemDefinition.packID, itemDefinition.systemName);
                    JSONParser.validateFields(jSONItem, "/", 1);
                    itemDefinition.item = jSONItem.item;
                    itemDefinition.booklet = jSONItem.booklet;
                    itemDefinition.food = jSONItem.food;
                    itemDefinition.weapon = jSONItem.weapon;
                    loadedDefinition = jSONItem;
                    break;
                }
                default: {
                    return "\nERROR: Attempted to hotload unsuppoorted JSON type:" + (Object)((Object)definitionToOverride.classification);
                }
            }
            definitionToOverride.general = loadedDefinition.general;
            if (definitionToOverride instanceof AJSONMultiModelProvider) {
                ((AJSONMultiModelProvider)definitionToOverride).definitions = ((AJSONMultiModelProvider)loadedDefinition).definitions;
                ((AJSONMultiModelProvider)definitionToOverride).rendering = ((AJSONMultiModelProvider)loadedDefinition).rendering;
                if (definitionToOverride instanceof AJSONInteractableEntity) {
                    ((AJSONInteractableEntity)definitionToOverride).collisionGroups = ((AJSONInteractableEntity)loadedDefinition).collisionGroups;
                    ((AJSONInteractableEntity)definitionToOverride).connectionGroups = ((AJSONInteractableEntity)loadedDefinition).connectionGroups;
                    ((AJSONInteractableEntity)definitionToOverride).instruments = ((AJSONInteractableEntity)loadedDefinition).instruments;
                    ((AJSONInteractableEntity)definitionToOverride).variableModifiers = ((AJSONInteractableEntity)loadedDefinition).variableModifiers;
                    ((AJSONInteractableEntity)definitionToOverride).effects = ((AJSONInteractableEntity)loadedDefinition).effects;
                    if (definitionToOverride instanceof AJSONPartProvider) {
                        ((AJSONPartProvider)definitionToOverride).parts = ((AJSONPartProvider)loadedDefinition).parts;
                    }
                }
            }
            if (definitionToOverride instanceof AJSONMultiModelProvider) {
                ARenderEntityDefinable.clearObjectCaches((AJSONMultiModelProvider)definitionToOverride);
            }
            for (AEntityA_Base aEntityA_Base : InterfaceClient.getClientWorld().renderableEntities) {
                if (!(aEntityA_Base instanceof AEntityD_Definable)) continue;
                AEntityD_Definable definableEntity = (AEntityD_Definable)aEntityA_Base;
                if (!definitionToOverride.packID.equals(((AJSONMultiModelProvider)definableEntity.definition).packID) || !definitionToOverride.systemName.equals(((AJSONMultiModelProvider)definableEntity.definition).systemName)) continue;
                ((AEntityD_Definable)aEntityA_Base).animationsInitialized = false;
            }
            return "\nImported file: " + definitionToOverride.packID + ":" + definitionToOverride.systemName;
        }
        catch (Exception e) {
            return "\nCould not import: " + definitionToOverride.packID + ":" + definitionToOverride.systemName + "\nERROR: " + e.getMessage();
        }
    }

    public static void validateFields(Object obj, String priorObjects, int index) {
        for (Field field : obj.getClass().getFields()) {
            String errorValue = JSONParser.checkRequiredState(field, obj, priorObjects, index);
            if (errorValue != null) {
                throw new NullPointerException(errorValue);
            }
            if (!obj.getClass().getPackage().getName().contains("jsondefs")) continue;
            Object recursiveObject = null;
            try {
                recursiveObject = field.get(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (recursiveObject == null) continue;
            if (recursiveObject instanceof Collection) {
                int collectionIndex = 1;
                for (Object objEntry : (Collection)recursiveObject) {
                    if (objEntry != null) {
                        JSONParser.validateFields(objEntry, priorObjects + field.getName() + "/", collectionIndex);
                        ++collectionIndex;
                        continue;
                    }
                    throw new NullPointerException("Unable to parse entry #" + collectionIndex + " in variable set " + priorObjects + field.getName() + " due to it not existing.  Check your commas!");
                }
                continue;
            }
            if (recursiveObject.getClass().isEnum()) continue;
            JSONParser.validateFields(recursiveObject, priorObjects + field.getName() + "/", 1);
        }
    }

    private static String checkRequiredState(Field field, Object objectOn, String pathPrefix, int index) {
        if (field.isAnnotationPresent(JSONRequired.class)) {
            Object testObj = null;
            try {
                testObj = field.get(objectOn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (testObj == null) {
                JSONRequired annotation = field.getAnnotation(JSONRequired.class);
                String dependentVarName = annotation.dependentField();
                if (!dependentVarName.isEmpty()) {
                    Object depObj = null;
                    try {
                        if (annotation.subField().isEmpty()) {
                            depObj = objectOn.getClass().getField(dependentVarName).get(objectOn);
                        } else {
                            depObj = objectOn.getClass().getField(annotation.subField()).get(objectOn);
                            depObj = depObj.getClass().getField(dependentVarName).get(depObj);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (depObj != null) {
                        if (annotation.dependentValues().length == 0) {
                            return pathPrefix + field.getName() + ", entry #" + index + ", is required when '" + dependentVarName + "' is present!";
                        }
                        for (String possibleValue : annotation.dependentValues()) {
                            if (!depObj.toString().startsWith(possibleValue)) continue;
                            return pathPrefix + field.getName() + ", entry #" + index + ", is required when value of '" + dependentVarName + "' is '" + depObj.toString() + "'!";
                        }
                    }
                } else {
                    return pathPrefix + field.getName() + ", entry #" + index + ", is missing from the JSON and is required!";
                }
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface JSONDefaults {
        public Class<? extends Enum<?>> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface JSONDescription {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface JSONRequired {
        public String dependentField() default "";

        public String[] dependentValues() default {};

        public String subField() default "";
    }
}

