/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import minecrafttransportsimulator.MasterLoader;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONConnection;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONDoor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONMuzzle;
import minecrafttransportsimulator.jsondefs.JSONMuzzleGroup;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONParticle;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONRendering;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONSkin;
import minecrafttransportsimulator.jsondefs.JSONSound;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.rendering.components.AModelParser;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class LegacyCompatSystem {
    public static void performLegacyCompats(AJSONItem definition) {
        AJSONMultiModelProvider provider;
        if (definition instanceof JSONVehicle) {
            LegacyCompatSystem.performVehicleLegacyCompats((JSONVehicle)definition);
        } else if (definition instanceof JSONPart) {
            LegacyCompatSystem.performPartLegacyCompats((JSONPart)definition);
        } else if (definition instanceof JSONInstrument) {
            LegacyCompatSystem.performInstrumentLegacyCompats((JSONInstrument)definition);
        } else if (definition instanceof JSONPoleComponent) {
            LegacyCompatSystem.performPoleLegacyCompats((JSONPoleComponent)definition);
        } else if (definition instanceof JSONDecor) {
            LegacyCompatSystem.performDecorLegacyCompats((JSONDecor)definition);
        } else if (definition instanceof JSONRoadComponent) {
            LegacyCompatSystem.performRoadLegacyCompats((JSONRoadComponent)definition);
        } else if (definition instanceof JSONItem) {
            LegacyCompatSystem.performItemLegacyCompats((JSONItem)definition);
        } else if (definition instanceof JSONSkin) {
            LegacyCompatSystem.performSkinLegacyCompats((JSONSkin)definition);
        } else if (definition instanceof JSONBullet) {
            LegacyCompatSystem.performBulletLegacyCompats((JSONBullet)definition);
        }
        if (definition.general.modelName != null) {
            provider = (AJSONMultiModelProvider)definition;
            for (JSONSubDefinition subDef : provider.definitions) {
                subDef.modelName = definition.general.modelName;
            }
            definition.general.modelName = null;
        }
        if (definition instanceof AJSONMultiModelProvider) {
            provider = (AJSONMultiModelProvider)definition;
            if (provider.rendering == null) {
                provider.rendering = new JSONRendering();
            }
            if (provider.rendering.modelType == null) {
                provider.rendering.modelType = JSONRendering.ModelType.OBJ;
            }
            if (ConfigSystem.configObject != null && ((Boolean)ConfigSystem.configObject.general.doLegacyLightCompats.value).booleanValue() && !(definition instanceof JSONSkin) && provider.rendering.modelType.equals((Object)JSONRendering.ModelType.OBJ)) {
                LegacyCompatSystem.performModelLegacyCompats((AJSONMultiModelProvider)definition);
            }
        }
    }

    private static void performVehicleLegacyCompats(JSONVehicle definition) {
        if (definition.general.emptyMass > 0) {
            definition.motorized.isAircraft = definition.general.isAircraft;
            definition.general.isAircraft = false;
            definition.motorized.isBlimp = definition.general.isBlimp;
            definition.general.isBlimp = false;
            definition.motorized.hasOpenTop = definition.general.openTop;
            definition.general.openTop = false;
            definition.motorized.emptyMass = definition.general.emptyMass;
            definition.general.emptyMass = 0;
        }
        if (definition.car != null) {
            definition.motorized.isBigTruck = definition.car.isBigTruck;
            definition.motorized.isFrontWheelDrive = definition.car.isFrontWheelDrive;
            definition.motorized.isRearWheelDrive = definition.car.isRearWheelDrive;
            definition.motorized.hasCruiseControl = definition.car.hasCruiseControl;
            definition.motorized.axleRatio = definition.car.axleRatio;
            definition.motorized.dragCoefficient = definition.car.dragCoefficient;
            definition.car = null;
        }
        if (definition.general.type != null) {
            if (definition.general.type.equals("plane") || definition.general.type.equals("blimp") || definition.general.type.equals("helicopter")) {
                definition.motorized.isAircraft = true;
            }
            if (definition.general.type.equals("blimp")) {
                definition.motorized.isBlimp = true;
            }
            definition.general.type = null;
        }
        if (definition.general.health == 0) {
            definition.general.health = 100;
        }
        if (definition.plane != null) {
            definition.general.isAircraft = true;
            definition.motorized.hasFlaps = definition.plane.hasFlaps;
            definition.motorized.hasAutopilot = definition.plane.hasAutopilot;
            definition.motorized.wingSpan = definition.plane.wingSpan;
            definition.motorized.wingArea = definition.plane.wingArea;
            definition.motorized.tailDistance = definition.plane.tailDistance;
            definition.motorized.aileronArea = definition.plane.aileronArea;
            definition.motorized.elevatorArea = definition.plane.elevatorArea;
            definition.motorized.rudderArea = definition.plane.rudderArea;
            definition.plane = null;
            if (definition.motorized.aileronArea == 0.0f) {
                definition.motorized.aileronArea = definition.motorized.wingArea / 5.0f;
            }
        }
        if (definition.blimp != null) {
            definition.general.isAircraft = true;
            definition.general.isBlimp = true;
            definition.motorized.isBlimp = true;
            definition.motorized.crossSectionalArea = definition.blimp.crossSectionalArea;
            definition.motorized.tailDistance = definition.blimp.tailDistance;
            definition.motorized.rudderArea = definition.blimp.rudderArea;
            definition.motorized.ballastVolume = definition.blimp.ballastVolume;
            definition.blimp = null;
        }
        if (definition.motorized.hitchPos != null) {
            definition.connections = new ArrayList();
            for (String hitchName : definition.motorized.hitchTypes) {
                JSONConnection connection = new JSONConnection();
                connection.hookup = false;
                connection.type = hitchName;
                connection.pos = definition.motorized.hitchPos;
                if (connection.mounted) {
                    connection.rot = new Point3d();
                }
                definition.connections.add(connection);
            }
            definition.motorized.hitchPos = null;
            definition.motorized.hitchTypes = null;
        }
        if (definition.motorized.hookupPos != null) {
            if (definition.connections == null) {
                definition.connections = new ArrayList();
            }
            JSONConnection connection = new JSONConnection();
            connection.hookup = true;
            connection.type = definition.motorized.hookupType;
            connection.pos = definition.motorized.hookupPos;
            definition.connections.add(connection);
            definition.motorized.hookupType = null;
            definition.motorized.hookupPos = null;
        }
        if (definition.motorized.instruments != null) {
            definition.instruments = definition.motorized.instruments;
            definition.motorized.instruments = null;
            for (JSONInstrumentDefinition def : definition.instruments) {
                if (def.optionalPartNumber == 0) continue;
                def.placeOnPanel = true;
            }
        }
        if (definition.motorized.hasFlaps) {
            definition.motorized.flapSpeed = 0.1f;
            definition.motorized.flapNotches = new ArrayList<Float>();
            for (int i = 0; i <= 7; ++i) {
                definition.motorized.flapNotches.add(Float.valueOf(i * 5));
            }
            definition.motorized.hasFlaps = false;
        }
        if (definition.motorized.dragCoefficient == 0.0f) {
            float f = definition.motorized.dragCoefficient = definition.motorized.isAircraft || definition.motorized.isBlimp ? 0.03f : 2.0f;
        }
        if (definition.motorized.brakingFactor == 0.0f) {
            definition.motorized.brakingFactor = 1.0f;
        }
        if (definition.motorized.hasCruiseControl) {
            definition.motorized.hasAutopilot = true;
            definition.motorized.hasCruiseControl = false;
        }
        if (definition.motorized.downForce > 1.0f) {
            definition.motorized.downForce = 0.5f;
        }
        if (definition.motorized.isTrailer && definition.motorized.hookupVariables == null) {
            definition.motorized.hookupVariables = new ArrayList<String>();
            definition.motorized.hookupVariables.add("electric_power");
            definition.motorized.hookupVariables.add("engine_gear_1");
            definition.motorized.hookupVariables.add("engines_on");
            definition.motorized.hookupVariables.add("right_turn_signal");
            definition.motorized.hookupVariables.add("left_turn_signal");
            definition.motorized.hookupVariables.add("runninglight");
            definition.motorized.hookupVariables.add("headlight");
            definition.motorized.hookupVariables.add("emergencylight");
        }
        for (JSONPartDefinition partDef : definition.parts) {
            try {
                LegacyCompatSystem.performVehiclePartDefLegacyCompats(partDef);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NullPointerException("Could not perform Legacy Compats on part entry #" + (definition.parts.indexOf(partDef) + 1) + " due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
            }
        }
        LegacyCompatSystem.performVehicleConnectionLegacyCompats(definition);
        LegacyCompatSystem.performVehicleCollisionLegacyCompats(definition);
        if (definition.rendering != null) {
            if (definition.rendering.hudTexture != null) {
                definition.motorized.hudTexture = definition.rendering.hudTexture;
                definition.rendering.hudTexture = null;
            }
            if (definition.rendering.panelTexture != null) {
                definition.motorized.panelTexture = definition.rendering.panelTexture;
                definition.rendering.panelTexture = null;
            }
            if (definition.rendering.panelTextColor != null) {
                definition.motorized.panelTextColor = definition.rendering.panelTextColor;
                definition.rendering.panelTextColor = null;
            }
            if (definition.rendering.panelLitTextColor != null) {
                definition.motorized.panelLitTextColor = definition.rendering.panelLitTextColor;
                definition.rendering.panelLitTextColor = null;
            }
            if (definition.rendering.sounds == null) {
                definition.rendering.sounds = new ArrayList<JSONSound>();
                if (definition.motorized.hornSound != null) {
                    JSONSound hornSound = new JSONSound();
                    hornSound.name = definition.motorized.hornSound;
                    hornSound.looping = true;
                    hornSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition hornDef = new JSONAnimationDefinition();
                    hornDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    hornDef.variable = "horn";
                    hornDef.clampMin = 1.0f;
                    hornDef.clampMax = 1.0f;
                    hornSound.activeAnimations.add(hornDef);
                    definition.rendering.sounds.add(hornSound);
                    definition.motorized.hornSound = null;
                }
                if (definition.motorized.sirenSound != null) {
                    JSONSound sirenSound = new JSONSound();
                    sirenSound.name = definition.motorized.sirenSound;
                    sirenSound.looping = true;
                    sirenSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition sirenDef = new JSONAnimationDefinition();
                    sirenDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    sirenDef.variable = "siren";
                    sirenDef.clampMin = 1.0f;
                    sirenDef.clampMax = 1.0f;
                    sirenSound.activeAnimations.add(sirenDef);
                    definition.rendering.sounds.add(sirenSound);
                    if (definition.rendering.customVariables == null) {
                        definition.rendering.customVariables = new ArrayList<String>();
                    }
                    definition.rendering.customVariables.add("siren");
                    definition.motorized.sirenSound = null;
                }
                if (definition.motorized.isBigTruck) {
                    JSONSound airbrakeSound = new JSONSound();
                    airbrakeSound.name = MasterLoader.resourceDomain + ":air_brake_activating";
                    airbrakeSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition airbrakeDef = new JSONAnimationDefinition();
                    airbrakeDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    airbrakeDef.variable = "p_brake";
                    airbrakeDef.clampMin = 1.0f;
                    airbrakeDef.clampMax = 1.0f;
                    airbrakeSound.activeAnimations.add(airbrakeDef);
                    definition.rendering.sounds.add(airbrakeSound);
                    JSONSound backupBeeperSound = new JSONSound();
                    backupBeeperSound.name = MasterLoader.resourceDomain + ":backup_beeper";
                    backupBeeperSound.looping = true;
                    backupBeeperSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition backupBeeperDef = new JSONAnimationDefinition();
                    backupBeeperDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    backupBeeperDef.variable = "engine_gear_1";
                    backupBeeperDef.clampMin = -10.0f;
                    backupBeeperDef.clampMax = -1.0f;
                    backupBeeperSound.activeAnimations.add(backupBeeperDef);
                    definition.rendering.sounds.add(backupBeeperSound);
                    definition.motorized.isBigTruck = false;
                }
            }
            if (definition.rendering.particles == null) {
                definition.rendering.particles = new ArrayList<JSONParticle>();
                int engineNumber = 0;
                for (JSONPartDefinition partDef : definition.parts) {
                    if (partDef.particleObjects == null) continue;
                    ++engineNumber;
                    int pistonNumber = 0;
                    for (JSONParticle exhaustDef : partDef.particleObjects) {
                        ++pistonNumber;
                        exhaustDef.type = JSONParticle.ParticleType.SMOKE;
                        exhaustDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                        exhaustDef.initialVelocity = exhaustDef.velocityVector;
                        exhaustDef.velocityVector = null;
                        JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                        activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        activeAnimation.variable = "engine_piston_" + pistonNumber + "_" + partDef.particleObjects.size() + "_cam_" + engineNumber;
                        activeAnimation.clampMin = 1.0f;
                        activeAnimation.clampMax = 1.0f;
                        exhaustDef.activeAnimations.add(activeAnimation);
                        definition.rendering.particles.add(exhaustDef);
                        JSONParticle backfireDef = new JSONParticle();
                        backfireDef.type = exhaustDef.type;
                        backfireDef.color = ColorRGB.BLACK;
                        backfireDef.scale = 2.5f;
                        backfireDef.quantity = 5;
                        backfireDef.pos = exhaustDef.pos;
                        backfireDef.initialVelocity = exhaustDef.initialVelocity;
                        backfireDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                        activeAnimation = new JSONAnimationDefinition();
                        activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        activeAnimation.variable = "engine_backfired_" + engineNumber;
                        activeAnimation.clampMin = 1.0f;
                        activeAnimation.clampMax = 1.0f;
                        backfireDef.activeAnimations.add(activeAnimation);
                        definition.rendering.particles.add(backfireDef);
                    }
                    partDef.particleObjects = null;
                }
            }
            try {
                LegacyCompatSystem.performAnimationLegacyCompats(definition.rendering);
            }
            catch (Exception e) {
                throw new NullPointerException("Could not perform Legacy Compats on rendering section due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
            }
        }
    }

    private static void performPartLegacyCompats(JSONPart definition) {
        if (definition.general.type != null) {
            if (definition.generic == null) {
                definition.generic = definition.new JSONPart.JSONPartGeneric();
            }
            definition.generic.type = definition.general.type;
            definition.general.type = null;
            definition.generic.customType = definition.general.customType;
            definition.general.customType = null;
            definition.generic.disableMirroring = definition.general.disableMirroring;
            definition.general.disableMirroring = false;
            definition.generic.useVehicleTexture = definition.general.useVehicleTexture;
            definition.general.useVehicleTexture = false;
        }
        if (definition.definitions == null) {
            definition.definitions = new ArrayList();
            Object subDefinition = new JSONSubDefinition();
            ((JSONSubDefinition)subDefinition).extraMaterials = new ArrayList<String>();
            ((JSONSubDefinition)subDefinition).name = definition.general.name;
            ((JSONSubDefinition)subDefinition).subName = "";
            definition.definitions.add(subDefinition);
        }
        if (definition.subParts != null) {
            definition.parts = definition.subParts;
            definition.subParts = null;
        }
        switch (definition.generic.type) {
            case "wheel": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = definition.new JSONPart.JSONPartGroundDevice();
                definition.ground.isWheel = true;
                definition.ground.width = definition.wheel.diameter / 2.0f;
                definition.ground.height = definition.wheel.diameter;
                definition.ground.lateralFriction = definition.wheel.lateralFriction;
                definition.ground.motiveFriction = definition.wheel.motiveFriction;
                definition.wheel = null;
                break;
            }
            case "skid": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = definition.new JSONPart.JSONPartGroundDevice();
                definition.ground.width = definition.skid.width;
                definition.ground.height = definition.skid.width;
                definition.ground.lateralFriction = definition.skid.lateralFriction;
                definition.skid = null;
                break;
            }
            case "pontoon": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = definition.new JSONPart.JSONPartGroundDevice();
                definition.ground.canFloat = true;
                definition.ground.width = definition.pontoon.width;
                definition.ground.height = definition.pontoon.width;
                definition.ground.lateralFriction = definition.pontoon.lateralFriction;
                definition.ground.extraCollisionBoxOffset = definition.pontoon.extraCollisionBoxOffset;
                definition.pontoon = null;
                break;
            }
            case "tread": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = definition.new JSONPart.JSONPartGroundDevice();
                definition.ground.isTread = true;
                definition.ground.width = definition.tread.width;
                definition.ground.height = definition.tread.width;
                definition.ground.lateralFriction = definition.tread.lateralFriction;
                definition.ground.motiveFriction = definition.tread.motiveFriction;
                definition.ground.extraCollisionBoxOffset = definition.tread.extraCollisionBoxOffset;
                definition.ground.spacing = definition.tread.spacing;
                definition.tread = null;
                break;
            }
            case "crate": {
                definition.generic.type = "interactable_crate";
                definition.interactable = definition.new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.CRATE;
                definition.interactable.inventoryUnits = 1.0f;
                definition.interactable.feedsVehicles = true;
                break;
            }
            case "barrel": {
                definition.generic.type = "interactable_barrel";
                definition.interactable = definition.new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.BARREL;
                definition.interactable.inventoryUnits = 1.0f;
                break;
            }
            case "crafting_table": {
                definition.generic.type = "interactable_crafting_table";
                definition.interactable = definition.new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.CRAFTING_TABLE;
                break;
            }
            case "furnace": {
                definition.generic.type = "interactable_furnace";
                definition.interactable = definition.new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.FURNACE;
                break;
            }
            case "brewing_stand": {
                definition.generic.type = "interactable_brewing_stand";
                definition.interactable = definition.new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.BREWING_STAND;
                break;
            }
            case "fertilizer": {
                definition.generic.type = "effector_fertilizer";
                definition.effector = definition.new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.FERTILIZER;
                break;
            }
            case "harvester": {
                definition.generic.type = "effector_harvester";
                definition.effector = definition.new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.HARVESTER;
                break;
            }
            case "planter": {
                definition.generic.type = "effector_planter";
                definition.effector = definition.new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.PLANTER;
                break;
            }
            case "plow": {
                definition.generic.type = "effector_plow";
                definition.effector = definition.new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.PLOW;
                break;
            }
            case "custom": {
                definition.generic.type = "generic";
                definition.generic.height = definition.custom.height;
                definition.generic.width = definition.custom.width;
                definition.custom = null;
            }
        }
        if (definition.general.health == 0) {
            definition.general.health = 100;
        }
        if (definition.engine != null) {
            if (definition.engine.fuelType == null) {
                definition.engine.fuelType = "diesel";
            }
            if (definition.generic.type.equals("engine_jet") && definition.engine.jetPowerFactor == 0.0f) {
                definition.engine.jetPowerFactor = 1.0f;
                definition.engine.bypassRatio = definition.engine.gearRatios.get(0).floatValue();
                definition.engine.gearRatios.set(0, Float.valueOf(1.0f));
            }
            if (definition.engine.gearRatios.size() == 1) {
                definition.engine.propellerRatio = 1.0f / definition.engine.gearRatios.get(0).floatValue();
                definition.engine.gearRatios.clear();
                definition.engine.gearRatios.add(Float.valueOf(-1.0f));
                definition.engine.gearRatios.add(Float.valueOf(0.0f));
                definition.engine.gearRatios.add(Float.valueOf(1.0f));
            }
            if (definition.engine.shiftSpeed == 0) {
                definition.engine.shiftSpeed = 20;
            } else if (definition.engine.shiftSpeed == -1) {
                definition.engine.shiftSpeed = 0;
            }
            if (definition.engine.revResistance == 0) {
                definition.engine.revResistance = 10;
            }
            if (definition.engine.idleRPM == 0) {
                definition.engine.idleRPM = definition.engine.maxRPM < 15000 ? 500 : 2000;
            } else if (definition.engine.idleRPM == -1) {
                definition.engine.idleRPM = 0;
            }
            if (definition.engine.maxSafeRPM == 0) {
                int n = definition.engine.maxSafeRPM = definition.engine.maxRPM < 15000 ? definition.engine.maxRPM - (definition.engine.maxRPM - 2500) / 2 : (int)((double)definition.engine.maxRPM / 1.1);
            }
            if (definition.engine.revlimitRPM == 0) {
                definition.engine.revlimitRPM = definition.engine.jetPowerFactor != 0.0f || definition.engine.gearRatios.size() == 3 ? -1 : (int)((double)definition.engine.maxSafeRPM * 0.95);
            }
            if (definition.engine.revlimitBounce == 0) {
                definition.engine.revlimitBounce = definition.engine.revResistance;
            }
            if (definition.engine.startRPM == 0) {
                definition.engine.startRPM = (int)((double)definition.engine.idleRPM * 1.2);
            } else if (definition.engine.startRPM == -1) {
                definition.engine.startRPM = 0;
            }
            if (definition.engine.stallRPM == 0) {
                definition.engine.stallRPM = (int)((double)definition.engine.idleRPM * 0.65);
            } else if (definition.engine.stallRPM == -1) {
                definition.engine.stallRPM = 0;
            }
            if (definition.engine.engineWinddownRate == 0) {
                definition.engine.engineWinddownRate = 10;
            }
            if (definition.engine.engineWearFactor == 0.0f) {
                definition.engine.engineWearFactor = 1.0f;
            }
            if (definition.engine.coolingCoefficient == 0.0f) {
                definition.engine.coolingCoefficient = 1.0f;
            }
            if (definition.engine.heatingCoefficient == 0.0f) {
                definition.engine.heatingCoefficient = 1.0f;
            }
            if (definition.engine.upShiftRPM != null) {
                while (definition.engine.upShiftRPM.size() < definition.engine.gearRatios.size()) {
                    definition.engine.upShiftRPM.add(0, 0);
                }
            }
            if (definition.engine.downShiftRPM != null) {
                while (definition.engine.downShiftRPM.size() < definition.engine.gearRatios.size()) {
                    definition.engine.downShiftRPM.add(0, 0);
                }
            }
        }
        if (definition.ground != null) {
            if (definition.ground.canGoFlat && definition.ground.flatHeight == 0.0f) {
                definition.ground.flatHeight = definition.ground.height / 2.0f;
                definition.ground.canGoFlat = false;
            }
            if (definition.ground.frictionModifiers == null) {
                definition.ground.frictionModifiers = new LinkedHashMap();
                definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.SNOW, Float.valueOf(-0.2f));
                definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.ICE, Float.valueOf(-0.2f));
                if (!definition.ground.isTread) {
                    definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.DIRT_WET, Float.valueOf(-0.1f));
                    definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.SAND_WET, Float.valueOf(-0.1f));
                    definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.NORMAL_WET, Float.valueOf(-0.1f));
                }
            }
        }
        if (definition.generic.type.startsWith("seat") && definition.seat == null) {
            definition.seat = definition.new JSONPart.JSONPartSeat();
        }
        if (definition.gun != null) {
            if (definition.gun.yawSpeed == 0.0f) {
                definition.gun.yawSpeed = 50.0f / definition.gun.diameter + 1.0f / definition.gun.length;
            }
            if (definition.gun.pitchSpeed == 0.0f) {
                definition.gun.pitchSpeed = 50.0f / definition.gun.diameter + 1.0f / definition.gun.length;
            }
            if (definition.gun.muzzleGroups == null) {
                definition.gun.muzzleGroups = new ArrayList<JSONMuzzleGroup>();
                JSONMuzzleGroup muzzleGroup = new JSONMuzzleGroup();
                muzzleGroup.muzzles = new ArrayList<JSONMuzzle>();
                JSONMuzzle muzzle = new JSONMuzzle();
                muzzle.pos = new Point3d(0.0, 0.0, definition.gun.length);
                muzzle.rot = new Point3d();
                muzzle.center = new Point3d();
                muzzleGroup.muzzles.add(muzzle);
                definition.gun.muzzleGroups.add(muzzleGroup);
            }
            definition.gun.length = 0.0f;
        }
        if (definition.interactable != null && definition.interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.FURNACE) && definition.interactable.furnaceType == null) {
            definition.interactable.furnaceType = JSONPart.FurnaceComponentType.STANDARD;
            definition.interactable.furnaceRate = 1.0f;
            definition.interactable.furnaceEfficiency = 1.0f;
        }
        if (definition.parts != null) {
            for (JSONPartDefinition subPartDef : definition.parts) {
                try {
                    LegacyCompatSystem.performVehiclePartDefLegacyCompats(subPartDef);
                }
                catch (Exception e) {
                    throw new NullPointerException("Could not perform Legacy Compats on sub-part entry #" + (definition.parts.indexOf(subPartDef) + 1) + " due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
                }
            }
        }
        if (definition.rendering != null) {
            try {
                LegacyCompatSystem.performAnimationLegacyCompats(definition.rendering);
            }
            catch (Exception e) {
                throw new NullPointerException("Could not perform Legacy Compats on rendering section due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
            }
        }
        LegacyCompatSystem.performVehicleConnectionLegacyCompats(definition);
        LegacyCompatSystem.performVehicleCollisionLegacyCompats(definition);
        if (definition.rendering == null || definition.rendering.sounds == null) {
            if (definition.engine != null) {
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.sounds == null) {
                    definition.rendering.sounds = new ArrayList<JSONSound>();
                }
                JSONSound startingSound = new JSONSound();
                startingSound.name = definition.packID + ":" + definition.systemName + "_starting";
                startingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition startingActiveDef = new JSONAnimationDefinition();
                startingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                startingActiveDef.variable = "engine_running";
                startingActiveDef.clampMin = 1.0f;
                startingActiveDef.clampMax = 1.0f;
                startingSound.activeAnimations.add(startingActiveDef);
                definition.rendering.sounds.add(startingSound);
                JSONSound stoppingSound = new JSONSound();
                stoppingSound.name = definition.packID + ":" + definition.systemName + "_stopping";
                stoppingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition stoppingActiveDef = new JSONAnimationDefinition();
                stoppingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                stoppingActiveDef.variable = "engine_running";
                stoppingActiveDef.clampMin = 0.0f;
                stoppingActiveDef.clampMax = 0.0f;
                stoppingSound.activeAnimations.add(stoppingActiveDef);
                definition.rendering.sounds.add(stoppingSound);
                JSONSound sputteringSound = new JSONSound();
                sputteringSound.name = definition.packID + ":" + definition.systemName + "_sputter";
                sputteringSound.forceSound = true;
                sputteringSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition sputteringActiveDef = new JSONAnimationDefinition();
                sputteringActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                sputteringActiveDef.variable = "engine_backfired";
                sputteringActiveDef.clampMin = 1.0f;
                sputteringActiveDef.clampMax = 1.0f;
                sputteringSound.activeAnimations.add(sputteringActiveDef);
                definition.rendering.sounds.add(sputteringSound);
                JSONSound grindingSound = new JSONSound();
                grindingSound.name = MasterLoader.resourceDomain + ":engine_shifting_grinding";
                grindingSound.forceSound = true;
                grindingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition grindingActiveDef = new JSONAnimationDefinition();
                grindingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                grindingActiveDef.variable = "engine_badshift";
                grindingActiveDef.clampMin = 1.0f;
                grindingActiveDef.clampMax = 1.0f;
                grindingSound.activeAnimations.add(grindingActiveDef);
                definition.rendering.sounds.add(grindingSound);
                JSONSound crankingSound = new JSONSound();
                crankingSound.name = definition.packID + ":" + definition.systemName + "_cranking";
                crankingSound.looping = true;
                crankingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition crankingActiveDef = new JSONAnimationDefinition();
                crankingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                crankingActiveDef.variable = "engine_starter";
                crankingActiveDef.clampMin = 1.0f;
                crankingActiveDef.clampMax = 1.0f;
                crankingSound.activeAnimations.add(crankingActiveDef);
                crankingSound.pitchAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition crankingPitchDef = new JSONAnimationDefinition();
                if (!definition.engine.isCrankingNotPitched) {
                    crankingPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                    crankingPitchDef.variable = "electric_power";
                    crankingPitchDef.axis = new Point3d(0.0, 0.1, 0.0);
                    crankingPitchDef.offset = 0.3f;
                    crankingPitchDef.clampMax = 1.0f;
                    definition.engine.isCrankingNotPitched = false;
                } else {
                    crankingPitchDef = new JSONAnimationDefinition();
                    crankingPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                    crankingPitchDef.variable = "engine_rpm";
                    crankingPitchDef.axis = new Point3d(0.0, 1.0 / (definition.engine.maxRPM < 15000 ? 500.0 : 2000.0), 0.0);
                }
                crankingSound.pitchAnimations.add(crankingPitchDef);
                definition.rendering.sounds.add(crankingSound);
                if (definition.engine.customSoundset != null) {
                    for (JSONPart.JSONPartEngine.EngineSound customSound : definition.engine.customSoundset) {
                        JSONSound runningSound = new JSONSound();
                        runningSound.name = customSound.soundName;
                        runningSound.looping = true;
                        runningSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                        runningSound.volumeAnimations = new ArrayList<JSONAnimationDefinition>();
                        runningSound.pitchAnimations = new ArrayList<JSONAnimationDefinition>();
                        JSONAnimationDefinition runningStartDef = new JSONAnimationDefinition();
                        runningStartDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        runningStartDef.variable = "engine_powered";
                        runningStartDef.clampMin = 1.0f;
                        runningStartDef.clampMax = 1.0f;
                        runningSound.activeAnimations.add(runningStartDef);
                        JSONAnimationDefinition runningVolumeDef = new JSONAnimationDefinition();
                        if (customSound.volumeAdvanced) {
                            runningVolumeDef.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                            runningVolumeDef.variable = "engine_rpm";
                            runningVolumeDef.centerPoint = new Point3d();
                            runningVolumeDef.axis = new Point3d(-1.0E-6 / (double)(customSound.volumeLength / 1000.0f), 0.0, customSound.volumeCenter);
                            runningVolumeDef.offset = customSound.volumeLength / 20000.0f + 1.0f;
                        } else {
                            runningVolumeDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                            runningVolumeDef.variable = "engine_rpm_percent";
                            runningVolumeDef.axis = new Point3d(0.0, customSound.volumeMax - customSound.volumeIdle, 0.0);
                            runningVolumeDef.offset = customSound.volumeIdle + (float)((definition.engine.maxRPM < 15000 ? 500 : 2000) / definition.engine.maxRPM);
                        }
                        runningSound.volumeAnimations.add(runningVolumeDef);
                        JSONAnimationDefinition runningPitchDef = new JSONAnimationDefinition();
                        if (customSound.pitchAdvanced) {
                            runningPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                            runningPitchDef.variable = "engine_rpm";
                            runningPitchDef.centerPoint = new Point3d();
                            runningPitchDef.axis = new Point3d(-1.0E-6 / (double)(customSound.pitchLength / 1000.0f), 0.0, customSound.pitchCenter);
                            runningPitchDef.offset = customSound.pitchLength / 20000.0f + 1.0f;
                        } else {
                            runningPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                            runningPitchDef.variable = "engine_rpm_percent";
                            runningPitchDef.axis = new Point3d(0.0, customSound.pitchMax - customSound.pitchIdle, 0.0);
                            runningPitchDef.offset = customSound.pitchIdle + (float)((definition.engine.maxRPM < 15000 ? 500 : 2000) / definition.engine.maxRPM);
                        }
                        runningSound.pitchAnimations.add(runningPitchDef);
                        definition.rendering.sounds.add(runningSound);
                    }
                    definition.engine.customSoundset = null;
                } else {
                    JSONSound runningSound = new JSONSound();
                    runningSound.name = definition.packID + ":" + definition.systemName + "_running";
                    runningSound.looping = true;
                    runningSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition runningVolumeDef = new JSONAnimationDefinition();
                    runningVolumeDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    runningVolumeDef.variable = "engine_powered";
                    runningVolumeDef.clampMin = 1.0f;
                    runningVolumeDef.clampMax = 1.0f;
                    runningSound.activeAnimations.add(runningVolumeDef);
                    runningSound.pitchAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition runningPitchDef = new JSONAnimationDefinition();
                    runningPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                    runningPitchDef.variable = "engine_rpm";
                    runningPitchDef.axis = new Point3d(0.0, 0.35 / (double)(definition.engine.maxRPM < 15000 ? 500 : 5000), 0.0);
                    runningPitchDef.offset = 0.35f;
                    runningSound.pitchAnimations.add(runningPitchDef);
                    definition.rendering.sounds.add(runningSound);
                }
            } else if (definition.gun != null) {
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.sounds == null) {
                    definition.rendering.sounds = new ArrayList<JSONSound>();
                }
                JSONSound firingSound = new JSONSound();
                firingSound.name = definition.packID + ":" + definition.systemName + "_firing";
                firingSound.forceSound = true;
                firingSound.canPlayOnPartialTicks = definition.gun.fireDelay < 2.0f;
                firingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition firingDef = new JSONAnimationDefinition();
                firingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                firingDef.variable = "gun_fired";
                firingDef.clampMin = 1.0f;
                firingDef.clampMax = 1.0f;
                firingSound.activeAnimations.add(firingDef);
                definition.rendering.sounds.add(firingSound);
                JSONSound reloadingSound = new JSONSound();
                reloadingSound.name = definition.packID + ":" + definition.systemName + "_reloading";
                reloadingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition reloadingDef = new JSONAnimationDefinition();
                reloadingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                reloadingDef.variable = "gun_reload";
                reloadingDef.clampMin = 1.0f;
                reloadingDef.clampMax = 1.0f;
                reloadingSound.activeAnimations.add(reloadingDef);
                definition.rendering.sounds.add(reloadingSound);
            } else if (definition.ground != null) {
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.sounds == null) {
                    definition.rendering.sounds = new ArrayList<JSONSound>();
                }
                JSONSound blowoutSound = new JSONSound();
                blowoutSound.name = MasterLoader.resourceDomain + ":wheel_blowout";
                blowoutSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition blowoutDef = new JSONAnimationDefinition();
                blowoutDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                blowoutDef.variable = "ground_isflat";
                blowoutDef.clampMin = 1.0f;
                blowoutDef.clampMax = 1.0f;
                blowoutSound.activeAnimations.add(blowoutDef);
                definition.rendering.sounds.add(blowoutSound);
                JSONSound strikingSound = new JSONSound();
                strikingSound.name = MasterLoader.resourceDomain + ":wheel_striking";
                strikingSound.forceSound = true;
                strikingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition strikingDef = new JSONAnimationDefinition();
                strikingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                strikingDef.variable = "ground_contacted";
                strikingDef.clampMin = 1.0f;
                strikingDef.clampMax = 1.0f;
                strikingSound.activeAnimations.add(strikingDef);
                definition.rendering.sounds.add(strikingSound);
                JSONSound skiddingSound = new JSONSound();
                skiddingSound.name = MasterLoader.resourceDomain + ":wheel_skidding";
                skiddingSound.looping = true;
                skiddingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition skiddingDef = new JSONAnimationDefinition();
                skiddingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                skiddingDef.variable = "ground_slipping";
                skiddingDef.clampMin = 1.0f;
                skiddingDef.clampMax = 1.0f;
                skiddingSound.activeAnimations.add(skiddingDef);
                definition.rendering.sounds.add(skiddingSound);
            }
        }
        if (definition.rendering != null && definition.rendering.particles == null) {
            JSONParticle particleDef;
            definition.rendering.particles = new ArrayList<JSONParticle>();
            if (definition.engine != null) {
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.BLACK;
                particleDef.spawnEveryTick = true;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_temp";
                activeAnimation.clampMin = 115.556f;
                activeAnimation.clampMax = 999.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.BLACK;
                particleDef.spawnEveryTick = true;
                particleDef.quantity = 1;
                particleDef.scale = 2.5f;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_temp";
                activeAnimation.clampMin = 121.111f;
                activeAnimation.clampMax = 999.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.DRIP;
                particleDef.color = ColorRGB.BLACK;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_oilleak";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "cycle_10_20";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.DRIP;
                particleDef.color = ColorRGB.RED;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_fuelleak";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "cycle_10_20";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
            } else if (definition.ground != null) {
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.WHITE;
                particleDef.quantity = 4;
                particleDef.initialVelocity = new Point3d(0.0, 0.15, 0.0);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_contacted";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.WHITE;
                particleDef.quantity = 4;
                particleDef.spawnEveryTick = true;
                particleDef.pos = new Point3d(0.0, -definition.ground.height / 2.0f, 0.0);
                particleDef.initialVelocity = new Point3d(0.0, 0.15, 0.0);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_slipping";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.BREAK;
                particleDef.color = new ColorRGB("999999");
                particleDef.quantity = 4;
                particleDef.scale = 0.3f;
                particleDef.spawnEveryTick = true;
                particleDef.pos = new Point3d(0.0, -definition.ground.height / 2.0f, 0.0);
                particleDef.initialVelocity = new Point3d(0.0, 1.5, -1.5);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_skidding";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.BREAK;
                particleDef.color = new ColorRGB("999999");
                particleDef.quantity = 4;
                particleDef.scale = 0.3f;
                particleDef.spawnEveryTick = true;
                particleDef.pos = new Point3d(0.0, -definition.ground.height / 2.0f, 0.0);
                particleDef.initialVelocity = new Point3d(0.0, 1.5, 0.0);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_slipping";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
            }
        }
    }

    private static void performInstrumentLegacyCompats(JSONInstrument definition) {
        boolean oldDefinition = false;
        for (JSONInstrument.Component component : definition.components) {
            if (component.rotationVariable == null && component.translationVariable == null) continue;
            oldDefinition = true;
        }
        for (JSONInstrument.Component component : definition.components) {
            JSONAnimationDefinition animation;
            if (oldDefinition) {
                component.lightUpTexture = true;
                component.overlayTexture = component.lightOverlay;
                component.lightOverlay = false;
            }
            if (component.rotationVariable != null) {
                component.animations = new ArrayList<JSONAnimationDefinition>();
                animation = new JSONAnimationDefinition();
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                animation.variable = component.rotationVariable;
                animation.centerPoint = new Point3d();
                animation.axis = new Point3d(0.0, 0.0, component.rotationFactor);
                animation.offset = component.rotationOffset;
                animation.clampMin = component.rotationClampMin;
                animation.clampMax = component.rotationClampMax;
                animation.absolute = component.rotationAbsoluteValue;
                component.animations.add(animation);
                component.rotationVariable = null;
                component.rotationFactor = 0.0f;
                component.rotationOffset = 0.0f;
                component.rotationClampMin = 0.0f;
                component.rotationClampMax = 0.0f;
                component.rotationAbsoluteValue = false;
            }
            if (component.translationVariable != null) {
                if (component.animations == null) {
                    component.animations = new ArrayList<JSONAnimationDefinition>();
                }
                animation = new JSONAnimationDefinition();
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                animation.variable = component.translationVariable;
                animation.axis = component.translateHorizontal ? new Point3d(component.translationFactor, 0.0, 0.0) : new Point3d(0.0, component.translationFactor, 0.0);
                animation.clampMin = component.translationClampMin;
                animation.clampMax = component.translationClampMax;
                animation.absolute = component.translationAbsoluteValue;
                if (component.rotateWindow) {
                    component.animations.add(animation);
                } else {
                    component.animations.add(0, animation);
                }
                component.translateHorizontal = false;
                component.translationVariable = null;
                component.translationFactor = 0.0f;
                component.translationClampMin = 0.0f;
                component.translationClampMax = 0.0f;
                component.translationAbsoluteValue = false;
            }
            if ((double)component.scale == 0.0) {
                component.scale = 1.0f;
            }
            if (component.textObject == null || component.textObject.variableName != null) continue;
            component.textObject.variableName = component.textObject.fieldName;
            component.textObject.variableFormat = "%0" + component.textObject.maxLength + ".0f";
            component.textObject.variableFactor = 1.0f;
            component.textObject.fieldName = null;
            component.textObject.maxLength = 0;
        }
        if (definition.textureName == null) {
            definition.textureName = "instruments.png";
        }
    }

    private static void performPoleLegacyCompats(JSONPoleComponent definition) {
        if (definition.definitions == null) {
            definition.definitions = new ArrayList();
            JSONSubDefinition subDefinition = new JSONSubDefinition();
            subDefinition.extraMaterials = new ArrayList<String>();
            subDefinition.name = definition.general.name;
            subDefinition.subName = "";
            definition.definitions.add(subDefinition);
        }
        if (definition.general.textLines != null) {
            definition.general.textObjects = new ArrayList<JSONText>();
            for (AJSONItem.General.TextLine line : definition.general.textLines) {
                JSONText object = new JSONText();
                object.color = line.color;
                object.scale = line.scale;
                object.maxLength = line.characters;
                object.pos = new Point3d(line.xPos, line.yPos, (double)line.zPos + 0.01);
                object.rot = new Point3d();
                object.fieldName = "TextLine #" + (definition.general.textObjects.size() + 1);
                definition.general.textObjects.add(object);
            }
            definition.general.textLines = null;
        }
        if (definition.general.textObjects != null) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            definition.rendering.textObjects = definition.general.textObjects;
            definition.general.textObjects = null;
        }
        if (definition.rendering != null && definition.rendering.textObjects != null) {
            for (JSONText text : definition.rendering.textObjects) {
                if (text.defaultText != null) continue;
                text.defaultText = "";
            }
        }
        if (definition.general.type != null) {
            definition.pole = definition.new JSONPoleComponent.JSONPoleGeneric();
            definition.pole.type = ItemPoleComponent.PoleComponentType.valueOf(definition.general.type.toUpperCase());
            definition.general.type = null;
            definition.pole.radius = definition.general.radius;
            definition.general.radius = 0.0f;
        }
        if (definition.pole.type.equals((Object)ItemPoleComponent.PoleComponentType.CORE) && definition.rendering == null) {
            definition.rendering = new JSONRendering();
            definition.rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
            for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                if (axis.equals((Object)ABlockBase.Axis.NONE)) continue;
                JSONAnimatedObject connectorModelObject = new JSONAnimatedObject();
                connectorModelObject.objectName = axis.name().toLowerCase();
                connectorModelObject.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition connectorVisibilityInhibitor = new JSONAnimationDefinition();
                connectorVisibilityInhibitor.animationType = JSONAnimationDefinition.AnimationComponentType.INHIBITOR;
                connectorVisibilityInhibitor.variable = "solid_present_" + axis.name().toLowerCase();
                connectorVisibilityInhibitor.clampMin = 1.0f;
                connectorVisibilityInhibitor.clampMax = 1.0f;
                connectorModelObject.animations.add(connectorVisibilityInhibitor);
                JSONAnimationDefinition connectorVisibility = new JSONAnimationDefinition();
                connectorVisibility.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                connectorVisibility.variable = "neighbor_present_" + axis.name().toLowerCase();
                connectorVisibility.clampMin = 1.0f;
                connectorVisibility.clampMax = 1.0f;
                connectorModelObject.animations.add(connectorVisibility);
                definition.rendering.animatedObjects.add(connectorModelObject);
                JSONAnimatedObject solidModelObject = new JSONAnimatedObject();
                solidModelObject.objectName = axis.name().toLowerCase() + "_solid";
                solidModelObject.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition solidVisibility = new JSONAnimationDefinition();
                solidVisibility.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                solidVisibility.variable = "solid_present_" + axis.name().toLowerCase();
                solidVisibility.clampMin = 1.0f;
                solidVisibility.clampMax = 1.0f;
                solidModelObject.animations.add(solidVisibility);
                definition.rendering.animatedObjects.add(solidModelObject);
                if (!axis.equals((Object)ABlockBase.Axis.UP) && !axis.equals((Object)ABlockBase.Axis.DOWN)) continue;
                JSONAnimatedObject slabModelObject = new JSONAnimatedObject();
                slabModelObject.objectName = axis.name().toLowerCase() + "_slab";
                slabModelObject.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition slabVisibility = new JSONAnimationDefinition();
                slabVisibility.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                slabVisibility.variable = "slab_present_" + axis.name().toLowerCase();
                slabVisibility.clampMin = 1.0f;
                slabVisibility.clampMax = 1.0f;
                slabModelObject.animations.add(slabVisibility);
                definition.rendering.animatedObjects.add(slabModelObject);
            }
        }
    }

    private static void performDecorLegacyCompats(JSONDecor definition) {
        if (definition.decor == null) {
            definition.decor = definition.new JSONDecor.JSONDecorGeneric();
            if (definition.general.type != null) {
                definition.decor.type = JSONDecor.DecorComponentType.valueOf(definition.general.type.toUpperCase());
                definition.general.type = null;
            }
            definition.decor.width = definition.general.width;
            definition.general.width = 0.0f;
            definition.decor.height = definition.general.height;
            definition.general.height = 0.0f;
            definition.decor.depth = definition.general.depth;
            definition.general.depth = 0.0f;
            definition.decor.itemTypes = definition.general.itemTypes;
            definition.general.itemTypes = null;
            definition.decor.partTypes = definition.general.partTypes;
            definition.general.partTypes = null;
            definition.decor.items = definition.general.items;
            definition.general.items = null;
        }
        if (definition.decor.type == null) {
            definition.decor.type = JSONDecor.DecorComponentType.GENERIC;
        }
        if ((definition.decor.type.equals((Object)JSONDecor.DecorComponentType.ITEM_LOADER) || definition.decor.type.equals((Object)JSONDecor.DecorComponentType.ITEM_UNLOADER)) && definition.decor.inventoryUnits == 0.0f) {
            definition.decor.inventoryUnits = 0.11111111f;
        }
        if (definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FUEL_PUMP) || definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FLUID_LOADER) || definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FLUID_UNLOADER)) {
            if (definition.decor.fuelCapacity == 0) {
                definition.decor.fuelCapacity = 15000;
            }
            if (definition.decor.pumpRate == 0) {
                definition.decor.pumpRate = 10;
            }
        }
        if (definition.definitions == null) {
            definition.definitions = new ArrayList();
            JSONSubDefinition subDefinition = new JSONSubDefinition();
            subDefinition.extraMaterials = new ArrayList<String>();
            subDefinition.name = definition.general.name;
            subDefinition.subName = "";
            definition.definitions.add(subDefinition);
        }
        if (definition.general.textLines != null) {
            definition.general.textObjects = new ArrayList<JSONText>();
            int lineNumber = 0;
            for (AJSONItem.General.TextLine line : definition.general.textLines) {
                JSONText object = new JSONText();
                object.lightsUp = true;
                object.color = line.color;
                object.scale = line.scale;
                if (lineNumber++ < 3) {
                    object.pos = new Point3d(line.xPos, line.yPos, (double)line.zPos + 1.0E-4);
                    object.rot = new Point3d();
                } else {
                    object.pos = new Point3d(line.xPos, line.yPos, (double)line.zPos - 1.0E-4);
                    object.rot = new Point3d(0.0, 180.0, 0.0);
                }
                object.fieldName = "TextLine #" + (definition.general.textObjects.size() + 1);
                definition.general.textObjects.add(object);
            }
            definition.general.textLines = null;
        }
        if (definition.general.textObjects != null) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            definition.rendering.textObjects = definition.general.textObjects;
            definition.general.textObjects = null;
        }
        if (definition.rendering != null && definition.rendering.textObjects != null) {
            for (JSONText text : definition.rendering.textObjects) {
                if (text.defaultText != null) continue;
                text.defaultText = "";
            }
        }
        if (definition.decor.items != null || definition.decor.itemTypes != null) {
            definition.decor.crafting = new JSONCraftingBench();
            definition.decor.crafting.itemTypes = definition.decor.itemTypes;
            definition.decor.itemTypes = null;
            definition.decor.crafting.partTypes = definition.decor.partTypes;
            definition.decor.partTypes = null;
            definition.decor.crafting.items = definition.decor.items;
            definition.decor.items = null;
        }
        if (definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FUEL_PUMP) && definition.rendering != null && definition.rendering.textObjects != null) {
            block7: for (int i = 0; i < definition.rendering.textObjects.size(); ++i) {
                JSONText textDef = definition.rendering.textObjects.get(i);
                switch (i % 3) {
                    case 0: {
                        textDef.variableName = "fuelpump_fluid";
                        textDef.variableFormat = "%s";
                        continue block7;
                    }
                    case 1: {
                        textDef.variableName = "fuelpump_stored";
                        textDef.variableFactor = 0.001f;
                        textDef.variableFormat = "LVL:%04.1fb";
                        continue block7;
                    }
                    case 2: {
                        textDef.variableName = "fuelpump_dispensed";
                        textDef.variableFactor = 0.001f;
                        textDef.variableFormat = "DISP:%04.1fb";
                    }
                }
            }
        }
        if (definition.decor.type.equals((Object)JSONDecor.DecorComponentType.BEACON) && definition.rendering == null) {
            definition.rendering = new JSONRendering();
            if (definition.rendering.textObjects == null) {
                definition.rendering.textObjects = new ArrayList<JSONText>();
                JSONText nameTextObject = new JSONText();
                nameTextObject.pos = new Point3d(0.0, -500.0, 0.0);
                nameTextObject.rot = new Point3d();
                nameTextObject.fieldName = "Beacon Name";
                nameTextObject.defaultText = "NONE";
                nameTextObject.maxLength = 5;
                nameTextObject.color = ColorRGB.WHITE;
                definition.rendering.textObjects.add(nameTextObject);
                JSONText glideslopeTextObject = new JSONText();
                glideslopeTextObject.pos = new Point3d(0.0, -500.0, 0.0);
                glideslopeTextObject.rot = new Point3d();
                glideslopeTextObject.fieldName = "Glide Slope (Deg)";
                glideslopeTextObject.defaultText = "10.0";
                glideslopeTextObject.maxLength = 5;
                glideslopeTextObject.color = ColorRGB.WHITE;
                definition.rendering.textObjects.add(glideslopeTextObject);
                JSONText bearingTextObject = new JSONText();
                bearingTextObject.pos = new Point3d(0.0, -500.0, 0.0);
                bearingTextObject.rot = new Point3d();
                bearingTextObject.fieldName = "Bearing (Deg)";
                bearingTextObject.defaultText = "0.0";
                bearingTextObject.maxLength = 5;
                bearingTextObject.color = ColorRGB.WHITE;
                definition.rendering.textObjects.add(bearingTextObject);
            }
        }
    }

    private static void performRoadLegacyCompats(JSONRoadComponent definition) {
        if (definition.road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC) && definition.road.segmentLength == 0.0f) {
            definition.road.segmentLength = 1.0f;
        }
    }

    private static void performItemLegacyCompats(JSONItem definition) {
        if (definition.item == null) {
            definition.item = definition.new JSONItem.JSONItemGeneric();
            if (definition.general.type != null) {
                definition.item.type = JSONItem.ItemComponentType.valueOf(definition.general.type.toUpperCase());
                definition.general.type = null;
            }
        }
        if (definition.item.type == null) {
            definition.item.type = JSONItem.ItemComponentType.NONE;
        }
        if (definition.booklet != null) {
            for (JSONText text : definition.booklet.titleText) {
                text.fieldName = "";
            }
            for (JSONItem.JSONBooklet.BookletPage page : definition.booklet.pages) {
                for (JSONText text : page.pageText) {
                    text.fieldName = "";
                }
            }
        }
    }

    private static void performSkinLegacyCompats(JSONSkin definition) {
        if (definition.general.packID != null) {
            definition.skin = definition.new JSONSkin.Skin();
            definition.skin.packID = definition.general.packID;
            definition.general.packID = null;
            definition.skin.systemName = definition.general.systemName;
            definition.general.systemName = null;
        }
        definition.general.materials = new ArrayList<String>();
    }

    private static void performBulletLegacyCompats(JSONBullet definition) {
        if (definition.rendering == null || definition.rendering.particles == null) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            if (definition.rendering.particles == null) {
                definition.rendering.particles = new ArrayList<JSONParticle>();
            }
            JSONParticle particleDef = new JSONParticle();
            particleDef = new JSONParticle();
            particleDef.type = JSONParticle.ParticleType.BREAK;
            particleDef.color = new ColorRGB("999999");
            particleDef.quantity = 4;
            particleDef.scale = 0.3f;
            particleDef.pos = new Point3d(0.0, 0.5, 0.0);
            particleDef.initialVelocity = new Point3d(0.0, 1.5, 0.0);
            particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
            JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
            activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
            activeAnimation.variable = "bullet_hit_block";
            activeAnimation.clampMin = 1.0f;
            activeAnimation.clampMax = 1.0f;
            particleDef.activeAnimations.add(activeAnimation);
            definition.rendering.particles.add(particleDef);
        }
    }

    private static void performVehiclePartDefLegacyCompats(JSONPartDefinition partDef) {
        int i;
        if (partDef.additionalPart != null) {
            partDef.additionalParts = new ArrayList<JSONPartDefinition>();
            partDef.additionalParts.add(partDef.additionalPart);
            partDef.additionalPart = null;
        }
        if (partDef.linkedDoor != null) {
            partDef.linkedDoors = new ArrayList<String>();
            partDef.linkedDoors.add(partDef.linkedDoor);
            partDef.linkedDoor = null;
        }
        if (partDef.linkedDoors != null) {
            partDef.linkedVariables = partDef.linkedDoors;
            partDef.linkedDoors = null;
        }
        if (partDef.exhaustPos != null) {
            partDef.particleObjects = new ArrayList<JSONParticle>();
            for (i = 0; i < partDef.exhaustPos.length; i += 3) {
                JSONParticle particle = new JSONParticle();
                particle.type = JSONParticle.ParticleType.SMOKE;
                particle.pos = new Point3d(partDef.exhaustPos[i], partDef.exhaustPos[i + 1], partDef.exhaustPos[i + 2]);
                particle.velocityVector = new Point3d(partDef.exhaustVelocity[i], partDef.exhaustVelocity[i + 1], partDef.exhaustVelocity[i + 2]);
                particle.scale = 1.0f;
                particle.color = new ColorRGB("#D9D9D9");
                particle.transparency = 0.25f;
                particle.toTransparency = 0.25f;
                partDef.particleObjects.add(particle);
            }
            partDef.exhaustPos = null;
            partDef.exhaustVelocity = null;
        }
        if (partDef.exhaustObjects != null) {
            partDef.particleObjects = new ArrayList<JSONParticle>();
            for (JSONPartDefinition.ExhaustObject exhaust : partDef.exhaustObjects) {
                JSONParticle particle = new JSONParticle();
                particle.type = JSONParticle.ParticleType.SMOKE;
                particle.pos = exhaust.pos;
                particle.velocityVector = exhaust.velocity;
                particle.scale = exhaust.scale;
                particle.color = new ColorRGB("#D9D9D9");
                particle.transparency = 0.25f;
                particle.toTransparency = 0.25f;
                partDef.particleObjects.add(particle);
            }
            partDef.exhaustObjects = null;
        }
        if (partDef.rotationVariable != null) {
            partDef.animations = new ArrayList<JSONAnimationDefinition>();
            JSONAnimationDefinition animation = new JSONAnimationDefinition();
            animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
            animation.variable = partDef.rotationVariable;
            animation.centerPoint = partDef.rotationPosition;
            animation.axis = partDef.rotationAngles;
            animation.clampMin = partDef.rotationClampMin;
            animation.clampMax = partDef.rotationClampMax;
            animation.absolute = partDef.rotationAbsolute;
            partDef.animations.add(animation);
            partDef.rotationVariable = null;
            partDef.rotationPosition = null;
            partDef.rotationAngles = null;
            partDef.rotationClampMin = 0.0f;
            partDef.rotationClampMax = 0.0f;
            partDef.rotationAbsolute = false;
        }
        if (partDef.translationVariable != null) {
            if (partDef.animations == null) {
                partDef.animations = new ArrayList<JSONAnimationDefinition>();
            }
            JSONAnimationDefinition animation = new JSONAnimationDefinition();
            animation.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
            animation.variable = partDef.translationVariable;
            animation.axis = partDef.translationPosition;
            animation.clampMin = partDef.translationClampMin;
            animation.clampMax = partDef.translationClampMax;
            animation.absolute = partDef.translationAbsolute;
            partDef.animations.add(animation);
            partDef.translationVariable = null;
            partDef.translationPosition = null;
            partDef.translationClampMin = 0.0f;
            partDef.translationClampMax = 0.0f;
            partDef.translationAbsolute = false;
        }
        for (i = 0; i < partDef.types.size(); i = (int)((byte)(i + 1))) {
            String partName = partDef.types.get(i);
            if (partName.equals("wheel") || partName.equals("skid") || partName.equals("pontoon") || partName.equals("tread")) {
                if (partName.equals("tread")) {
                    partDef.turnsWithSteer = true;
                }
                partDef.types.set(i, "ground_" + partName);
            } else if (partName.equals("crate") || partName.equals("barrel") || partName.equals("crafting_table") || partName.equals("furnace") || partName.equals("brewing_stand")) {
                partDef.types.set(i, "interactable_" + partName);
                partDef.minValue = 0.0f;
                partDef.maxValue = 1.0f;
            } else if (partName.equals("fertilizer") || partName.equals("harvester") || partName.equals("planter") || partName.equals("plow")) {
                partDef.types.set(i, "effector_" + partName);
            } else if (partName.equals("custom")) {
                partDef.types.set(i, "generic");
            }
            if (partName.equals("ground_wheel") && partDef.turnsWithSteer && partDef.animations == null) {
                partDef.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition animation = new JSONAnimationDefinition();
                animation.centerPoint = new Point3d();
                animation.axis = new Point3d(0.0, partDef.pos.z > 0.0 ? -1.0 : 1.0, 0.0);
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                animation.variable = "rudder";
                partDef.animations.add(animation);
            }
            if (partDef.additionalParts == null) continue;
            for (JSONPartDefinition additionalPartDef : partDef.additionalParts) {
                LegacyCompatSystem.performVehiclePartDefLegacyCompats(additionalPartDef);
            }
        }
    }

    private static void performVehicleConnectionLegacyCompats(AJSONInteractableEntity interactableDef) {
        if (interactableDef.connections != null) {
            interactableDef.connectionGroups = new ArrayList<JSONConnectionGroup>();
            JSONConnectionGroup hitchGroup = null;
            JSONConnectionGroup hookupGroup = null;
            for (JSONConnection connection : interactableDef.connections) {
                if (connection.hookup) {
                    if (hookupGroup == null) {
                        hookupGroup = new JSONConnectionGroup();
                        hookupGroup.connections = new ArrayList<JSONConnection>();
                        hookupGroup.groupName = "HOOKUP";
                        hookupGroup.hookup = true;
                    }
                    connection.hookup = false;
                    hookupGroup.connections.add(connection);
                    continue;
                }
                if (hitchGroup == null) {
                    hitchGroup = new JSONConnectionGroup();
                    hitchGroup.connections = new ArrayList<JSONConnection>();
                    hitchGroup.groupName = "TRAILER";
                    hitchGroup.canIntiateConnections = true;
                }
                hitchGroup.connections.add(connection);
            }
            if (hookupGroup != null) {
                interactableDef.connectionGroups.add(hookupGroup);
            }
            if (hitchGroup != null) {
                interactableDef.connectionGroups.add(hitchGroup);
            }
            interactableDef.connections = null;
        }
    }

    private static void performVehicleCollisionLegacyCompats(AJSONInteractableEntity interactableDef) {
        Object collisionGroup;
        if (interactableDef.doors != null) {
            if (interactableDef.collisionGroups == null) {
                interactableDef.collisionGroups = new ArrayList<JSONCollisionGroup>();
            }
            for (JSONDoor door : interactableDef.doors) {
                if (!door.closedByDefault) {
                    if (interactableDef.rendering.initialVariables == null) {
                        interactableDef.rendering.initialVariables = new ArrayList<String>();
                    }
                    interactableDef.rendering.initialVariables.add(door.name);
                }
                collisionGroup = new JSONCollisionGroup();
                ((JSONCollisionGroup)collisionGroup).collisions = new ArrayList<JSONCollisionBox>();
                ((JSONCollisionGroup)collisionGroup).isInterior = true;
                JSONCollisionBox collision = new JSONCollisionBox();
                collision.variableName = door.ignoresClicks ? null : door.name;
                collision.pos = door.closedPos;
                collision.width = door.width;
                collision.height = door.height;
                collision.armorThickness = door.armorThickness;
                ((JSONCollisionGroup)collisionGroup).collisions.add(collision);
                ((JSONCollisionGroup)collisionGroup).animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition animation = new JSONAnimationDefinition();
                animation.axis = door.openPos.subtract(door.closedPos);
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                animation.variable = door.name;
                ((JSONCollisionGroup)collisionGroup).animations.add(animation);
                interactableDef.collisionGroups.add((JSONCollisionGroup)collisionGroup);
            }
            interactableDef.doors = null;
        }
        if (interactableDef.collision != null) {
            if (interactableDef.collisionGroups == null) {
                interactableDef.collisionGroups = new ArrayList<JSONCollisionGroup>();
            }
            ArrayList<JSONCollisionBox> interiorBoxes = new ArrayList<JSONCollisionBox>();
            ArrayList<JSONCollisionBox> exteriorBoxes = new ArrayList<JSONCollisionBox>();
            for (JSONCollisionBox boxDef : interactableDef.collision) {
                if (boxDef.isInterior) {
                    interiorBoxes.add(boxDef);
                    boxDef.isInterior = false;
                    continue;
                }
                exteriorBoxes.add(boxDef);
            }
            if (!interiorBoxes.isEmpty()) {
                collisionGroup = new JSONCollisionGroup();
                ((JSONCollisionGroup)collisionGroup).collisions = interiorBoxes;
                ((JSONCollisionGroup)collisionGroup).isInterior = true;
                interactableDef.collisionGroups.add((JSONCollisionGroup)collisionGroup);
            }
            if (!exteriorBoxes.isEmpty()) {
                collisionGroup = new JSONCollisionGroup();
                ((JSONCollisionGroup)collisionGroup).collisions = exteriorBoxes;
                interactableDef.collisionGroups.add((JSONCollisionGroup)collisionGroup);
            }
            interactableDef.collision = null;
        }
        if (interactableDef.collisionGroups != null) {
            for (JSONCollisionGroup group : interactableDef.collisionGroups) {
                for (JSONCollisionBox box : group.collisions) {
                    if (box.variableName == null || box.variableType != null) continue;
                    box.variableType = JSONCollisionBox.VariableType.TOGGLE;
                }
            }
        }
    }

    private static void performAnimationLegacyCompats(JSONRendering rendering) {
        Object animation;
        Object object;
        if (rendering.textMarkings != null) {
            rendering.textObjects = new ArrayList<JSONText>();
            for (JSONRendering.VehicleDisplayText marking : rendering.textMarkings) {
                object = new JSONText();
                ((JSONText)object).lightsUp = rendering.textLighted;
                ((JSONText)object).color = marking.color;
                ((JSONText)object).scale = marking.scale;
                ((JSONText)object).maxLength = rendering.displayTextMaxLength;
                ((JSONText)object).pos = marking.pos;
                ((JSONText)object).rot = marking.rot;
                ((JSONText)object).fieldName = "Text";
                ((JSONText)object).defaultText = rendering.defaultDisplayText;
                rendering.textObjects.add((JSONText)object);
            }
            rendering.textMarkings = null;
            rendering.defaultDisplayText = null;
            rendering.displayTextMaxLength = 0;
            rendering.textLighted = false;
        }
        if (rendering.rotatableModelObjects != null) {
            if (rendering.animatedObjects == null) {
                rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
            }
            for (JSONRendering.VehicleRotatableModelObject rotatable : rendering.rotatableModelObjects) {
                object = null;
                for (JSONAnimatedObject testObject : rendering.animatedObjects) {
                    if (!testObject.objectName.equals(rotatable.partName)) continue;
                    object = testObject;
                    break;
                }
                if (object == null) {
                    object = new JSONAnimatedObject();
                    ((JSONAnimatedObject)object).objectName = rotatable.partName;
                    ((JSONAnimatedObject)object).animations = new ArrayList<JSONAnimationDefinition>();
                    rendering.animatedObjects.add((JSONAnimatedObject)object);
                }
                animation = new JSONAnimationDefinition();
                ((JSONAnimationDefinition)animation).animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                ((JSONAnimationDefinition)animation).variable = rotatable.rotationVariable;
                ((JSONAnimationDefinition)animation).centerPoint = rotatable.rotationPoint;
                ((JSONAnimationDefinition)animation).axis = rotatable.rotationAxis != null ? rotatable.rotationAxis : new Point3d();
                ((JSONAnimationDefinition)animation).clampMin = rotatable.rotationClampMin;
                ((JSONAnimationDefinition)animation).clampMax = rotatable.rotationClampMax;
                ((JSONAnimationDefinition)animation).absolute = rotatable.absoluteValue;
                if (rotatable.rotationVariable.equals("steering_wheel")) {
                    ((JSONAnimationDefinition)animation).variable = "rudder";
                    ((JSONAnimationDefinition)animation).axis.multiply(-1.0);
                }
                if (rotatable.rotationVariable.equals("door")) {
                    ((JSONAnimationDefinition)animation).duration = 30;
                }
                ((JSONAnimatedObject)object).animations.add((JSONAnimationDefinition)animation);
            }
            rendering.rotatableModelObjects = null;
        }
        if (rendering.translatableModelObjects != null) {
            if (rendering.animatedObjects == null) {
                rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
            }
            for (JSONRendering.VehicleTranslatableModelObject translatable : rendering.translatableModelObjects) {
                object = null;
                for (JSONAnimatedObject testObject : rendering.animatedObjects) {
                    if (!testObject.objectName.equals(translatable.partName)) continue;
                    object = testObject;
                    break;
                }
                if (object == null) {
                    object = new JSONAnimatedObject();
                    ((JSONAnimatedObject)object).objectName = translatable.partName;
                    ((JSONAnimatedObject)object).animations = new ArrayList<JSONAnimationDefinition>();
                    rendering.animatedObjects.add((JSONAnimatedObject)object);
                }
                animation = new JSONAnimationDefinition();
                ((JSONAnimationDefinition)animation).animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                ((JSONAnimationDefinition)animation).variable = translatable.translationVariable;
                ((JSONAnimationDefinition)animation).axis = translatable.translationAxis;
                ((JSONAnimationDefinition)animation).clampMin = translatable.translationClampMin;
                ((JSONAnimationDefinition)animation).clampMax = translatable.translationClampMax;
                ((JSONAnimationDefinition)animation).absolute = translatable.absoluteValue;
                if (translatable.translationVariable.equals("steering_wheel")) {
                    ((JSONAnimationDefinition)animation).variable = "rudder";
                    ((JSONAnimationDefinition)animation).axis.multiply(-1.0);
                }
                if (translatable.translationVariable.equals("door")) {
                    ((JSONAnimationDefinition)animation).duration = 30;
                }
                ((JSONAnimatedObject)object).animations.add((JSONAnimationDefinition)animation);
            }
            rendering.translatableModelObjects = null;
        }
    }

    private static void performModelLegacyCompats(AJSONMultiModelProvider definition) {
        if (definition.rendering == null) {
            definition.rendering = new JSONRendering();
        }
        try {
            List<RenderableObject> parsedModel = AModelParser.parseModel(definition.getModelLocation(definition.definitions.get((int)0).subName));
            if (definition.rendering.lightObjects == null) {
                definition.rendering.lightObjects = new ArrayList<JSONLight>();
                for (RenderableObject object : parsedModel) {
                    boolean renderBeam;
                    String lightProperties;
                    if (!object.name.contains("&")) continue;
                    JSONLight lightDef = new JSONLight();
                    lightDef.objectName = object.name;
                    lightDef.brightnessAnimations = new ArrayList<JSONAnimationDefinition>();
                    lightDef.color = new ColorRGB(object.name.substring(object.name.indexOf(95) + 1, object.name.indexOf(95) + 7));
                    lightDef.brightnessAnimations = new ArrayList<JSONAnimationDefinition>();
                    String lowerCaseName = object.name.toLowerCase();
                    JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                    if (lowerCaseName.contains("brakelight")) {
                        activeAnimation.variable = "brake";
                    } else if (lowerCaseName.contains("backuplight")) {
                        activeAnimation.variable = "engine_reversed_1";
                    } else if (lowerCaseName.contains("daytimelight")) {
                        activeAnimation.variable = "engines_on";
                    } else if (lowerCaseName.contains("navigationlight")) {
                        activeAnimation.variable = "navigation_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasNavLights = true;
                        }
                    } else if (lowerCaseName.contains("strobelight")) {
                        activeAnimation.variable = "strobe_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasStrobeLights = true;
                        }
                    } else if (lowerCaseName.contains("taxilight")) {
                        activeAnimation.variable = "taxi_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasTaxiLights = true;
                        }
                    } else if (lowerCaseName.contains("landinglight")) {
                        activeAnimation.variable = "landing_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasLandingLights = true;
                        }
                    } else if (lowerCaseName.contains("runninglight")) {
                        activeAnimation.variable = "running_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasRunningLights = true;
                        }
                    } else if (lowerCaseName.contains("headlight")) {
                        activeAnimation.variable = "headlight";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasHeadlights = true;
                        }
                    } else if (lowerCaseName.contains("leftturnlight")) {
                        activeAnimation.variable = "left_turn_signal";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasTurnSignals = true;
                        }
                    } else if (lowerCaseName.contains("rightturnlight")) {
                        activeAnimation.variable = "right_turn_signal";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasTurnSignals = true;
                        }
                    } else if (lowerCaseName.contains("emergencylight")) {
                        activeAnimation.variable = "EMERLTS";
                        if (definition.rendering.customVariables == null) {
                            definition.rendering.customVariables = new ArrayList<String>();
                        }
                        if (definition instanceof JSONVehicle) {
                            definition.rendering.customVariables.add("EMERLTS");
                        }
                    } else if (lowerCaseName.contains("stoplight") || lowerCaseName.contains("cautionlight") || lowerCaseName.contains("golight")) {
                        String[] lightNames = lowerCaseName.split("light");
                        lightNames[0] = lightNames[0].replace("&", "");
                        activeAnimation.variable = lightNames[0] + "_light";
                        if (lightNames.length > 2) {
                            activeAnimation.variable = activeAnimation.variable + "_" + lightNames[2];
                        }
                        if (lightNames[0].equals("stop")) {
                            JSONAnimationDefinition cycleInhibitor = new JSONAnimationDefinition();
                            cycleInhibitor.animationType = JSONAnimationDefinition.AnimationComponentType.INHIBITOR;
                            cycleInhibitor.variable = "linked";
                            cycleInhibitor.clampMin = 1.0f;
                            cycleInhibitor.clampMax = 1.0f;
                            lightDef.brightnessAnimations.add(cycleInhibitor);
                            JSONAnimationDefinition cycleAnimation = new JSONAnimationDefinition();
                            cycleAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                            cycleAnimation.variable = "0_10_10_cycle";
                            cycleAnimation.clampMin = 1.0f;
                            cycleAnimation.clampMax = 1.0f;
                            lightDef.brightnessAnimations.add(cycleAnimation);
                            JSONAnimationDefinition lightActivator = new JSONAnimationDefinition();
                            lightActivator.animationType = JSONAnimationDefinition.AnimationComponentType.ACTIVATOR;
                            lightActivator.variable = "linked";
                            lightActivator.clampMin = 1.0f;
                            lightActivator.clampMax = 1.0f;
                            lightDef.brightnessAnimations.add(lightActivator);
                            JSONAnimationDefinition lightInhibitor = new JSONAnimationDefinition();
                            lightInhibitor.animationType = JSONAnimationDefinition.AnimationComponentType.INHIBITOR;
                            lightInhibitor.variable = "linked";
                            lightInhibitor.clampMin = 0.0f;
                            lightInhibitor.clampMax = 0.0f;
                            lightDef.brightnessAnimations.add(lightInhibitor);
                        }
                    }
                    if (activeAnimation.variable != null) {
                        activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        activeAnimation.clampMin = activeAnimation.variable.equals("brake") ? 0.01f : 1.0f;
                        activeAnimation.clampMax = 1.0f;
                        lightDef.brightnessAnimations.add(activeAnimation);
                    }
                    lightDef.isElectric = true;
                    int flashBits = Integer.decode("0x" + object.name.substring(object.name.indexOf(95, object.name.indexOf(95) + 7) + 1, object.name.lastIndexOf(95)));
                    int ticksTillOn = 0;
                    int ticksOn = 0;
                    boolean foundOn = false;
                    for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
                        if ((flashBits >> i & 1) == 1) {
                            if (!foundOn) {
                                foundOn = true;
                                ticksTillOn = i;
                            }
                            ++ticksOn;
                            continue;
                        }
                        if (foundOn) break;
                    }
                    if (ticksOn - ticksTillOn != 20) {
                        JSONAnimationDefinition cycleAnimation = new JSONAnimationDefinition();
                        cycleAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        cycleAnimation.variable = ticksTillOn + "_" + ticksOn + "_" + (20 - ticksOn - ticksTillOn) + "_cycle";
                        cycleAnimation.clampMin = 1.0f;
                        cycleAnimation.clampMax = 1.0f;
                        lightDef.brightnessAnimations.add(cycleAnimation);
                    }
                    boolean renderFlare = Integer.valueOf((lightProperties = object.name.substring(object.name.lastIndexOf(95) + 1)).substring(0, 1)) > 0;
                    lightDef.emissive = Integer.valueOf(lightProperties.substring(1, 2)) > 0;
                    boolean bl = lightDef.covered = Integer.valueOf(lightProperties.substring(2, 3)) > 0;
                    boolean bl2 = lightProperties.length() == 4 ? Integer.valueOf(lightProperties.substring(3)) > 0 : (renderBeam = lowerCaseName.contains("headlight") || lowerCaseName.contains("landinglight") || lowerCaseName.contains("taxilight") || lowerCaseName.contains("streetlight"));
                    if (renderFlare || renderBeam) {
                        if (lightDef.blendableComponents == null) {
                            lightDef.blendableComponents = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                        }
                        float[] masterVertex = new float[8];
                        for (int i = 0; i < object.vertices.capacity(); i += 24) {
                            float minX = 999.0f;
                            float maxX = -999.0f;
                            float minY = 999.0f;
                            float maxY = -999.0f;
                            float minZ = 999.0f;
                            float maxZ = -999.0f;
                            for (int j = 0; j < 24; j = (int)((byte)(j + 8))) {
                                object.vertices.get(masterVertex);
                                minX = Math.min(masterVertex[5], minX);
                                maxX = Math.max(masterVertex[5], maxX);
                                minY = Math.min(masterVertex[6], minY);
                                maxY = Math.max(masterVertex[6], maxY);
                                minZ = Math.min(masterVertex[7], minZ);
                                maxZ = Math.max(masterVertex[7], maxZ);
                            }
                            JSONLight.JSONLightBlendableComponent blendable = lightDef.new JSONLight.JSONLightBlendableComponent();
                            if (renderFlare) {
                                blendable.flareWidth = blendable.flareHeight = 3.0f * Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
                            }
                            if (renderBeam) {
                                blendable.beamDiameter = Math.max(Math.max(maxX - minX, maxZ - minZ), maxY - minY) * 64.0f;
                                blendable.beamLength = blendable.beamDiameter * 3.0f;
                            }
                            blendable.pos = new Point3d((double)minX + (double)(maxX - minX) / 2.0, (double)minY + (double)(maxY - minY) / 2.0, (double)minZ + (double)(maxZ - minZ) / 2.0);
                            blendable.axis = new Point3d(masterVertex[0], masterVertex[1], masterVertex[2]);
                            lightDef.blendableComponents.add(blendable);
                        }
                    }
                    definition.rendering.lightObjects.add(lightDef);
                }
            }
            for (RenderableObject object : parsedModel) {
                if (!object.name.toLowerCase().contains("roller")) continue;
                boolean animationPresent = false;
                if (definition.rendering != null && definition.rendering.animatedObjects != null) {
                    for (JSONAnimatedObject animatedObject : definition.rendering.animatedObjects) {
                        if (!object.name.equals(animatedObject.objectName)) continue;
                        animationPresent = true;
                        break;
                    }
                }
                if (animationPresent) continue;
                boolean isLeft = object.name.toLowerCase().startsWith("l");
                int partIndex = 1;
                for (JSONPartDefinition partDef : ((AJSONPartProvider)definition).parts) {
                    if (!partDef.types.contains("ground_tread")) continue;
                    if (!(partDef.pos.x >= 0.0 ^ isLeft)) break;
                    ++partIndex;
                }
                JSONAnimationDefinition animation = new JSONAnimationDefinition();
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                animation.variable = "ground_rotation_" + partIndex;
                float minY = 999.0f;
                float maxY = -999.0f;
                float minZ = 999.0f;
                float maxZ = -999.0f;
                for (int i = 0; i < object.vertices.capacity(); i += 8) {
                    float y = object.vertices.get(i + 6);
                    float z = object.vertices.get(i + 7);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    minZ = Math.min(minZ, z);
                    maxZ = Math.max(maxZ, z);
                }
                double radius = (double)(maxZ - minZ) / 2.0;
                animation.centerPoint = new Point3d(0.0, (double)minY + (double)(maxY - minY) / 2.0, (double)minZ + (double)(maxZ - minZ) / 2.0);
                animation.axis = new Point3d(0.3183098861837907 / (radius * 2.0), 0.0, 0.0);
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.animatedObjects == null) {
                    definition.rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
                }
                JSONAnimatedObject animatedObject = new JSONAnimatedObject();
                animatedObject.objectName = object.name;
                animatedObject.animations = new ArrayList<JSONAnimationDefinition>();
                animatedObject.animations.add(animation);
                definition.rendering.animatedObjects.add(animatedObject);
            }
        }
        catch (Exception e) {
            InterfaceCore.logError("Could not do model-based legacy compats on " + definition.packID + ":" + definition.systemName + ".  Lights and treads will likely not be present on this model.");
            InterfaceCore.logError(e.getMessage());
        }
    }
}

