/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.InterfaceCore;
import minecrafttransportsimulator.mcinterface.WrapperItemStack;

public class PackMaterialComponent {
    public final int qty;
    public final int meta;
    public final List<WrapperItemStack> possibleItems = new ArrayList<WrapperItemStack>();
    public static String lastErrorMessage;

    private PackMaterialComponent(String itemText) {
        if (itemText.startsWith("oredict:")) {
            this.qty = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
            itemText = itemText.substring(0, itemText.lastIndexOf(58));
            this.meta = 0;
            String oreName = itemText.substring("oredict:".length());
            List<WrapperItemStack> oreDictMaterials = InterfaceCore.getOredictMaterials(oreName);
            for (WrapperItemStack stack : oreDictMaterials) {
                stack.add(this.qty - 1);
            }
            this.possibleItems.addAll(oreDictMaterials);
        } else {
            this.qty = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
            itemText = itemText.substring(0, itemText.lastIndexOf(58));
            this.meta = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
            itemText = itemText.substring(0, itemText.lastIndexOf(58));
            this.possibleItems.add(InterfaceCore.getStackForProperties(itemText, this.meta, this.qty));
        }
    }

    public static List<PackMaterialComponent> parseFromJSON(AItemPack<?> item, boolean includeMain, boolean includeSub, boolean forCraftingCheck, boolean forRepair) {
        ArrayList<String> itemTexts = new ArrayList<String>();
        String currentSubName = "";
        if (forRepair) {
            if (((AJSONItem)item.definition).general.repairMaterials != null) {
                itemTexts.add("mts:" + item.getRegistrationName() + ":0:1");
                itemTexts.addAll(((AJSONItem)item.definition).general.repairMaterials);
            }
        } else {
            if (includeMain) {
                itemTexts.addAll(((AJSONItem)item.definition).general.materials);
            }
            if (includeSub && item instanceof AItemSubTyped) {
                itemTexts.addAll(((AItemSubTyped)item).getExtraMaterials());
                currentSubName = ((AItemSubTyped)item).subName;
            }
        }
        ArrayList<PackMaterialComponent> components = new ArrayList<PackMaterialComponent>();
        for (String itemText : itemTexts) {
            try {
                PackMaterialComponent component = new PackMaterialComponent(itemText);
                if (!component.possibleItems.isEmpty()) {
                    components.add(component);
                    continue;
                }
                lastErrorMessage = "No valid items found for " + (forRepair ? "repair" : "normal") + " crafting ingredient entry " + itemText + " for " + ((AJSONItem)item.definition).packID + ":" + ((AJSONItem)item.definition).systemName + currentSubName + ".  Crafting will be disabled in survival mode.  Report this to the pack author!";
                return null;
            }
            catch (Exception e) {
                lastErrorMessage = "A fault was encountered when trying to parse " + (forRepair ? "repair" : "normal") + " crafting ingredient entry " + itemText + " for " + ((AJSONItem)item.definition).packID + ":" + ((AJSONItem)item.definition).systemName + currentSubName + ".  Crafting will be disabled in survival mode.  Report this to the pack author!";
                return null;
            }
        }
        return components;
    }
}

