/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.rendering.components.RenderableModelObject;
import minecrafttransportsimulator.rendering.components.RenderableObject;
import minecrafttransportsimulator.rendering.components.RenderableTreadRoller;
import minecrafttransportsimulator.rendering.instances.ModelParserLT;
import minecrafttransportsimulator.rendering.instances.ModelParserOBJ;

public abstract class AModelParser {
    private static final Map<String, AModelParser> parsers = new HashMap<String, AModelParser>();
    public static final String ROLLER_OBJECT_NAME = "roller";
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String ONLINE_TEXTURE_OBJECT_NAME = "url";
    public static final String TRANSLUCENT_OBJECT_NAME = "translucent";

    public AModelParser() {
        parsers.put(this.getModelSuffix(), this);
    }

    protected abstract String getModelSuffix();

    protected abstract List<RenderableObject> parseModelInternal(String var1);

    public static List<RenderableObject> parseModel(String modelLocation) {
        AModelParser parser = parsers.get(modelLocation.substring(modelLocation.lastIndexOf(".") + 1));
        if (parser != null) {
            return parser.parseModelInternal(modelLocation);
        }
        throw new IllegalArgumentException("No parser found for model format of " + modelLocation.substring(modelLocation.lastIndexOf(".") + 1));
    }

    public static <AnimationEntity extends AEntityD_Definable<?>> List<RenderableModelObject<AnimationEntity>> generateRenderables(AEntityD_Definable<?> entity) {
        String modelLocation = ((AJSONMultiModelProvider)entity.definition).getModelLocation(entity.subName);
        List<RenderableObject> parsedModelObjects = AModelParser.parseModel(modelLocation);
        ArrayList<RenderableModelObject<AnimationEntity>> modelObjects = new ArrayList<RenderableModelObject<AnimationEntity>>();
        for (RenderableObject parsedObject : parsedModelObjects) {
            if (parsedObject.name.toLowerCase().contains(ROLLER_OBJECT_NAME)) {
                modelObjects.add(new RenderableTreadRoller<AnimationEntity>(modelLocation, parsedObject, modelObjects));
                continue;
            }
            modelObjects.add(new RenderableModelObject<AnimationEntity>(modelLocation, parsedObject, modelObjects));
        }
        return modelObjects;
    }

    static {
        new ModelParserOBJ();
        new ModelParserLT();
    }
}

