/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.mcinterface.InterfaceClient;
import minecrafttransportsimulator.mcinterface.InterfaceRender;
import org.lwjgl.opengl.GL11;

public abstract class ARenderEntity<RenderedEntity extends AEntityC_Renderable> {
    public final void render(RenderedEntity entity, boolean blendingEnabled, float partialTicks) {
        ((AEntityC_Renderable)entity).world.beginProfiling("RenderSetup", true);
        if (!this.disableRendering(entity, partialTicks)) {
            Point3d entityPositionDelta = ((AEntityC_Renderable)entity).prevPosition.getInterpolatedPoint(((AEntityC_Renderable)entity).position, partialTicks);
            entityPositionDelta.subtract(InterfaceClient.getRenderViewEntity().getRenderedPosition(partialTicks));
            Point3d entityRotation = ((AEntityC_Renderable)entity).prevAngles.getInterpolatedPoint(((AEntityC_Renderable)entity).angles, partialTicks);
            InterfaceRender.setLightingToPosition(((AEntityC_Renderable)entity).position);
            this.adjustPositionRotation(entity, entityPositionDelta, entityRotation, partialTicks);
            GL11.glPushMatrix();
            GL11.glTranslated((double)entityPositionDelta.x, (double)entityPositionDelta.y, (double)entityPositionDelta.z);
            GL11.glRotated((double)entityRotation.y, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)entityRotation.x, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)entityRotation.z, (double)0.0, (double)0.0, (double)1.0);
            ((AEntityC_Renderable)entity).world.endProfiling();
            this.renderModel(entity, blendingEnabled, partialTicks);
            GL11.glPopMatrix();
            if (!blendingEnabled && InterfaceRender.shouldRenderBoundingBoxes()) {
                ((AEntityC_Renderable)entity).world.beginProfiling("BoundingBoxes", true);
                this.renderBoundingBoxes(entity, entityPositionDelta);
                ((AEntityC_Renderable)entity).world.endProfiling();
            }
            ((AEntityC_Renderable)entity).world.beginProfiling("Sounds", true);
            ((AEntityB_Existing)entity).updateSounds(partialTicks);
        }
        ((AEntityC_Renderable)entity).world.endProfiling();
    }

    protected boolean disableRendering(RenderedEntity entity, float partialTicks) {
        return ((AEntityC_Renderable)entity).ticksExisted == 0L;
    }

    protected void adjustPositionRotation(RenderedEntity entity, Point3d entityPositionDelta, Point3d entityRotationDelta, float partialTicks) {
    }

    protected abstract void renderModel(RenderedEntity var1, boolean var2, float var3);

    protected abstract void renderBoundingBoxes(RenderedEntity var1, Point3d var2);
}

