/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONRendering;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.rendering.components.AModelParser;
import minecrafttransportsimulator.rendering.components.ARenderEntity;
import minecrafttransportsimulator.rendering.components.RenderableModelObject;
import minecrafttransportsimulator.rendering.instances.RenderInstrument;
import minecrafttransportsimulator.rendering.instances.RenderText;
import org.lwjgl.opengl.GL11;

public abstract class ARenderEntityDefinable<RenderedEntity extends AEntityD_Definable<?>>
extends ARenderEntity<RenderedEntity> {
    protected final Map<String, List<RenderableModelObject<RenderedEntity>>> objectLists = new HashMap<String, List<RenderableModelObject<RenderedEntity>>>();
    private static final List<ARenderEntityDefinable<?>> createdRenderers = new ArrayList();

    public ARenderEntityDefinable() {
        createdRenderers.add(this);
    }

    @Override
    protected void renderModel(RenderedEntity entity, boolean blendingEnabled, float partialTicks) {
        ((AEntityD_Definable)entity).world.beginProfiling("LightStateUpdates", true);
        ((AEntityD_Definable)entity).updateLightBrightness(partialTicks);
        ((AEntityD_Definable)entity).world.beginProfiling("ParsingMainModel", false);
        String modelLocation = ((AJSONMultiModelProvider)((AEntityD_Definable)entity).definition).getModelLocation(((AEntityD_Definable)entity).subName);
        if (!this.objectLists.containsKey(modelLocation)) {
            this.objectLists.put(modelLocation, AModelParser.generateRenderables(entity));
        }
        ((AEntityD_Definable)entity).world.beginProfiling("RenderingMainModel", false);
        List<RenderableModelObject<RenderedEntity>> map = this.objectLists.get(modelLocation);
        for (RenderableModelObject<RenderedEntity> modelObject : map) {
            JSONAnimatedObject animation = ((AEntityD_Definable)entity).animatedObjectDefinitions.get(modelObject.object.name);
            if (animation != null && animation.applyAfter != null) continue;
            modelObject.render(entity, blendingEnabled, partialTicks);
        }
        ((AEntityD_Definable)entity).world.beginProfiling("MainText", false);
        if (!blendingEnabled) {
            for (JSONText textDef : ((AEntityD_Definable)entity).text.keySet()) {
                if (textDef.attachedTo != null) continue;
                RenderText.draw3DText(((AEntityD_Definable)entity).text.get(textDef), entity, textDef, ((AEntityD_Definable)entity).scale, false);
            }
        }
        ((AEntityD_Definable)entity).world.beginProfiling("Instruments", false);
        this.renderInstruments(entity, blendingEnabled, partialTicks);
        ((AEntityD_Definable)entity).world.beginProfiling("Particles", false);
        ((AEntityD_Definable)entity).spawnParticles(partialTicks);
        ((AEntityD_Definable)entity).world.endProfiling();
        ((AEntityD_Definable)entity).world.beginProfiling("Sounds", false);
        ((AEntityD_Definable)entity).updateSounds(partialTicks);
        ((AEntityD_Definable)entity).world.endProfiling();
    }

    @Override
    protected boolean disableRendering(RenderedEntity entity, float partialTicks) {
        return super.disableRendering(entity, partialTicks) || ((AJSONMultiModelProvider)((AEntityD_Definable)entity).definition).rendering.modelType.equals((Object)JSONRendering.ModelType.NONE);
    }

    protected void renderInstruments(RenderedEntity entity, boolean blendingEnabled, float partialTicks) {
        if (entity instanceof AEntityE_Interactable) {
            AEntityE_Interactable interactable = (AEntityE_Interactable)entity;
            if (((AJSONInteractableEntity)interactable.definition).instruments != null) {
                for (int i = 0; i < ((AJSONInteractableEntity)interactable.definition).instruments.size(); ++i) {
                    if (!interactable.instruments.containsKey(i)) continue;
                    JSONInstrumentDefinition packInstrument = ((AJSONInteractableEntity)interactable.definition).instruments.get(i);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)packInstrument.pos.x, (double)packInstrument.pos.y, (double)packInstrument.pos.z);
                    GL11.glRotated((double)packInstrument.rot.x, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)(packInstrument.rot.y + 180.0), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)packInstrument.rot.z, (double)0.0, (double)0.0, (double)1.0);
                    if (RenderableModelObject.doPreRenderTransforms(entity, packInstrument.animations, blendingEnabled, partialTicks)) {
                        RenderInstrument.drawInstrument(interactable.instruments.get(i), packInstrument.optionalPartNumber, interactable, packInstrument.scale / 16.0f, blendingEnabled, partialTicks);
                    }
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @Override
    protected void renderBoundingBoxes(RenderedEntity entity, Point3d entityPositionDelta) {
        if (entity instanceof AEntityE_Interactable) {
            AEntityE_Interactable interactable = (AEntityE_Interactable)entity;
            GL11.glTranslated((double)entityPositionDelta.x, (double)entityPositionDelta.y, (double)entityPositionDelta.z);
            interactable.encompassingBox.renderable.render();
            GL11.glTranslated((double)(-entityPositionDelta.x), (double)(-entityPositionDelta.y), (double)(-entityPositionDelta.z));
            for (BoundingBox box : interactable.interactionBoxes) {
                Point3d boxCenterDelta = box.globalCenter.copy().subtract(((AEntityD_Definable)entity).position).add(entityPositionDelta);
                GL11.glTranslated((double)boxCenterDelta.x, (double)boxCenterDelta.y, (double)boxCenterDelta.z);
                box.renderable.render();
                GL11.glTranslated((double)(-boxCenterDelta.x), (double)(-boxCenterDelta.y), (double)(-boxCenterDelta.z));
            }
        }
    }

    private void resetModelCache(String modelLocation) {
        List<RenderableModelObject<RenderedEntity>> resetObjects = this.objectLists.remove(modelLocation);
        if (resetObjects != null) {
            for (RenderableModelObject<RenderedEntity> modelObject : resetObjects) {
                modelObject.destroy();
            }
        }
    }

    public static void clearObjectCaches(AJSONMultiModelProvider definition) {
        for (JSONSubDefinition subDef : definition.definitions) {
            String modelLocation = definition.getModelLocation(subDef.subName);
            for (ARenderEntityDefinable<?> render : createdRenderers) {
                super.resetModelCache(modelLocation);
            }
        }
    }
}

