/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.rendering.components.ARenderEntityDefinable;
import org.lwjgl.opengl.GL11;

public abstract class ARenderTileEntityBase<RenderedTileEntity extends ATileEntityBase<?>>
extends ARenderEntityDefinable<RenderedTileEntity> {
    public boolean translateToSlabs() {
        return true;
    }

    @Override
    public void adjustPositionRotation(RenderedTileEntity entity, Point3d entityPositionDelta, Point3d entityRotationDelta, float partialTicks) {
        entityPositionDelta.x += 0.5;
        entityPositionDelta.z += 0.5;
        if (this.translateToSlabs() && ((ATileEntityBase)entity).world.isBlockBottomSlab(((ATileEntityBase)entity).position.copy().add(0.0, -1.0, 0.0))) {
            entityPositionDelta.y -= 0.5;
        }
    }

    @Override
    protected void renderBoundingBoxes(RenderedTileEntity entity, Point3d entityPositionDelta) {
        super.renderBoundingBoxes(entity, entityPositionDelta);
        BoundingBox box = ((ATileEntityBase)entity).getCollisionBox();
        Point3d boxCenterDelta = box.globalCenter.copy().subtract(((ATileEntityBase)entity).position).add(entityPositionDelta);
        GL11.glTranslated((double)boxCenterDelta.x, (double)(boxCenterDelta.y + 0.5), (double)boxCenterDelta.z);
        box.renderable.render();
        GL11.glTranslated((double)(-boxCenterDelta.x), (double)(-boxCenterDelta.y - 0.5), (double)(-boxCenterDelta.z));
    }
}

