/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.components;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GIFParser {
    public static ParsedGIF parseGIF(ImageReader reader) throws IOException {
        IIOMetadataNode screenDescriptor;
        IIOMetadataNode globalRoot;
        NodeList globalScreenDescriptor;
        ArrayList<GIFImageFrame> frames = new ArrayList<GIFImageFrame>(2);
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null && (globalScreenDescriptor = (globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("LogicalScreenDescriptor")) != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            int delay = Integer.valueOf(gce.getAttribute("delayTime"));
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.valueOf(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.valueOf(map.getNamedItem("imageTopPosition").getNodeValue());
                }
            }
            masterGraphics.drawImage((Image)image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            frames.add(new GIFImageFrame(copy, delay, disposal));
            if (disposal.equals("restoreToPrevious")) {
                BufferedImage from = null;
                for (int i = frameIndex - 1; i >= 0; --i) {
                    if (((GIFImageFrame)frames.get(i)).getDisposal().equals("restoreToPrevious") && frameIndex != 0) continue;
                    from = ((GIFImageFrame)frames.get(i)).getImage();
                    break;
                }
                master = new BufferedImage(from.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else if (disposal.equals("restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
        reader.dispose();
        return !frames.isEmpty() ? new ParsedGIF(frames) : null;
    }

    private static class GIFImageFrame {
        private final int delay;
        private final BufferedImage image;
        private final String disposal;
        private final int glTexturePointer;

        private GIFImageFrame(BufferedImage image, int delay, String disposal) {
            this.image = image;
            this.delay = delay;
            this.disposal = disposal;
            this.glTexturePointer = TextureUtil.func_110996_a();
            TextureUtil.func_110989_a((int)this.glTexturePointer, (BufferedImage)image, (boolean)false, (boolean)false);
        }

        private BufferedImage getImage() {
            return this.image;
        }

        private int getDelay() {
            return this.delay;
        }

        private String getDisposal() {
            return this.disposal;
        }
    }

    public static class ParsedGIF {
        public final Map<Integer, GIFImageFrame> frames = new LinkedHashMap<Integer, GIFImageFrame>();
        public final int totalDuration;
        public long currentCycleTime;
        private long lastCycleCheck;

        private ParsedGIF(List<GIFImageFrame> frames) {
            int cumulativeDuration = 0;
            for (GIFImageFrame frame : frames) {
                this.frames.put(cumulativeDuration, frame);
                cumulativeDuration += frame.getDelay();
            }
            this.totalDuration = cumulativeDuration;
        }

        public int getCurrentTextureIndex() {
            long currentTime = System.currentTimeMillis() / 10L;
            this.currentCycleTime += currentTime - this.lastCycleCheck;
            this.lastCycleCheck = currentTime;
            if (this.currentCycleTime > (long)(this.totalDuration * 2)) {
                this.currentCycleTime = 0L;
            }
            while (this.currentCycleTime > (long)this.totalDuration) {
                this.currentCycleTime -= (long)this.totalDuration;
            }
            int lastDelayChecked = 0;
            for (Integer totalDelay : this.frames.keySet()) {
                if ((long)totalDelay.intValue() > this.currentCycleTime) {
                    return this.frames.get(lastDelayChecked).glTexturePointer;
                }
                lastDelayChecked = totalDelay;
            }
            return this.frames.get(lastDelayChecked).glTexturePointer;
        }
    }
}

